/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BackupUtils;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.catalog.CatalogDataSource;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.DataSourceKey;
import edu.mayo.bior.catalog.verification.CatalogVerifier;
import edu.mayo.bior.catalog.verification.MessageLogger;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;

public class MergeDataSourceProperties {
    private BuildInfo mBuildInfo;
    private StepLogger mStepLogger;
    private boolean mIsUpdateNecessary = false;
    private LinkedHashMap<DataSourceKey, String> mKeyToDescMap = new LinkedHashMap();
    private final List<DataSourceKey> KEYS_TO_NOT_OVERRIDE_FROM_PREVIOUS_CATALOG = Arrays.asList(DataSourceKey.ShortUniqueName, DataSourceKey.Version, DataSourceKey.DataSourceReleaseDate);

    public MergeDataSourceProperties(BuildInfo buildInfo, StepLogger stepLogger) {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = stepLogger;
        this.initDefaultDescriptionMap();
    }

    protected static File getDataSourcePropertiesFromCatalog(File prevCatalogFile) {
        if (prevCatalogFile == null) {
            return null;
        }
        return new File(prevCatalogFile.getParentFile(), prevCatalogFile.getName().replace(".tsv.bgz", ".datasource.properties"));
    }

    private void initDefaultDescriptionMap() {
        this.mKeyToDescMap.put(DataSourceKey.ShortUniqueName, "### Datasource properties file for Catalog - buildCatalog.allSteps.  Please fill in the descriptions to the keys below.\n## Short name that should be unique (or mostly unique except for fixes to existing catalog) across all catalogs. Ex: dbSNP_142_GRCh37p13");
        this.mKeyToDescMap.put(DataSourceKey.Description, "## Description of catalog.  Ex: NCBI's dbSNP Variant Database");
        this.mKeyToDescMap.put(DataSourceKey.Source, "## Source of data, without point release, etc.  Ex: dbSNP");
        this.mKeyToDescMap.put(DataSourceKey.Dataset, "## Type of data.  Ex: Variants");
        this.mKeyToDescMap.put(DataSourceKey.Version, "## Version of the data source.  Ex: 142");
        this.mKeyToDescMap.put(DataSourceKey.Build, "## The Genome build/assembly.  Ex: GRCh37.p13");
        this.mKeyToDescMap.put(DataSourceKey.Format, "## The BioR catalog compatibility format.  Ex: 1.1.1");
        this.mKeyToDescMap.put(DataSourceKey.DataSourceReleaseDate, "## The release date of the data source from the provider (not the BioR build date).  Ex: 2018-07-10");
    }

    public void mergeDatasourceProperties() throws Exception {
        CatalogDataSource catalogDataSrc;
        File currentFile = new File(this.mBuildInfo.getTargetDirectoryFile(), this.mBuildInfo.getCatalogPrefix() + ".datasource.properties");
        File defaultFile = new File(this.mBuildInfo.getTargetDirectoryFile() + "/" + "build", this.mBuildInfo.getCatalogPrefix() + ".datasource.properties.default");
        File prevCtgFile = null;
        if (this.mBuildInfo.getPreviousCatalogPath() != null) {
            prevCtgFile = MergeDataSourceProperties.getDataSourcePropertiesFromCatalog(new File(this.mBuildInfo.getPreviousCatalogPath()));
        }
        BackupUtils.backupCurrentFile(currentFile);
        PropertiesConfiguration buildInfoProps = this.getPropsFromBuildInfo(this.mBuildInfo);
        PropertiesConfiguration currentProps = this.loadProps(currentFile, true);
        PropertiesConfiguration defaultProps = this.loadProps(defaultFile, true);
        PropertiesConfiguration prevCtgProps = this.loadProps(prevCtgFile, false);
        List<String> defaultPropKeysUnused = this.toList(defaultProps.getKeys());
        List<String> prevCtgPropKeysUnused = this.toList(prevCtgProps.getKeys());
        Iterator currentKeys = currentProps.getKeys();
        for (DataSourceKey key : DataSourceKey.values()) {
            String val = this.getBestValue(key, buildInfoProps, currentProps, defaultProps, prevCtgProps);
            currentProps.setProperty(key.toString(), (Object)val);
            defaultPropKeysUnused.remove(key.toString());
            prevCtgPropKeysUnused.remove(key.toString());
            String desc = this.getBestDescription(key, currentProps, defaultProps, prevCtgProps);
            currentProps.getLayout().setComment(key.toString(), desc);
        }
        this.warnIfAnyDefaultKeysUnused(defaultPropKeysUnused, currentFile, defaultFile);
        this.warnIfAnyPreviousCatalogKeysUnused(prevCtgPropKeysUnused, currentFile, prevCtgFile);
        this.warnIfCurrentDiffersFromPrevious(currentProps, prevCtgProps);
        currentProps.save(currentFile);
        this.addTopMostCommentIfMissing(currentFile);
        this.removeSpacesAroundEquals(currentFile);
        String path = currentFile.getPath();
        if (BackupUtils.isCurrentSameAsLastBackup(currentFile)) {
            this.mStepLogger.logAndSummary(String.format("No changes made to '%s'", path));
            BackupUtils.removeLastBackup(currentFile);
        } else {
            this.mStepLogger.logAndSummary(String.format("Some changes made to '%s'", path));
        }
        try {
            catalogDataSrc = new CatalogDataSource(currentFile);
        }
        catch (CatalogFormatException e) {
            this.mStepLogger.logAndSummary(String.format("Datasource.properties file '%s' has some critical issues. See verify output for details.", path));
            return;
        }
        MessageLogger verifyLogger = new MessageLogger(new StringWriter());
        catalogDataSrc.verify(CatalogVerifier.VAL_TYPE.STRICT, verifyLogger);
        if (verifyLogger.hasErrors() || verifyLogger.hasWarnings()) {
            this.mStepLogger.logAndSummary(String.format("Datasource.properties file '%s' has some issues. See verify output for details.", path));
        }
    }

    private PropertiesConfiguration getPropsFromBuildInfo(BuildInfo buildInfo) throws IllegalStateException {
        PropertiesConfiguration buildInfoProps = new PropertiesConfiguration();
        buildInfoProps.setProperty(DataSourceKey.ShortUniqueName.toString(), (Object)this.getShortUniqueName(buildInfo));
        buildInfoProps.setProperty(DataSourceKey.Source.toString(), (Object)buildInfo.getDataSourceName());
        buildInfoProps.setProperty(DataSourceKey.Version.toString(), (Object)buildInfo.getDataSourceVersion());
        buildInfoProps.setProperty(DataSourceKey.Build.toString(), (Object)buildInfo.getDataSourceBuild());
        buildInfoProps.setProperty(DataSourceKey.Description.toString(), (Object)this.blankIfNull(buildInfo.getDataSourceDescription()));
        buildInfoProps.setProperty(DataSourceKey.Dataset.toString(), (Object)this.blankIfNull(buildInfo.getDataSourceDataset()));
        buildInfoProps.setProperty(DataSourceKey.DataSourceReleaseDate.toString(), (Object)this.blankIfNull(buildInfo.getDataSourceReleaseDate()));
        buildInfoProps.setProperty(DataSourceKey.Format.toString(), (Object)"");
        this.verifyAllDataSourceKeysSetInBuildInfoProps(buildInfoProps);
        return buildInfoProps;
    }

    private String blankIfNull(String s) {
        return s == null ? "" : s;
    }

    private void verifyAllDataSourceKeysSetInBuildInfoProps(PropertiesConfiguration buildInfoProps) throws IllegalStateException {
        for (DataSourceKey key : DataSourceKey.values()) {
            String val = (String)buildInfoProps.getProperty(key.name());
            if (val != null) continue;
            throw new IllegalStateException("Programming error:  DataSourceKey." + key.name() + " should be added from the build_info.txt data in MergeDataSourceProperties.getPropsFromBuildInfo().  It seems to have been forgotten.");
        }
    }

    protected String getShortUniqueName(BuildInfo buildInfo) {
        String DEFAULT_SOURCE = "DATASOURCENAME";
        String DEFAULT_VERSION = "VERSION";
        String DEFAULT_BUILD = "BUILD";
        String source = "DATASOURCENAME";
        if (this.isGiven(buildInfo.getDataSourceName())) {
            source = buildInfo.getDataSourceName();
        } else {
            this.mStepLogger.log("Warning: (datasource.properties): Building ShortUniqueName, but could not find a value for " + BuildInfoKey.DATA_SOURCE.name() + " in the build_info.txt file.  Using default: " + "DATASOURCENAME" + ".  Please update this in the datasource.properties file.");
        }
        String version = "VERSION";
        if (this.isGiven(buildInfo.getDataSourceVersion())) {
            version = buildInfo.getDataSourceVersion().replaceAll("[^A-Za-z0-9]", "");
        } else {
            this.mStepLogger.log("Warning: (datasource.properties): Building ShortUniqueName, but could not find a value for " + BuildInfoKey.DATA_SOURCE_VERSION.name() + " in the build_info.txt file.  Using default: " + "VERSION" + ".  Please update this in the datasource.properties file.");
        }
        String build = "BUILD";
        if (this.isGiven(buildInfo.getDataSourceBuild())) {
            build = buildInfo.getDataSourceBuild().replaceAll("[^A-Za-z0-9]", "");
        } else {
            this.mStepLogger.log("Warning: (datasource.properties): Building ShortUniqueName, but could not find a value for " + BuildInfoKey.DATA_SOURCE_BUILD.name() + " in the build_info.txt file.  Using default: " + "BUILD" + ".  Please update this in the datasource.properties file.");
        }
        String shortUniqueName = source + "_" + version + "_" + build;
        return shortUniqueName;
    }

    private void warnIfCurrentDiffersFromPrevious(PropertiesConfiguration currentProps, PropertiesConfiguration prevCtgProps) {
        Iterator keys = currentProps.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String currVal = currentProps.getString(key);
            String prevVal = prevCtgProps.getString(key);
            if (!this.isGiven(currVal) || !this.isGiven(prevVal) || currVal.equals(prevVal)) continue;
            this.mStepLogger.log("Note: (datasource.properties): '" + key + "' value is different between current ('" + currVal + "') and previous ('" + prevVal + "') catalog.");
        }
    }

    private void removeSpacesAroundEquals(File currentPropsFile) throws IOException {
        List lines = FileUtils.readLines((File)currentPropsFile);
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.startsWith("#") || line.indexOf("=") == -1 || line.indexOf("=") <= 0 || line.indexOf("=") != 1 + line.indexOf(" = ")) continue;
            lines.set(i, line.replace(" = ", "="));
        }
        FileUtils.writeLines((File)currentPropsFile, (Collection)lines);
    }

    private void warnIfAnyPreviousCatalogKeysUnused(List<String> prevCtgPropKeysUnused, File currentPropsFile, File prevCtgPropsFile) throws IOException {
        if (prevCtgPropKeysUnused.size() > 0) {
            this.log("These keys were found in the previous catalog file:");
            this.log("    " + prevCtgPropsFile.getCanonicalPath());
            this.log("but not in the current one:");
            this.log("    " + currentPropsFile.getCanonicalPath());
            this.log("--------:");
            for (String key : prevCtgPropKeysUnused) {
                this.log("    " + key);
            }
        }
    }

    private void warnIfAnyDefaultKeysUnused(List<String> defaultPropKeysUnused, File currentPropsFile, File defaultPropsFile) throws IOException {
        if (defaultPropKeysUnused.size() > 0) {
            this.mIsUpdateNecessary = true;
            this.log("These keys were found in the defaults file:");
            this.log("    " + defaultPropsFile.getCanonicalPath());
            this.log("but not in the current one:");
            this.log("    " + currentPropsFile.getCanonicalPath());
            this.log("--------:");
            for (String key : defaultPropKeysUnused) {
                this.log("    " + key);
            }
        }
    }

    private void addTopMostCommentIfMissing(File currentPropsFile) throws IOException {
        String currentProps = FileUtils.readFileToString((File)currentPropsFile);
        String topMostComment = "### Datasource properties file for Catalog - " + this.mBuildInfo.getCatalogPrefix() + ".  Please fill in the descriptions to the keys below.\n";
        if (!currentProps.startsWith("### Datasource properties file for Catalog -")) {
            currentProps = topMostComment + currentProps;
        }
        String CATALOG_PREFIX_VAR = "_CATALOG_PREFIX_";
        if (currentProps.contains("_CATALOG_PREFIX_")) {
            currentProps = currentProps.replace("_CATALOG_PREFIX_", this.mBuildInfo.getCatalogPrefix());
        }
        FileUtils.write((File)currentPropsFile, (CharSequence)currentProps);
    }

    private String getBestDescription(DataSourceKey key, PropertiesConfiguration currentProps, PropertiesConfiguration defaultProps, PropertiesConfiguration prevCtgProps) {
        String desc = currentProps.getLayout().getComment(key.toString());
        if (!this.isGiven(desc)) {
            this.log("Description/comment missing for key: '" + key.toString() + "'");
            String prevCtgDesc = prevCtgProps.getLayout().getComment(key.toString());
            String defaultDesc = defaultProps.getLayout().getComment(key.toString());
            if (this.isGiven(prevCtgDesc)) {
                desc = prevCtgDesc;
                this.log("    Using previous catalog description/comment: " + prevCtgDesc);
            } else if (this.isGiven(defaultDesc)) {
                desc = defaultDesc;
                this.log("    Using default description/comment: " + defaultDesc);
            } else {
                desc = this.mKeyToDescMap.get((Object)key);
                this.log("    Using hard-coded description/comment: " + desc);
            }
        }
        return desc;
    }

    private String getBestValue(DataSourceKey key, PropertiesConfiguration buildInfoProps, PropertiesConfiguration currentProps, PropertiesConfiguration defaultProps, PropertiesConfiguration prevCtgProps) {
        String val = currentProps.getString(key.toString());
        if (!this.isGiven(key, currentProps)) {
            if (this.isGiven(key, buildInfoProps)) {
                val = buildInfoProps.getString(key.toString());
                this.log("Note: (datasource.properties): Value for key '" + (Object)((Object)key) + "' coming from build_info.txt file with value: " + val);
                return val;
            }
            if (this.KEYS_TO_NOT_OVERRIDE_FROM_PREVIOUS_CATALOG.contains((Object)key)) {
                return val;
            }
            this.mIsUpdateNecessary = true;
            this.log("Warning: (datasource.properties): Key '" + (Object)((Object)key) + "' missing, or value is empty.  Attempting to add key and value...");
            if (this.isGiven(key, prevCtgProps)) {
                val = prevCtgProps.getString(key.toString());
                this.log("    Using the previous catalog key and value: " + val);
            } else if (this.isGiven(key, defaultProps)) {
                val = defaultProps.getString(key.toString());
                this.log("    Using the default catalog key and value: " + val);
            } else {
                val = "";
                this.log("    Could not find a value in the previous catalog or defaults, so setting it to empty");
            }
        }
        return val;
    }

    private List<String> toList(Iterator<String> keys) {
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasNext()) {
            keyList.add(keys.next());
        }
        return keyList;
    }

    private boolean isGiven(DataSourceKey key, PropertiesConfiguration props) {
        if (props == null) {
            return false;
        }
        String val = props.getString(key.toString());
        return val != null && val.trim().length() > 0;
    }

    private boolean isGiven(String s) {
        return s != null && s.trim().length() > 0;
    }

    private PropertiesConfiguration loadProps(File propsFile, boolean isShowErrorOnLoadFailure) throws Exception {
        PropertiesConfiguration props = new PropertiesConfiguration();
        try {
            if (propsFile != null) {
                props.load(propsFile);
            }
            this.replaceAnyDoubleQuotes(props, propsFile);
        }
        catch (Exception e) {
            String msg = "Could not load the data source properties file: " + (propsFile == null ? "(null)" : propsFile.getCanonicalPath());
            if (isShowErrorOnLoadFailure) {
                this.mIsUpdateNecessary = true;
                this.logAndSummary("ERROR: (datasource.properties): " + msg);
                throw e;
            }
            this.log("Warning: (datasource.properties): " + msg);
        }
        return props;
    }

    private void replaceAnyDoubleQuotes(PropertiesConfiguration props, File propsFile) throws IOException {
        Iterator keyIter = props.getKeys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String val = props.getString(key);
            if (!val.contains("\"")) continue;
            if (this.isQuotesJustOnEnds(val)) {
                val = val.substring(1, val.length() - 1);
            } else {
                String errorMsg = "Warning: the " + key + " value in datasource.properties contains a double-quote which could mess up any downstream VCF validators.  Converting these to single-quotes.  Offending value: [" + val + "] in file: " + propsFile.getCanonicalPath();
                this.log(errorMsg);
                System.err.println(errorMsg);
                val = val.replaceAll("\"", "'");
            }
            props.setProperty(key, (Object)val);
        }
    }

    private boolean isQuotesJustOnEnds(String val) {
        if (val == null) {
            return false;
        }
        return val.length() >= 2 && val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"';
    }

    private void log(String msg) {
        if (this.mStepLogger == null) {
            return;
        }
        this.mStepLogger.log(msg);
    }

    private void logAndSummary(String msg) {
        if (this.mStepLogger == null) {
            return;
        }
        this.mStepLogger.logAndSummary(msg);
    }
}

