/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BackupUtils;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.pipeline.exception.CatalogMetadataInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import edu.mayo.pipes.history.ColumnMetaDataVerificationMessages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class MergeColumnsTsv {
    private File mCatalogDir;
    private String mCatalogShortName;
    private File mPreviousCatalogColumnsTsv;
    private StepLogger mStepLogger;
    private boolean mIsUpdateNecessary = false;

    public MergeColumnsTsv(File catalogDir, String catalogShortName, File previousCatalogColumnsTsv, StepLogger stepLogger) {
        this.mCatalogDir = catalogDir;
        this.mCatalogShortName = catalogShortName;
        this.mPreviousCatalogColumnsTsv = previousCatalogColumnsTsv;
        this.mStepLogger = stepLogger;
    }

    public void mergeColumnsTsv() throws IOException, CatalogMetadataInputException {
        File currentColumnsFile = new File(this.mCatalogDir, this.mCatalogShortName + ".columns.tsv");
        File defaultColumnsFile = new File(this.mCatalogDir.getCanonicalPath() + "/" + "build", this.mCatalogShortName + ".columns.tsv.default");
        ColumnMetaDataOperations colMetaOps = new ColumnMetaDataOperations(currentColumnsFile);
        HashMap currentColInfo = colMetaOps.load();
        HashMap defaultColInfo = new ColumnMetaDataOperations(defaultColumnsFile).load();
        HashMap prevCtgColInfo = new HashMap();
        if (this.mPreviousCatalogColumnsTsv != null && this.mPreviousCatalogColumnsTsv.exists()) {
            prevCtgColInfo = new ColumnMetaDataOperations(this.mPreviousCatalogColumnsTsv).load();
        }
        ArrayList<String> defaultExtras = new ArrayList<String>(defaultColInfo.keySet());
        ArrayList<String> prevExtras = new ArrayList<String>(prevCtgColInfo.keySet());
        ArrayList currColNames = new ArrayList(currentColInfo.keySet());
        BackupUtils.backupCurrentFile(currentColumnsFile);
        ArrayList<ColumnMetaData> colMetaList = new ArrayList<ColumnMetaData>();
        for (String colKey : currColNames) {
            colMetaList.add(this.mergeColumn(colKey, currentColInfo, defaultColInfo, prevCtgColInfo));
            if (defaultColInfo.get(colKey) == null) {
                this.mStepLogger.log("Warning: (columns.tsv): Extra key?  '" + colKey + "' is in the current columns.tsv, but was not detected in the catalog (not in columns.tsv.defaults).");
                this.mIsUpdateNecessary = true;
            }
            if (defaultColInfo.get(colKey) == null && this.mPreviousCatalogColumnsTsv != null) {
                this.mStepLogger.log("Warning: (columns.tsv): Extra key?  '" + colKey + "' is in the current columns.tsv, but not in the previous catalog's columns.tsv.");
                this.mIsUpdateNecessary = true;
            }
            defaultExtras.remove(colKey);
            prevExtras.remove(colKey);
        }
        colMetaList.addAll(this.getDefaultsNotInCurrent(defaultExtras, defaultColInfo));
        this.logExtraDefaultColumns(defaultExtras, defaultColInfo);
        this.logAnyExtraPreviousColumns(prevExtras, prevCtgColInfo);
        this.save(currentColumnsFile, colMetaList, colMetaOps);
    }

    private void testPrint(String msg, List<ColumnMetaData> colMetaList) {
        System.out.println("================================");
        System.out.println(msg);
        for (ColumnMetaData col : colMetaList) {
            System.out.println(col.toString());
        }
    }

    private List<ColumnMetaData> getDefaultsNotInCurrent(List<String> defaultColNames, HashMap<String, ColumnMetaData> defaultColInfo) {
        ArrayList<ColumnMetaData> defaultsNotInCurrent = new ArrayList<ColumnMetaData>();
        for (String defaultCol : defaultColNames) {
            defaultsNotInCurrent.add(defaultColInfo.get(defaultCol));
        }
        return defaultsNotInCurrent;
    }

    private void logAnyExtraPreviousColumns(List<String> prevCtgColNames, HashMap<String, ColumnMetaData> prevCtgColInfo) {
        if (prevCtgColNames.size() > 0) {
            this.mIsUpdateNecessary = true;
            String msg = "Warning: (columns.tsv): These columns were present in the previous catalog's columns.tsv but not in the current columns.tsv:";
            this.mStepLogger.log(msg);
            for (String colName : prevCtgColNames) {
                this.mStepLogger.log("    " + prevCtgColInfo.get(colName));
            }
        }
    }

    private void logExtraDefaultColumns(List<String> defaultColNames, HashMap<String, ColumnMetaData> defaultColInfo) {
        if (defaultColNames.size() > 0) {
            this.mIsUpdateNecessary = true;
            String msg = "Warning: (columns.tsv): Some columns were detected in the catalog data (default columns.tsv) but not in the current columns.tsv.  These will be added to the current list.";
            this.mStepLogger.log(msg);
            for (String colName : defaultColNames) {
                this.mStepLogger.log("    " + defaultColInfo.get(colName));
            }
        }
    }

    private void save(File currentColumnsFile, List<ColumnMetaData> colMetaList, ColumnMetaDataOperations colMetaOps) throws IOException {
        this.sortColumnsById(colMetaList);
        colMetaOps.save(colMetaList, true);
        String path = currentColumnsFile.getPath();
        if (BackupUtils.isCurrentSameAsLastBackup(currentColumnsFile)) {
            this.mStepLogger.logAndSummary(String.format("No changes made to '%s'", path));
            BackupUtils.removeLastBackup(currentColumnsFile);
        } else {
            this.mStepLogger.logAndSummary(String.format("Some changes made to '%s'", path));
        }
        ColumnMetaDataVerificationMessages msgs = colMetaOps.verifyContents();
        if (msgs.getErrors().size() > 0 || msgs.getWarnings().size() > 0) {
            this.mStepLogger.logAndSummary(String.format("Columns.tsv file '%s' has some issues. See verify output for details.", path));
        }
    }

    private void sortColumnsById(List<ColumnMetaData> colMetaList) {
        Collections.sort(colMetaList, new Comparator<ColumnMetaData>(){

            @Override
            public int compare(ColumnMetaData o1, ColumnMetaData o2) {
                return o1.getColumnName().compareToIgnoreCase(o2.getColumnName());
            }
        });
    }

    private ColumnMetaData mergeColumn(String colName, HashMap<String, ColumnMetaData> currentColInfo, HashMap<String, ColumnMetaData> defaultColInfo, HashMap<String, ColumnMetaData> prevCtgColInfo) {
        ColumnMetaData colMeta = new ColumnMetaData(colName);
        ColumnMetaData currentColMeta = currentColInfo.get(colName);
        ColumnMetaData defaultColMeta = defaultColInfo.get(colName);
        ColumnMetaData prevCtgColMeta = prevCtgColInfo.get(colName);
        ColumnMetaData.Type currentType = ColumnMetaData.Type.valueOf((String)this.getValue(colName, ColumnMetaData.Headers.Type, currentColInfo));
        colMeta.setType(currentType);
        this.checkCurrentVsOthers(colName, ColumnMetaData.Headers.Type, currentColMeta, defaultColMeta, prevCtgColMeta);
        String currentCount = this.getValue(ColumnMetaData.Headers.Count, currentColMeta);
        colMeta.setCount(currentCount);
        this.checkCurrentVsOthers(colName, ColumnMetaData.Headers.Count, currentColMeta, defaultColMeta, prevCtgColMeta);
        colMeta.setDescription(this.getBestDescription(currentColMeta, defaultColMeta, prevCtgColMeta));
        colMeta.setHumanReadableName(this.getBestHumanReadableName(currentColMeta, defaultColMeta, prevCtgColMeta));
        return colMeta;
    }

    private String getBestDescription(ColumnMetaData currentColMeta, ColumnMetaData defaultColMeta, ColumnMetaData prevCtgColMeta) {
        String currentDescription = this.getValue(ColumnMetaData.Headers.Description, currentColMeta);
        String defaultDescription = this.getValue(ColumnMetaData.Headers.Description, defaultColMeta);
        String prevCtgDescription = this.getValue(ColumnMetaData.Headers.Description, prevCtgColMeta);
        if (this.isGiven(currentDescription)) {
            return currentDescription;
        }
        if (this.isGiven(prevCtgDescription)) {
            this.mStepLogger.log("Warning: (columns.tsv): Using the previous catalog's description for column '" + currentColMeta.getColumnName() + "'");
            this.mIsUpdateNecessary = true;
            return prevCtgDescription;
        }
        if (this.isGiven(defaultDescription)) {
            this.mStepLogger.log("Warning: (columns.tsv): Using the default catalog description for column '" + currentColMeta.getColumnName() + "'");
            this.mIsUpdateNecessary = true;
            return defaultDescription;
        }
        return "";
    }

    private String getBestHumanReadableName(ColumnMetaData currentColMeta, ColumnMetaData defaultColMeta, ColumnMetaData prevCtgColMeta) {
        String currentHumanReadableName = this.getValue(ColumnMetaData.Headers.HumanReadableName, currentColMeta);
        String defaultHumanReadableName = this.getValue(ColumnMetaData.Headers.HumanReadableName, defaultColMeta);
        String prevCtgHumanReadableName = this.getValue(ColumnMetaData.Headers.HumanReadableName, prevCtgColMeta);
        String colName = currentColMeta.getColumnName();
        if (this.isGiven(currentHumanReadableName) && !colName.equals(currentHumanReadableName)) {
            return currentHumanReadableName;
        }
        if (this.isGiven(prevCtgHumanReadableName) && !colName.equals(prevCtgHumanReadableName)) {
            this.mStepLogger.log("Warning: (columns.tsv): Using the previous catalog's HumanReadableName for column '" + currentColMeta.getColumnName() + "'");
            this.mIsUpdateNecessary = true;
            return prevCtgHumanReadableName;
        }
        if (this.isGiven(defaultHumanReadableName) && !colName.equals(defaultHumanReadableName)) {
            this.mStepLogger.log("Warning: (columns.tsv): Using the default catalog's HumanReadableName for column '" + currentColMeta.getColumnName() + "'");
            this.mIsUpdateNecessary = true;
            return defaultHumanReadableName;
        }
        return colName;
    }

    private void checkCurrentVsOthers(String colName, ColumnMetaData.Headers colHeader, ColumnMetaData current, ColumnMetaData defaults, ColumnMetaData previous) {
        String currentVal = this.getValue(colHeader, current);
        String defaultVal = this.getValue(colHeader, defaults);
        String prevCtgVal = this.getValue(colHeader, previous);
        if (defaultVal != null && !currentVal.equals(defaultVal)) {
            this.mStepLogger.log("Warning: (columns.tsv): Column " + colName + ":  The current *" + colHeader + "* is different from the default that was calculated from crawling all data in the catalog.");
            this.mStepLogger.log("    current " + colHeader + ": " + (currentVal == null ? "(none)" : currentVal));
            this.mStepLogger.log("    default " + colHeader + ": " + (defaultVal == null ? "(none)" : defaultVal));
        }
        if (this.mPreviousCatalogColumnsTsv != null && prevCtgVal != null && !currentVal.equals(prevCtgVal)) {
            this.mStepLogger.log("Warning: (columns.tsv): Column " + colName + ": The current *" + colHeader + "* is different from the same column in the previous catalog.");
            this.mStepLogger.log("    current  " + colHeader + ": " + (currentVal == null ? "(none)" : currentVal));
            this.mStepLogger.log("    previous " + colHeader + ": " + (prevCtgVal == null ? "(none)" : prevCtgVal));
        }
    }

    private boolean isGiven(String currentVal) {
        return currentVal != null && currentVal.trim().length() > 0 && !currentVal.equals(".");
    }

    private String getValue(String columnName, ColumnMetaData.Headers colHeader, HashMap<String, ColumnMetaData> colNameToMetaMap) {
        if (colNameToMetaMap == null) {
            return null;
        }
        ColumnMetaData colMeta = colNameToMetaMap.get(columnName);
        if (colMeta == null) {
            return null;
        }
        return this.getValue(colHeader, colMeta);
    }

    private String getValue(ColumnMetaData.Headers colHeader, ColumnMetaData colMeta) {
        if (colMeta == null) {
            return null;
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.ColumnName)) {
            return colMeta.getColumnName();
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.Type)) {
            return colMeta.getType().toString();
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.Count)) {
            return colMeta.getCount();
        }
        if (colHeader.equals((Object)ColumnMetaData.Headers.Description)) {
            return colMeta.getDescription();
        }
        return colMeta.getHumanReadableName();
    }
}

