/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import java.util.HashSet;
import java.util.Set;

public enum BuildInfoKey {
    MAKE_JSON_SCRIPT_PATH(true, true),
    MAKE_JSON_ARGS(true, false),
    MAKE_JSON_OUTPUT_FILE_PATH(false, false),
    TARGET_DIR(false, false),
    TEMP_DIR(false, false),
    DATA_SOURCE(true, true),
    DATA_SOURCE_VERSION(true, true),
    DATA_SOURCE_BUILD(true, false),
    DATA_SOURCE_DESCRIPTION(false, false),
    DATA_SOURCE_RELEASE_DATE(false, false),
    DATA_SOURCE_DATASET(false, false),
    CATALOG_PREFIX(true, true),
    INDEXES(false, false),
    PREVIOUS_CATALOG_PATH(false, false),
    SORT_ROWS(false, false),
    PATH(false, false),
    REFDATA_PATH(false, false),
    SHARED_CLUSTER_DIR(false, false),
    FINAL_FORMAT(false, false);

    private boolean required;
    private boolean nonEmptyValueRequired;

    private BuildInfoKey(boolean required, boolean nonEmptyValueRequired) {
        this.required = required;
        this.nonEmptyValueRequired = nonEmptyValueRequired;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isNonEmptyValueRequired() {
        return this.nonEmptyValueRequired;
    }

    public static Set<BuildInfoKey> getRequiredKeys() {
        HashSet<BuildInfoKey> requiredKeys = new HashSet<BuildInfoKey>();
        for (BuildInfoKey key : BuildInfoKey.values()) {
            if (!key.isRequired()) continue;
            requiredKeys.add(key);
        }
        return requiredKeys;
    }

    public static Set<BuildInfoKey> getNonEmptyValueRequiredKeys() {
        HashSet<BuildInfoKey> requiredKeys = new HashSet<BuildInfoKey>();
        for (BuildInfoKey key : BuildInfoKey.values()) {
            if (!key.isNonEmptyValueRequired()) continue;
            requiredKeys.add(key);
        }
        return requiredKeys;
    }
}

