/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import com.google.common.base.Joiner;
import com.jayway.jsonpath.InvalidPathException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildInfoKey;
import edu.mayo.bior.buildcatalog.TempDirectory;
import edu.mayo.bior.util.validation.CatalogFileValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BuildInfo {
    private static Logger sLogger = Logger.getLogger(BuildInfo.class);
    private Map<String, String> mKeyMap = new HashMap<String, String>();
    private File mMakeJsonScriptPathFile;
    protected static final String DEFAULT_MAKE_JSON_OUTPUT_FILENAME = "make_json_output.tsv";
    private static final String BUILD_CATALOG_DIR = "bior_build_catalog_tmp";
    private File mWorkingTempDir;
    private File mTargetDirFile;
    private int inputJSONColumnNum = -1;
    private String chromosomeSortOrderFileName;
    private boolean sortCatalogOnCreate = true;
    private boolean isInputFileAlreadyInFinalCtgFormatAndBgzipped = false;

    public BuildInfo(Map<String, String> inputMap) throws BuildCatalogStepInputException {
        this.copyMapToMap(inputMap);
        this.verifyData(null);
        this.resolveRelativePaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildInfo(String buildInfoPath) throws BuildCatalogStepInputException, IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(buildInfoPath);
            Properties tempProperties = new Properties();
            tempProperties.load(fin);
            this.putPropertiesInMap(tempProperties);
            this.resolveRelativePaths();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fin);
        this.verifyData(buildInfoPath);
        this.resolveRelativePaths();
    }

    private void resolveRelativePaths() throws BuildCatalogStepInputException {
        String currentPath = "";
        try {
            List<BuildInfoKey> pathsToResolve = Arrays.asList(BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH, BuildInfoKey.MAKE_JSON_SCRIPT_PATH, BuildInfoKey.PREVIOUS_CATALOG_PATH, BuildInfoKey.TARGET_DIR, BuildInfoKey.TEMP_DIR);
            for (BuildInfoKey key : pathsToResolve) {
                if (!this.isGiven(key)) continue;
                currentPath = this.getVal(key);
                String canonicalPath = new File(currentPath).getCanonicalPath();
                this.mKeyMap.put(key.name(), canonicalPath);
            }
        }
        catch (Exception e) {
            String msg = "Could not canonicalize the path: " + currentPath;
            sLogger.error((Object)msg);
            throw new BuildCatalogStepInputException(msg, e);
        }
    }

    private boolean isGiven(BuildInfoKey key) {
        String val = this.getVal(key);
        return val != null && val.length() > 0;
    }

    private void putPropertiesInMap(Properties properties) {
        for (Object key : properties.keySet()) {
            String val = properties.getProperty((String)key);
            this.mKeyMap.put((String)key, val);
            if (this.isRecognizedKey((String)key)) continue;
            String msg = "Warning: Unrecognized key in build_info.txt file: " + key.toString();
            sLogger.warn((Object)msg);
            System.err.println(msg);
        }
    }

    private void copyMapToMap(Map<String, String> inputMap) {
        for (String key : inputMap.keySet()) {
            String val = inputMap.get(key);
            if (val == null) continue;
            this.mKeyMap.put(key, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String buildInfoPath) throws IOException {
        Properties props = this.getPropertiesFromFields();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(buildInfoPath));
            props.store(fout, "## Build Info file for BioR build catalog command");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fout);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fout);
    }

    private void verifyData(String buildInfoPath) throws BuildCatalogStepInputException {
        this.verifyRequiredKeys(buildInfoPath);
        this.verifyRequiredNonEmptyValues(buildInfoPath);
        this.validateSettingsAndGenerateDefaults();
    }

    private void verifyRequiredKeys(String buildInfoPath) throws BuildCatalogStepInputException {
        ArrayList<BuildInfoKey> keysNotFound = new ArrayList<BuildInfoKey>();
        for (BuildInfoKey reqKey : BuildInfoKey.getRequiredKeys()) {
            String val = this.getVal(reqKey);
            if (val != null) continue;
            keysNotFound.add(reqKey);
        }
        this.throwInputExceptionIfNotEmpty(buildInfoPath, "is missing", keysNotFound);
    }

    private void verifyRequiredNonEmptyValues(String buildInfoPath) throws BuildCatalogStepInputException {
        ArrayList<BuildInfoKey> keysWithoutValues = new ArrayList<BuildInfoKey>();
        for (BuildInfoKey reqKey : BuildInfoKey.getNonEmptyValueRequiredKeys()) {
            String val = this.getVal(reqKey);
            if (!StringUtils.isBlank((String)val)) continue;
            keysWithoutValues.add(reqKey);
        }
        this.throwInputExceptionIfNotEmpty(buildInfoPath, "has an empty value for", keysWithoutValues);
    }

    private void throwInputExceptionIfNotEmpty(String buildInfoPath, String msgPart, List<BuildInfoKey> keysWithProblem) throws BuildCatalogStepInputException {
        if (!keysWithProblem.isEmpty()) {
            String keyDescription = BuildInfo.composeItemNumDescription("key", keysWithProblem.size());
            String error = "Error: ";
            error = !StringUtils.isBlank((String)buildInfoPath) ? error + "file '" + buildInfoPath + "'" : error + "data supplied to create BuildInfo object";
            throw new BuildCatalogStepInputException(String.format("%s %s %s: %s", error, msgPart, keyDescription, Joiner.on((String)", ").join(keysWithProblem)));
        }
    }

    private void validateSettingsAndGenerateDefaults() throws BuildCatalogStepInputException {
        this.validateJsonScriptPath();
        this.validateTempDirOrGenerate();
        this.validateJsonOutputPathOrGenerate();
        this.validateTargetDirOrGenerate();
        this.validatePreviousCatalogPath();
        this.validateSortRowsFlag();
    }

    private void validateSortRowsFlag() throws BuildCatalogStepInputException {
        String sortRowsFlag = this.getVal(BuildInfoKey.SORT_ROWS);
        if (sortRowsFlag != null && !sortRowsFlag.equalsIgnoreCase("true") && !sortRowsFlag.equalsIgnoreCase("false")) {
            throw new BuildCatalogStepInputException(BuildInfoKey.SORT_ROWS.toString() + " key was specified but should have a value of either 'true' or 'false'");
        }
    }

    private boolean isRecognizedKey(String key) {
        try {
            BuildInfoKey.valueOf(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void validatePreviousCatalogPath() throws BuildCatalogStepInputException {
        String previousCatalogPath = this.getPreviousCatalogPath();
        if (!StringUtils.isBlank((String)previousCatalogPath)) {
            File previousCatalogFile = new File(previousCatalogPath);
            if (!previousCatalogFile.exists()) {
                throw new BuildCatalogStepInputException(String.format("Could not find '%s' from %s", new Object[]{previousCatalogPath, BuildInfoKey.PREVIOUS_CATALOG_PATH}));
            }
            if (!CatalogFileValidator.hasExpectedSuffix(previousCatalogPath)) {
                throw new BuildCatalogStepInputException(String.format("'%s' from %s does not have expected catalog suffix '%s'", new Object[]{previousCatalogPath, BuildInfoKey.PREVIOUS_CATALOG_PATH, ".tsv.bgz"}));
            }
        }
    }

    private void validateTargetDirOrGenerate() throws BuildCatalogStepInputException {
        File targetDirFile;
        String targetDir = this.getTargetDirectory();
        if (StringUtils.isBlank((String)targetDir)) {
            targetDir = ".";
            this.mKeyMap.put(BuildInfoKey.TARGET_DIR.name(), targetDir);
        }
        if (!(targetDirFile = new File(targetDir)).exists()) {
            throw new BuildCatalogStepInputException(String.format("Could not find dir '%s' from %s", new Object[]{targetDir, BuildInfoKey.TARGET_DIR}));
        }
        if (!targetDirFile.isDirectory()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not a directory", new Object[]{targetDir, BuildInfoKey.TARGET_DIR}));
        }
        if (!targetDirFile.canWrite()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not writeable", new Object[]{targetDir, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
        }
        if (!targetDirFile.canRead()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not readable", new Object[]{targetDir, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
        }
        if (!targetDirFile.canExecute()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not executable", new Object[]{targetDir, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
        }
        this.mTargetDirFile = targetDirFile;
    }

    private void validateJsonOutputPathOrGenerate() throws BuildCatalogStepInputException {
        String outputPath = this.getMakeJsonOutputFilePath();
        if (!StringUtils.isBlank((String)outputPath)) {
            File outputFile = new File(outputPath);
            if (outputFile.exists() && outputFile.isDirectory()) {
                throw new BuildCatalogStepInputException(String.format("'%s' from %s is a directory, not a file", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
            File parentDir = outputFile.getParentFile();
            if (parentDir != null && parentDir.exists() && !parentDir.canWrite()) {
                throw new BuildCatalogStepInputException(String.format("Parent dir for '%s' from %s is not writeable", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
            if (parentDir != null && parentDir.exists() && !parentDir.canRead()) {
                throw new BuildCatalogStepInputException(String.format("Parent dir for '%s' from %s is not readable", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
            if (parentDir != null && parentDir.exists() && !parentDir.canExecute()) {
                throw new BuildCatalogStepInputException(String.format("Parent dir for '%s' from %s is not executable", new Object[]{outputPath, BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH}));
            }
        } else {
            File outputFile = new File(this.getWorkingTempDirectory(), DEFAULT_MAKE_JSON_OUTPUT_FILENAME);
            this.mKeyMap.put(BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH.name(), outputFile.getPath());
        }
    }

    private void validateTempDirOrGenerate() throws BuildCatalogStepInputException {
        File workingTempDir;
        File baseTempDirFile;
        String tempDir = this.getBaseTempDirectory();
        if (StringUtils.isBlank((String)tempDir)) {
            try {
                baseTempDirFile = new File(TempDirectory.findBaseTempDir(BUILD_CATALOG_DIR));
            }
            catch (InvalidPathException e) {
                throw new BuildCatalogStepInputException(e.getMessage());
            }
            this.mKeyMap.put(BuildInfoKey.TEMP_DIR.name(), baseTempDirFile.getPath());
        } else {
            baseTempDirFile = new File(tempDir);
        }
        if (!baseTempDirFile.exists() && !baseTempDirFile.mkdirs()) {
            throw new BuildCatalogStepInputException(String.format("Could not create temp dir '%s'. It is likely due to permissions.", this.getBaseTempDirectory()));
        }
        if (!baseTempDirFile.isDirectory()) {
            throw new BuildCatalogStepInputException(String.format("'%s' from %s is not a directory", new Object[]{this.getBaseTempDirectory(), BuildInfoKey.TEMP_DIR}));
        }
        try {
            workingTempDir = File.createTempFile("tmp_", "_bior_build_catalog", baseTempDirFile);
            if (!workingTempDir.delete()) {
                sLogger.error((Object)"Trying to delete a temp file made from File.createTempFile but couldn't delete the file using File.delete");
                sLogger.error((Object)"A more generic message is put in the exception");
                throw new BuildCatalogStepInputException("Had trouble creating a temporary working directory in " + this.getBaseTempDirectory());
            }
            if (!workingTempDir.mkdir()) {
                sLogger.error((Object)"Trying to create a temp working directory but couldn't make the directory with File.mkdir");
                sLogger.error((Object)"A more generic message is put in the exception");
                throw new BuildCatalogStepInputException("Had trouble creating a temporary working directory in " + this.getBaseTempDirectory());
            }
        }
        catch (IOException e) {
            throw new BuildCatalogStepInputException("Had trouble creating a temporary working directory in " + this.getBaseTempDirectory());
        }
        this.mWorkingTempDir = workingTempDir;
        this.mKeyMap.put(BuildInfoKey.TEMP_DIR.name(), this.mWorkingTempDir.getAbsolutePath());
    }

    private void validateJsonScriptPath() throws BuildCatalogStepInputException {
        String scriptPath = this.getMakeJsonScriptPath();
        File scriptPathFile = new File(scriptPath);
        if (!scriptPathFile.exists()) {
            throw new BuildCatalogStepInputException(String.format("Error: could not find script '%s' from %s", new Object[]{scriptPath, BuildInfoKey.MAKE_JSON_SCRIPT_PATH}));
        }
        if (!scriptPathFile.canExecute()) {
            throw new BuildCatalogStepInputException(String.format("Error: script '%s' from %s is not executable: ", new Object[]{scriptPath, BuildInfoKey.MAKE_JSON_SCRIPT_PATH}));
        }
        this.mMakeJsonScriptPathFile = scriptPathFile;
    }

    private static String composeItemNumDescription(String baseDescription, int numItems) {
        if (numItems == 1) {
            return baseDescription;
        }
        return baseDescription + "s";
    }

    File getMakeJsonScriptPathFile() {
        return this.mMakeJsonScriptPathFile;
    }

    String getMakeJsonScriptPath() {
        return this.getVal(BuildInfoKey.MAKE_JSON_SCRIPT_PATH);
    }

    String getMakeJsonArgs() {
        return this.getVal(BuildInfoKey.MAKE_JSON_ARGS);
    }

    String getMakeJsonOutputFilePath() {
        return this.getVal(BuildInfoKey.MAKE_JSON_OUTPUT_FILE_PATH);
    }

    public String getTargetDirectory() {
        return this.getVal(BuildInfoKey.TARGET_DIR);
    }

    File getTargetDirectoryFile() {
        return this.mTargetDirFile;
    }

    String getBaseTempDirectory() {
        return this.getVal(BuildInfoKey.TEMP_DIR);
    }

    File getWorkingTempDirectory() {
        return this.mWorkingTempDir;
    }

    String getDataSourceName() {
        return this.getVal(BuildInfoKey.DATA_SOURCE);
    }

    String getDataSourceVersion() {
        return this.getVal(BuildInfoKey.DATA_SOURCE_VERSION);
    }

    String getDataSourceBuild() {
        return this.getVal(BuildInfoKey.DATA_SOURCE_BUILD);
    }

    String getDataSourceReleaseDate() {
        return this.getVal(BuildInfoKey.DATA_SOURCE_RELEASE_DATE);
    }

    public String getCatalogPrefix() {
        return this.getVal(BuildInfoKey.CATALOG_PREFIX);
    }

    List<String> getIndexes() {
        return BuildInfo.splitByCommaAndTrim(this.getVal(BuildInfoKey.INDEXES));
    }

    private static List<String> splitByCommaAndTrim(String s) {
        String[] vals;
        ArrayList<String> valList = new ArrayList<String>();
        if (s == null || s.length() <= 0) {
            return valList;
        }
        for (String val : vals = s.split(",")) {
            String eachIndex = val.trim();
            if (eachIndex.length() <= 0) continue;
            valList.add(eachIndex);
        }
        return valList;
    }

    String getPreviousCatalogPath() {
        return this.getVal(BuildInfoKey.PREVIOUS_CATALOG_PATH);
    }

    int getinputJSONColumnNum() {
        return this.inputJSONColumnNum;
    }

    void setInputJSONColumnNum(int inputJSONColumnNum) {
        this.inputJSONColumnNum = inputJSONColumnNum;
    }

    String getChromosomeSortOrderFileName() {
        return this.chromosomeSortOrderFileName;
    }

    void setChromosomeSortOrderFileName(String chromosomeSortOrderFileName) {
        this.chromosomeSortOrderFileName = chromosomeSortOrderFileName;
    }

    boolean getSortCatalogOnCreate() {
        String isSortStr = this.getVal(BuildInfoKey.SORT_ROWS);
        if (isSortStr != null) {
            return "TRUE".equalsIgnoreCase(isSortStr);
        }
        return this.sortCatalogOnCreate;
    }

    void setSortCatalogOnCreate(String sortOnCreate) {
        if (sortOnCreate.toUpperCase().equals("TRUE")) {
            this.sortCatalogOnCreate = true;
        } else if (sortOnCreate.toUpperCase().equals("FALSE")) {
            this.sortCatalogOnCreate = false;
        }
    }

    boolean getInFinalFormat() {
        String isFinalFormatStr = this.getVal(BuildInfoKey.FINAL_FORMAT);
        if (isFinalFormatStr != null) {
            return "TRUE".equalsIgnoreCase(isFinalFormatStr);
        }
        return this.isInputFileAlreadyInFinalCtgFormatAndBgzipped;
    }

    void setInFinalFormat(String inFinalFormat) {
        if (inFinalFormat.toUpperCase().equals("TRUE")) {
            this.isInputFileAlreadyInFinalCtgFormatAndBgzipped = true;
        } else if (inFinalFormat.toUpperCase().equals("FALSE")) {
            this.isInputFileAlreadyInFinalCtgFormatAndBgzipped = false;
        }
    }

    private Properties getPropertiesFromFields() throws IOException {
        Properties props = new Properties();
        for (BuildInfoKey key : BuildInfoKey.values()) {
            String val = this.getVal(key);
            if (val == null) continue;
            props.setProperty(key.name(), val);
        }
        return props;
    }

    public Map<String, String> getMap() {
        return this.mKeyMap;
    }

    public String getVal(BuildInfoKey key) {
        return this.mKeyMap.get(key.name());
    }

    public String getDataSourceDescription() {
        return this.getVal(BuildInfoKey.DATA_SOURCE_DESCRIPTION);
    }

    public String getDataSourceDataset() {
        return this.getVal(BuildInfoKey.DATA_SOURCE_DATASET);
    }
}

