/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import com.google.common.base.Preconditions;
import edu.mayo.sage.Protocol;
import edu.mayo.sage.SagePropertyException;
import edu.mayo.sage.UsageLogger;
import edu.mayo.sage.UsageLoggerBuilder;
import edu.mayo.sage.UsageLoggerUtils;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Usage {
    public static final String KEY_APP = "app";
    public static final String KEY_VER = "ver";
    public static final String KEY_EVENT = "evt";
    public static final String KEY_MEM = "mem";
    public static final String KEY_USER = "user";
    public static final String KEY_EXIT_STATUS = "exit_status";
    public static final String KEY_ERROR = "error";
    public static final String KEY_PID = "pid";
    public static final String KEY_SESSION = "session";
    public static final String EVENT_BEGIN = "EVENT_BEGIN";
    public static final String EVENT_END = "EVENT_END";
    public static final String EVENT_ERROR = "ERROR";
    public static final String SERVER_PROP_NAME = "SAGE_SERVER";
    public static final String PORT_PROP_NAME = "SAGE_PORT";
    public static final int PORT_DEFAULT = 33124;
    public static final String PROTOCOL_PROP_NAME = "SAGE_PROTOCOL";
    public static final Protocol PROTOCOL_DEFAULT = Protocol.UDP;
    public static final String FAIL_ON_ERROR_PROP_NAME = "SAGE_FAIL_ON_ERROR";
    public static final boolean FAIL_ON_ERROR_DEFAULT = true;
    private static String serverHost = null;
    private static int serverPort = 33124;
    private static Protocol protocol = PROTOCOL_DEFAULT;
    private static boolean failOnError = true;

    public static void clear() {
        serverHost = null;
        serverPort = 33124;
        protocol = PROTOCOL_DEFAULT;
        failOnError = true;
    }

    public static void setServerHost(String inServer) throws SagePropertyException {
        new UsageLoggerBuilder().serverHost(inServer);
        serverHost = inServer;
    }

    public static String getServerHost() {
        return serverHost;
    }

    public static void setServerPort(int inPort) throws SagePropertyException {
        new UsageLoggerBuilder().serverPort(inPort);
        serverPort = inPort;
    }

    public static int getServerPort() {
        return serverPort;
    }

    public static void setProtocol(Protocol inProtocol) {
        Preconditions.checkNotNull((Object)((Object)inProtocol));
        protocol = inProtocol;
    }

    public static Protocol getProtocol() {
        return protocol;
    }

    public static void setFailOnError(boolean inFailOnError) {
        failOnError = inFailOnError;
    }

    public static boolean getFailOnError() {
        return failOnError;
    }

    public static void setProperties(Properties properties) throws SagePropertyException {
        String failOnErrorStringValue;
        String protocolStringValue;
        String portStringValue;
        String serverValue = properties.getProperty(SERVER_PROP_NAME);
        if (serverValue != null) {
            Usage.setServerHost(serverValue);
        }
        if ((portStringValue = properties.getProperty(PORT_PROP_NAME)) != null) {
            Usage.setServerPort(UsageLoggerUtils.intFromString(portStringValue, PORT_PROP_NAME));
        }
        if ((protocolStringValue = properties.getProperty(PROTOCOL_PROP_NAME)) != null) {
            Usage.setProtocol(Protocol.protocolFromString(protocolStringValue, PROTOCOL_PROP_NAME));
        }
        if ((failOnErrorStringValue = properties.getProperty(FAIL_ON_ERROR_PROP_NAME)) != null) {
            Usage.setFailOnError(UsageLoggerUtils.booleanFromString(failOnErrorStringValue, FAIL_ON_ERROR_PROP_NAME));
        }
    }

    public static UsageLogger logger() {
        UsageLoggerBuilder builder = new UsageLoggerBuilder().serverHost(Usage.getServerHost()).serverPort(Usage.getServerPort());
        return builder.protocol(Usage.getProtocol()).failOnError(Usage.getFailOnError()).logger();
    }

    public static void logBegin(String appName) {
        Usage.logger().logBegin(appName);
    }

    public static void logBegin(String appName, Map<String, Object> data) {
        Usage.logger().logBegin(appName, data);
    }

    public static void logBegin(String appName, Object ... data) {
        Usage.logger().logBegin(appName, data);
    }

    public static void logEnd(String appName) {
        Usage.logger().logEnd(appName);
    }

    public static void logEnd(String appName, Map<String, Object> data) {
        Usage.logger().logEnd(appName, data);
    }

    public static void logEnd(String appName, Object ... data) {
        Usage.logger().logEnd(appName, data);
    }

    public static void logEvent(String appName, String event) {
        Usage.logger().logEvent(appName, event);
    }

    public static void logEvent(String appName, String event, Map<String, Object> data) {
        Usage.logger().logEvent(appName, event, data);
    }

    public static void logEvent(String appName, String event, Object ... data) {
        Usage.logger().logEvent(appName, event, data);
    }

    public static void logError(String appName, Throwable t, int exitStatus) {
        Usage.logger().logError(appName, t, exitStatus);
    }
}

