/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.math.Conv;
import java.util.Calendar;

public class TimeAndDate {
    private Calendar cal = Calendar.getInstance();
    private String dayOfTheWeek = null;
    private int dayOfTheMonth = 0;
    private String monthOfTheYear = null;
    private int monthAsInteger = 0;
    private int year = 0;
    private String fullDate = null;
    private String date = null;
    private String shortDateUK = null;
    private String shortDateUS = null;
    private String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int hour24 = -1;
    private String hour12 = null;
    private int minute = -1;
    private int second = -1;
    private int millisecond = -1;
    private String shortTime24 = null;
    private String shortTime12 = null;
    private String midTime24 = null;
    private String midTime12 = null;
    private String fullTime24 = null;
    private String fullTime12 = null;
    private long tStart = 0L;
    private boolean startCheck = false;
    private long tEnd = 0L;
    private boolean endCheck = false;
    private long totalTime = 0L;
    private String changeDate = null;
    private boolean backForw = true;
    private int easterMonth = 0;
    private int easterDay = 0;
    private String easterDayName = null;
    private int yearHold = 0;
    private int monthHold = 0;
    private int dayHold = 0;
    private String dayNameHold = null;

    public void waitFor(int nSeconds) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < (long)(nSeconds * 1000)) {
        }
    }

    public void waitFor(long nSeconds) {
        long t1;
        if (nSeconds > 9223372036854775L) {
            System.out.println("Class: TimeAndDate, method: wait(long nSeconds), nSeconds is too large for this method - the value has been replaced by 9223372036854775");
            nSeconds = 9223372036854775L;
        }
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < nSeconds * 1000L) {
        }
    }

    public void waitFor(double nSeconds) {
        long t1;
        long tt = 0L;
        if (nSeconds > Math.pow(2.0, 63.0) - 1.0) {
            System.out.println("Class: TimeAndDate, method: wait(double nSeconds), nSeconds is too large for this method - the value has been replaced by 9223372036854775");
            tt = Long.MAX_VALUE;
        } else {
            tt = Conv.convert_double_to_long(nSeconds * 1000.0);
        }
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < tt) {
        }
    }

    public void blocStart() {
        this.tStart = System.currentTimeMillis();
        this.startCheck = true;
    }

    public long blocEnd() {
        if (!this.startCheck) {
            throw new IllegalArgumentException("No start marker has been set");
        }
        this.tEnd = System.currentTimeMillis();
        this.totalTime = this.tEnd - this.tStart;
        this.endCheck = true;
        return this.totalTime;
    }

    public long blocTime() {
        if (this.endCheck) {
            return this.totalTime;
        }
        if (!this.startCheck) {
            System.out.println("Class Time: method totalTime:  No start marker has been set - -9999 rturned");
            return -9999L;
        }
        System.out.println("Class Time: method totalTime:  No end marker has been set - -8888 rturned");
        return -8888L;
    }

    public int getHour24() {
        this.hour24 = this.cal.get(11);
        return this.hour24;
    }

    public String getHour12() {
        int hour = this.cal.get(10);
        int amPm = this.cal.get(9);
        this.hour12 = amPm == 0 ? new Integer(hour).toString() + " AM" : new Integer(hour).toString() + " PM";
        return this.hour12;
    }

    public int getMinute() {
        this.minute = this.cal.get(12);
        return this.minute;
    }

    public int getSecond() {
        this.second = this.cal.get(13);
        return this.second;
    }

    public int getMilliSecond() {
        this.millisecond = this.cal.get(14);
        return this.millisecond;
    }

    public String getShortTime24() {
        int hourI = this.getHour24();
        this.shortTime24 = new Integer(hourI).toString();
        int minI = this.getMinute();
        this.shortTime24 = minI < 10 ? this.shortTime24 + ".0" + minI : this.shortTime24 + "." + minI;
        return this.shortTime24;
    }

    public String getShortTime12() {
        int hourI = this.cal.get(10);
        int amPm = this.cal.get(9);
        this.shortTime12 = new Integer(hourI).toString();
        int minI = this.getMinute();
        this.shortTime12 = minI < 10 ? this.shortTime12 + ".0" + minI : this.shortTime12 + "." + minI;
        this.shortTime12 = amPm == 0 ? this.shortTime12 + " AM" : this.shortTime12 + " PM";
        return this.shortTime12;
    }

    public String getMidTime24() {
        int hourI = this.getHour24();
        this.midTime24 = new Integer(hourI).toString();
        int minI = this.getMinute();
        this.midTime24 = minI < 10 ? this.midTime24 + ".0" + minI : this.midTime24 + "." + minI;
        int secI = this.getSecond();
        this.midTime24 = secI < 10 ? this.midTime24 + ".0" + secI : this.midTime24 + "." + secI;
        return this.midTime24;
    }

    public String getMidTime12() {
        int hourI = this.cal.get(10);
        int amPm = this.cal.get(9);
        this.midTime12 = new Integer(hourI).toString();
        int minI = this.getMinute();
        this.midTime12 = minI < 10 ? this.midTime12 + ".0" + minI : this.midTime12 + "." + minI;
        int secI = this.getSecond();
        this.midTime12 = secI < 10 ? this.midTime12 + ".0" + secI : this.midTime12 + "." + secI;
        this.midTime12 = amPm == 0 ? this.midTime12 + " AM" : this.midTime12 + " PM";
        return this.midTime12;
    }

    public String getFullTime24() {
        int hourI = this.getHour24();
        this.fullTime24 = new Integer(hourI).toString();
        int minI = this.getMinute();
        this.fullTime24 = minI < 10 ? this.fullTime24 + ".0" + minI : this.fullTime24 + "." + minI;
        int secI = this.getSecond();
        this.fullTime24 = secI < 10 ? this.fullTime24 + ".0" + secI : this.fullTime24 + "." + secI;
        int msecI = this.getMilliSecond();
        this.fullTime24 = msecI < 10 ? this.fullTime24 + ".00" + msecI : (msecI < 100 ? this.fullTime24 + ".0" + msecI : this.fullTime24 + "." + msecI);
        return this.fullTime24;
    }

    public String getFullTime12() {
        int hourI = this.cal.get(10);
        int amPm = this.cal.get(9);
        this.fullTime12 = new Integer(hourI).toString();
        int minI = this.getMinute();
        this.fullTime12 = minI < 10 ? this.fullTime12 + ".0" + minI : this.fullTime12 + "." + minI;
        int secI = this.getSecond();
        this.fullTime12 = secI < 10 ? this.fullTime12 + ".0" + secI : this.fullTime12 + "." + secI;
        int msecI = this.getMilliSecond();
        this.fullTime12 = msecI < 10 ? this.fullTime12 + ".00" + msecI : (msecI < 100 ? this.fullTime12 + ".0" + msecI : this.fullTime12 + "." + msecI);
        this.fullTime12 = amPm == 0 ? this.fullTime12 + " AM" : this.fullTime12 + " PM";
        return this.fullTime12;
    }

    public long getComputerTime() {
        return System.currentTimeMillis();
    }

    public long dateToJavaMilliSecondsUK(int year, int month, int dayOfTheMonth, String dayOfTheWeek, int hour, int min, int sec, int millisec) {
        long ms = 0L;
        int dayIndicator = this.getDayOfTheWeekAsInteger(dayOfTheWeek);
        long bst = 0L;
        this.backForw = this.checkBST(dayOfTheWeek, dayOfTheMonth, hour, month, dayIndicator);
        if (this.backForw) {
            bst = 1L;
        }
        if (year >= 1970) {
            long yearDiff = 0L;
            for (int yearTest = year - 1; yearTest >= 1970; --yearTest) {
                yearDiff += 365L;
                if (!this.leapYear(yearTest)) continue;
                ++yearDiff;
            }
            yearDiff *= 86400000L;
            long monthDiff = 0L;
            for (int monthTest = month - 1; monthTest > 0; --monthTest) {
                monthDiff += (long)this.monthDays[monthTest - 1];
                if (!this.leapYear(year) || monthTest != 2) continue;
                ++monthDiff;
            }
            long dayDiff = (long)(dayOfTheMonth - 1) * 24L * 60L * 60L * 1000L;
            ms = yearDiff + (monthDiff *= 86400000L) + dayDiff + ((long)hour - bst) * 60L * 60L * 1000L + (long)min * 60L * 1000L + (long)sec * 1000L + (long)millisec;
        } else {
            long yearDiff = 0L;
            for (int yearTest = year + 1; yearTest < 1970; ++yearTest) {
                yearDiff += 365L;
                if (!this.leapYear(yearTest)) continue;
                ++yearDiff;
            }
            yearDiff *= 86400000L;
            long monthDiff = 0L;
            for (int monthTest = month - 1; monthTest > 0; --monthTest) {
                monthDiff += (long)this.monthDays[monthTest - 1];
                if (!this.leapYear(year) || monthTest != 2) continue;
                ++monthDiff;
            }
            monthDiff *= 86400000L;
            long dayDiff = (long)(dayOfTheMonth - 1) * 24L * 60L * 60L * 1000L;
            monthDiff = monthDiff + dayDiff + ((long)hour - bst) * 60L * 60L * 1000L + (long)min * 60L * 1000L + (long)sec * 1000L + (long)millisec;
            long myear = 365L;
            if (this.leapYear(year)) {
                ++myear;
            }
            ms = (myear *= 86400000L) - monthDiff;
            ms += yearDiff;
            ms = -ms;
        }
        return ms;
    }

    public boolean checkBST() {
        String dayOfTheWeek = this.getDayOfTheWeek();
        int dayOfTheMonth = this.getDayOfTheMonth();
        int hour = this.getMonthAsInteger();
        int month = this.getMonthAsInteger();
        int dayIndicator = this.getDayOfTheWeekAsInteger(dayOfTheWeek);
        return this.checkBST(dayOfTheWeek, dayOfTheMonth, hour, month, dayIndicator);
    }

    private boolean checkBST(String dayOfTheWeek, int dayOfTheMonth, int hour, int month, int dayIndicator) {
        if (month > 3 && month < 10) {
            this.backForw = true;
        } else if (month == 3 && dayOfTheMonth > 24) {
            if (dayIndicator == 0) {
                if (hour >= 1) {
                    this.backForw = true;
                }
            } else if (dayIndicator > 0 && dayIndicator < dayOfTheMonth - 24) {
                this.backForw = true;
            }
        } else if (month == 10 && dayOfTheMonth > 24) {
            if (dayIndicator == 0) {
                if (hour <= 2) {
                    this.backForw = true;
                }
            } else {
                this.backForw = true;
                if (dayIndicator > 0 && dayIndicator < dayOfTheMonth - 24) {
                    this.backForw = false;
                }
            }
        }
        return this.backForw;
    }

    public int getDayOfTheWeekAsInteger() {
        String dayOfTheWeek = this.getDayOfTheWeek();
        return this.getDayOfTheWeekAsInteger(dayOfTheWeek) + 1;
    }

    private int getDayOfTheWeekAsInteger(String dayOfTheWeek) {
        int counter = 0;
        int dayIndicator = 0;
        boolean test = true;
        while (test) {
            if (dayOfTheWeek.equals(this.days[counter])) {
                dayIndicator = counter;
                test = false;
                continue;
            }
            if (++counter <= 6) continue;
            throw new IllegalArgumentException(dayOfTheWeek + " is not recognised as a day of the week");
        }
        return dayIndicator;
    }

    public String nextBstClockChange() {
        this.backForw = true;
        String dayOfTheWeek = this.getDayOfTheWeek();
        int dayOfTheMonth = this.getDayOfTheMonth();
        int hour = this.getMonthAsInteger();
        int month = this.getMonthAsInteger();
        int dayIndicator = this.getDayOfTheWeekAsInteger(dayOfTheWeek);
        this.backForw = this.checkBST(dayOfTheWeek, dayOfTheMonth, hour, month, dayIndicator);
        int daysDiff = 0;
        int newDayOfTheMonth = dayOfTheMonth;
        int newMonth = month;
        int newYear = this.year;
        int oldNewDayOfTheMonth = newDayOfTheMonth;
        int oldMonth = newMonth;
        int oldYear = newYear;
        if (dayIndicator != 0) {
            daysDiff = 7 - dayIndicator;
        }
        newDayOfTheMonth = dayOfTheMonth + daysDiff;
        int monthD = this.monthDays[newMonth - 1];
        if (newMonth == 2 && this.leapYear(newYear)) {
            ++monthD;
        }
        if (newDayOfTheMonth > monthD) {
            newDayOfTheMonth -= monthD;
            if (++newMonth == 13) {
                newMonth = 1;
                newYear = oldYear + 1;
            }
        }
        if (!this.backForw) {
            boolean test = true;
            while (test) {
                if (newMonth == 3 && newDayOfTheMonth > 24) {
                    this.changeDate = "Sunday, " + newDayOfTheMonth + " March " + this.year + ", one hour forward";
                    test = false;
                    continue;
                }
                newDayOfTheMonth += 7;
                monthD = this.monthDays[newMonth - 1];
                if (newMonth == 2 && this.leapYear(newYear)) {
                    ++monthD;
                }
                if (newDayOfTheMonth <= monthD) continue;
                newDayOfTheMonth -= monthD;
                if (++newMonth != 13) continue;
                newMonth = 1;
                ++newYear;
            }
        } else {
            boolean test = true;
            while (test) {
                if (newMonth == 10 && newDayOfTheMonth > 24) {
                    this.changeDate = "Sunday, " + newDayOfTheMonth + " October " + this.year + ", one hour back";
                    test = false;
                    continue;
                }
                newDayOfTheMonth += 7;
                monthD = this.monthDays[newMonth - 1];
                if (newMonth == 2 && this.leapYear(newYear)) {
                    ++monthD;
                }
                if (newDayOfTheMonth <= monthD) continue;
                newDayOfTheMonth -= monthD;
                if (++newMonth != 13) continue;
                newMonth = 1;
                ++newYear;
            }
        }
        return this.changeDate;
    }

    public String getDayOfTheWeek() {
        int dayAsInt = this.cal.get(7);
        this.dayOfTheWeek = this.days[dayAsInt - 1];
        return this.dayOfTheWeek;
    }

    public int getDayOfTheMonth() {
        this.dayOfTheMonth = this.cal.get(5);
        return this.dayOfTheMonth;
    }

    public String getMonth() {
        int monthAsInt = this.cal.get(2);
        this.monthOfTheYear = this.months[monthAsInt];
        return this.monthOfTheYear;
    }

    public int getMonthAsInteger() {
        this.monthAsInteger = this.cal.get(2) + 1;
        return this.monthAsInteger;
    }

    public int getMonthAsInteger(String month) {
        int monthI = 0;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (month.equals(this.months[counter])) {
                monthI = counter + 1;
                test = false;
                continue;
            }
            if (++counter != 12) continue;
            throw new IllegalArgumentException(month + " is not recognised as a valid month name");
        }
        return monthI;
    }

    public int getYear() {
        this.year = this.cal.get(1);
        return this.year;
    }

    public String getDate() {
        this.date = new Integer(this.getDayOfTheMonth()).toString();
        this.date = this.date + " " + this.getMonth();
        this.date = this.date + " " + this.getYear();
        return this.date;
    }

    public String getFullDate() {
        this.fullDate = this.getDayOfTheWeek();
        this.fullDate = this.fullDate + ", " + this.getDayOfTheMonth();
        this.fullDate = this.fullDate + " " + this.getMonth();
        this.fullDate = this.fullDate + " " + this.getYear();
        return this.fullDate;
    }

    public String getShortDateUK() {
        int monthI;
        this.shortDateUK = new Integer(this.getDayOfTheMonth()).toString();
        if (this.shortDateUK.length() < 2) {
            this.shortDateUK = "0" + this.shortDateUK;
        }
        this.shortDateUK = (monthI = this.getMonthAsInteger()) < 10 ? this.shortDateUK + ".0" + monthI : this.shortDateUK + "." + monthI;
        String yearS = new Integer(this.getYear()).toString();
        this.shortDateUK = this.shortDateUK + "." + yearS.substring(2);
        return this.shortDateUK;
    }

    public String getShortDateUS() {
        int dayI;
        this.shortDateUS = new Integer(this.getMonthAsInteger()).toString();
        if (this.shortDateUS.length() < 2) {
            this.shortDateUS = "0" + this.shortDateUS;
        }
        this.shortDateUS = (dayI = this.getDayOfTheMonth()) < 10 ? this.shortDateUS + "/0" + dayI : this.shortDateUS + "/" + dayI;
        String yearS = new Integer(this.getYear()).toString();
        this.shortDateUS = this.shortDateUS + "/" + yearS.substring(2);
        return this.shortDateUS;
    }

    private boolean direction(int dayOfTheMonthT, int monthT, int yearT, int dayOfTheMonth, int month, int year) {
        boolean test = true;
        boolean direction = false;
        direction = year > yearT ? true : (year < yearT ? false : (month > monthT ? true : (month < monthT ? false : dayOfTheMonth >= dayOfTheMonthT)));
        return direction;
    }

    public String getDayOfDate(int dayOfTheMonth, String month, int year) {
        int monthI = this.getMonthAsInteger(month);
        return this.getDayOfDate(dayOfTheMonth, monthI, year);
    }

    public String getDayOfDate(int dayOfTheMonth, int month, int year) {
        String dayOfDate = null;
        int yearT = this.getYear();
        int monthT = this.getMonthAsInteger();
        int dayOfTheMonthT = this.getDayOfTheMonth();
        int dayI = this.getDayOfTheWeekAsInteger();
        int febOrRest = 0;
        boolean direction = this.direction(dayOfTheMonthT, monthT, yearT, dayOfTheMonth, month, year);
        if (direction) {
            boolean test = true;
            while (test) {
                if (yearT == year && monthT == month && dayOfTheMonthT == dayOfTheMonth) {
                    dayOfDate = this.days[dayI - 1];
                    test = false;
                    continue;
                }
                ++dayOfTheMonthT;
                febOrRest = this.monthDays[monthT - 1];
                if (this.leapYear(yearT) && monthT == 2) {
                    ++febOrRest;
                }
                if (dayOfTheMonthT > febOrRest) {
                    dayOfTheMonthT -= febOrRest;
                    ++monthT;
                }
                if (monthT == 13) {
                    monthT = 1;
                    ++yearT;
                }
                if (++dayI != 8) continue;
                dayI = 1;
            }
        } else {
            boolean test = true;
            while (test) {
                if (yearT == year && monthT == month && dayOfTheMonthT == dayOfTheMonth) {
                    dayOfDate = this.days[dayI - 1];
                    test = false;
                    continue;
                }
                --dayOfTheMonthT;
                int monthIndex = monthT - 2;
                if (monthIndex < 0) {
                    monthIndex = 11;
                }
                febOrRest = this.monthDays[monthIndex];
                if (this.leapYear(yearT) && monthT == 3) {
                    ++febOrRest;
                }
                if (dayOfTheMonthT == 0) {
                    dayOfTheMonthT = febOrRest;
                    --monthT;
                }
                if (monthT == 0) {
                    monthT = 12;
                    --yearT;
                }
                if (--dayI != 0) continue;
                dayI = 7;
            }
        }
        return dayOfDate;
    }

    public String easterSunday() {
        int year = this.getYear();
        if (year > 2299) {
            System.out.println(year + " is outside the range for which this algorithm has been checked, 1700 - 2299");
        }
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        int rem1 = year % 19;
        int quo1 = year / 100;
        int rem2 = year % 100;
        int quo2 = quo1 / 4;
        int rem3 = quo1 % 4;
        int quo3 = rem2 / 4;
        int rem4 = rem2 % 4;
        int quo4 = (quo1 + 8) / 25;
        int quo5 = (quo1 - quo4 + 1) / 3;
        int rem5 = (19 * rem1 + quo1 - quo2 - quo5 + 15) % 30;
        int rem6 = (32 + 2 * rem3 + 2 * quo3 - rem5 - rem4) % 7;
        int quo6 = (rem1 + 11 * rem5 + 22 * rem6) / 451;
        int sum1 = rem5 + rem6 - 7 * quo6 + 114;
        this.easterMonth = sum1 / 31;
        this.easterDay = sum1 % 31 + 1;
        boolean direction = this.direction(day, month, year, this.easterDay, this.easterMonth, year);
        if (direction) {
            this.dayHold = this.easterDay;
            this.monthHold = this.easterMonth;
            this.yearHold = year;
            this.dayNameHold = "Sunday";
            this.easterDayName = this.getDayOfDate(this.easterDay, this.easterMonth, year);
            return this.easterDayName + ", " + this.easterDay + " " + this.months[this.easterMonth - 1] + " " + year;
        }
        return this.easterSunday(++year);
    }

    public String easterSunday(int year) {
        if (year < 1700 || year > 2299) {
            System.out.println(year + " is outside the range for which this algorithm has been checked, 1700 - 2299");
        }
        int rem1 = year % 19;
        int quo1 = year / 100;
        int rem2 = year % 100;
        int quo2 = quo1 / 4;
        int rem3 = quo1 % 4;
        int quo3 = rem2 / 4;
        int rem4 = rem2 % 4;
        int quo4 = (quo1 + 8) / 25;
        int quo5 = (quo1 - quo4 + 1) / 3;
        int rem5 = (19 * rem1 + quo1 - quo2 - quo5 + 15) % 30;
        int rem6 = (32 + 2 * rem3 + 2 * quo3 - rem5 - rem4) % 7;
        int quo6 = (rem1 + 11 * rem5 + 22 * rem6) / 451;
        int sum1 = rem5 + rem6 - 7 * quo6 + 114;
        this.easterMonth = sum1 / 31;
        this.dayHold = this.easterDay = sum1 % 31 + 1;
        this.monthHold = this.easterMonth;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        this.easterDayName = this.getDayOfDate(this.easterDay, this.easterMonth, year);
        return this.easterDayName + ", " + this.easterDay + " " + this.months[this.easterMonth - 1] + " " + year;
    }

    public String goodFriday() {
        boolean direction;
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.easterSunday(year);
        int monthGF = this.easterMonth;
        int dayGF = this.easterDay - 2;
        if (dayGF < 1) {
            int dayCheck = this.monthDays[monthGF - 2];
            if (this.leapYear(year) && monthGF == 3) {
                ++dayCheck;
            }
            dayGF = dayCheck + dayGF;
            --monthGF;
        }
        if (!(direction = this.direction(day, month, year, dayGF, monthGF, year))) {
            ++year;
        }
        return this.goodFriday(year);
    }

    public String goodFriday(int year) {
        this.easterSunday(year);
        int monthGF = this.easterMonth;
        int dayGF = this.easterDay - 2;
        if (dayGF < 1) {
            int dayCheck = this.monthDays[monthGF - 2];
            if (this.leapYear(year) && monthGF == 3) {
                ++dayCheck;
            }
            dayGF = dayCheck + dayGF;
            --monthGF;
        }
        this.dayHold = dayGF;
        this.monthHold = monthGF;
        this.yearHold = year;
        this.dayNameHold = "Friday";
        return "Friday, " + dayGF + " " + this.months[monthGF - 1] + " " + year;
    }

    public String maundyThursday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.maundyThursday(year);
        int monthMT = this.monthHold;
        int dayMT = this.dayHold;
        boolean direction = this.direction(day, month, year, dayMT, monthMT, year);
        if (!direction) {
            ++year;
        }
        return this.maundyThursday(year);
    }

    public String maundyThursday(int year) {
        this.goodFriday(year);
        int monthMT = this.monthHold;
        int dayMT = this.dayHold - 1;
        if (dayMT < 1) {
            int dayCheck = this.monthDays[monthMT - 2];
            if (this.leapYear(year) && monthMT == 3) {
                ++dayCheck;
            }
            dayMT = dayCheck + dayMT;
            --monthMT;
        }
        this.dayHold = dayMT;
        this.monthHold = monthMT;
        this.yearHold = year;
        this.dayNameHold = "Friday";
        return "Thursday, " + dayMT + " " + this.months[monthMT - 1] + " " + year;
    }

    public String ashWednesday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.ashWednesday(year);
        int monthAW = this.monthHold;
        int dayAW = this.dayHold;
        boolean direction = this.direction(day, month, year, dayAW, monthAW, year);
        if (!direction) {
            ++year;
        }
        return this.ashWednesday(year);
    }

    public String ashWednesday(int year) {
        this.easterSunday(year);
        int monthAW = this.easterMonth;
        int dayAW = this.easterDay;
        int counter = 1;
        while (counter <= 40) {
            if (--dayAW < 1) {
                int dayCheck = this.monthDays[monthAW - 2];
                if (this.leapYear(year) && monthAW == 3) {
                    ++dayCheck;
                }
                dayAW = dayCheck + dayAW;
                --monthAW;
            }
            if (this.getDayOfDate(dayAW, monthAW, year).equals("Sunday")) continue;
            ++counter;
        }
        this.dayHold = dayAW;
        this.monthHold = monthAW;
        this.yearHold = year;
        this.dayNameHold = "Wednesday";
        return "Wednesday, " + dayAW + " " + this.months[monthAW - 1] + " " + year;
    }

    public String shroveTuesday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.shroveTuesday(year);
        int monthST = this.monthHold;
        int dayST = this.dayHold;
        boolean direction = this.direction(day, month, year, dayST, monthST, year);
        if (!direction) {
            ++year;
        }
        return this.shroveTuesday(year);
    }

    public String shroveTuesday(int year) {
        this.ashWednesday(year);
        int monthST = this.monthHold;
        int dayST = this.dayHold - 1;
        if (dayST < 1) {
            int dayCheck = this.monthDays[monthST - 2];
            if (this.leapYear(year) && monthST == 3) {
                ++dayCheck;
            }
            dayST = dayCheck + dayST;
            --monthST;
        }
        this.dayHold = dayST;
        this.monthHold = monthST;
        this.yearHold = year;
        this.dayNameHold = "Tuesday";
        return "Tuesday, " + dayST + " " + this.months[monthST - 1] + " " + year;
    }

    public String palmSunday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.palmSunday(year);
        int monthPS = this.monthHold;
        int dayPS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayPS, monthPS, year);
        if (!direction) {
            ++year;
        }
        return this.palmSunday(year);
    }

    public String palmSunday(int year) {
        this.easterSunday(year);
        int monthPS = this.easterMonth;
        int dayPS = this.easterDay - 7;
        if (dayPS < 1) {
            int dayCheck = this.monthDays[monthPS - 2];
            if (this.leapYear(year) && monthPS == 3) {
                ++dayCheck;
            }
            dayPS = dayCheck + dayPS;
            --monthPS;
        }
        this.dayHold = dayPS;
        this.monthHold = monthPS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayPS + " " + this.months[monthPS - 1] + " " + year;
    }

    public String adventSunday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.adventSunday(year);
        int monthPS = this.monthHold;
        int dayPS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayPS, monthPS, year);
        if (!direction) {
            ++year;
        }
        return this.adventSunday(year);
    }

    public String adventSunday(int year) {
        this.saintAndrewsDay(year);
        int monthAS = this.monthHold;
        int dayAS = this.dayHold;
        String dayNameAS = this.dayNameHold;
        int dayASI = this.getDayOfTheWeekAsInteger(dayNameAS);
        if (dayASI < 4) {
            if ((dayAS -= dayASI) < 1) {
                int dayCheck = this.monthDays[monthAS - 2];
                if (this.leapYear(year) && monthAS == 3) {
                    ++dayCheck;
                }
                dayAS = dayCheck + dayAS;
                --monthAS;
            }
        } else {
            dayAS += 7 - dayASI;
            int dayCheck = this.monthDays[monthAS - 1];
            if (this.leapYear(year) && monthAS == 2) {
                ++dayCheck;
            }
            if (dayAS > dayCheck) {
                dayAS -= dayCheck;
                ++monthAS;
            }
        }
        this.dayHold = dayAS;
        this.monthHold = monthAS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayAS + " " + this.months[monthAS - 1] + " " + year;
    }

    public String trinitySunday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.trinitySunday(year);
        int monthTS = this.monthHold;
        int dayTS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayTS, monthTS, year);
        if (!direction) {
            ++year;
        }
        return this.trinitySunday(year);
    }

    public String trinitySunday(int year) {
        this.whitSunday(year);
        int monthTS = this.monthHold;
        int dayTS = this.dayHold + 7;
        int dayCheck = this.monthDays[monthTS - 1];
        if (this.leapYear(year) && monthTS == 2) {
            ++dayCheck;
        }
        if (dayTS > dayCheck) {
            dayTS -= dayCheck;
            ++monthTS;
        }
        this.dayHold = dayTS;
        this.monthHold = monthTS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayTS + " " + this.months[monthTS - 1] + " " + year;
    }

    public String corpusChristi() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.corpusChristi(year);
        int monthTS = this.monthHold;
        int dayTS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayTS, monthTS, year);
        if (!direction) {
            ++year;
        }
        return this.corpusChristi(year);
    }

    public String corpusChristi(int year) {
        this.trinitySunday(year);
        int monthTS = this.monthHold;
        int dayTS = this.dayHold + 4;
        int dayCheck = this.monthDays[monthTS - 1];
        if (this.leapYear(year) && monthTS == 2) {
            ++dayCheck;
        }
        if (dayTS > dayCheck) {
            dayTS -= dayCheck;
            ++monthTS;
        }
        this.dayHold = dayTS;
        this.monthHold = monthTS;
        this.yearHold = year;
        this.dayNameHold = "Thursday";
        return "Thursday, " + dayTS + " " + this.months[monthTS - 1] + " " + year;
    }

    public String sundayAfterCorpusChristi() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.sundayAfterCorpusChristi(year);
        int monthTS = this.monthHold;
        int dayTS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayTS, monthTS, year);
        if (!direction) {
            ++year;
        }
        return this.sundayAfterCorpusChristi(year);
    }

    public String sundayAfterCorpusChristi(int year) {
        this.corpusChristi(year);
        int monthTS = this.monthHold;
        int dayTS = this.dayHold + 3;
        int dayCheck = this.monthDays[monthTS - 1];
        if (this.leapYear(year) && monthTS == 2) {
            ++dayCheck;
        }
        if (dayTS > dayCheck) {
            dayTS -= dayCheck;
            ++monthTS;
        }
        this.dayHold = dayTS;
        this.monthHold = monthTS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayTS + " " + this.months[monthTS - 1] + " " + year;
    }

    public String ascensionThursday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.ascensionThursday(year);
        int monthAT = this.monthHold;
        int dayAT = this.dayHold;
        boolean direction = this.direction(day, month, year, dayAT, monthAT, year);
        if (!direction) {
            ++year;
        }
        return this.ascensionThursday(year);
    }

    public String ascensionThursday(int year) {
        this.easterSunday(year);
        int monthAT = this.easterMonth;
        int dayAT = this.easterDay + 39;
        int dayCheck1 = this.monthDays[monthAT - 1];
        if (this.leapYear(year) && monthAT == 2) {
            ++dayCheck1;
        }
        int dayCheck2 = this.monthDays[monthAT];
        if (this.leapYear(year) && monthAT == 1) {
            ++dayCheck2;
        }
        if (dayAT > dayCheck1 + dayCheck2) {
            dayAT -= dayCheck1 + dayCheck2;
            monthAT += 2;
        } else if (dayAT > dayCheck1) {
            dayAT -= dayCheck1;
            ++monthAT;
        }
        this.dayHold = dayAT;
        this.monthHold = monthAT;
        this.yearHold = year;
        this.dayNameHold = "Thursday";
        return "Thursday, " + dayAT + " " + this.months[monthAT - 1] + " " + year;
    }

    public String sundayAfterAscension() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.sundayAfterAscension(year);
        int monthAT = this.monthHold;
        int dayAT = this.dayHold;
        boolean direction = this.direction(day, month, year, dayAT, monthAT, year);
        if (!direction) {
            ++year;
        }
        return this.sundayAfterAscension(year);
    }

    public String sundayAfterAscension(int year) {
        this.ascensionThursday(year);
        int monthAT = this.monthHold;
        int dayAT = this.dayHold + 3;
        int dayCheck1 = this.monthDays[monthAT - 1];
        if (this.leapYear(year) && monthAT == 2) {
            ++dayCheck1;
        }
        if (dayAT > dayCheck1) {
            dayAT -= dayCheck1;
            ++monthAT;
        }
        this.dayHold = dayAT;
        this.monthHold = monthAT;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayAT + " " + this.months[monthAT - 1] + " " + year;
    }

    public String whitSunday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.whitSunday(year);
        int monthWS = this.monthHold;
        int dayWS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayWS, monthWS, year);
        if (!direction) {
            ++year;
        }
        return this.whitSunday(year);
    }

    public String whitSunday(int year) {
        this.easterSunday(year);
        int dayWS = this.easterDay + 49;
        int monthWS = this.easterMonth;
        int dayCheck1 = this.monthDays[monthWS - 1];
        if (this.leapYear(year) && monthWS == 2) {
            ++dayCheck1;
        }
        int dayCheck2 = this.monthDays[monthWS];
        if (this.leapYear(year) && monthWS == 1) {
            ++dayCheck2;
        }
        if (dayWS > dayCheck1 + dayCheck2) {
            dayWS -= dayCheck1 + dayCheck2;
            monthWS += 2;
        } else if (dayWS > dayCheck1) {
            dayWS -= dayCheck1;
            ++monthWS;
        }
        this.dayHold = dayWS;
        this.monthHold = monthWS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayWS + " " + this.months[this.monthHold - 1] + " " + year;
    }

    public String mothersDayUK() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.mothersDayUK(year);
        int monthMS = this.monthHold;
        int dayMS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayMS, monthMS, year);
        if (!direction) {
            ++year;
        }
        return this.mothersDayUK(year);
    }

    public String mothersDayUK(int year) {
        this.ashWednesday(year);
        int dayMS = this.dayHold + 25;
        int monthMS = this.monthHold;
        int dayCheck = this.monthDays[monthMS - 1];
        if (this.leapYear(year) && monthMS == 2) {
            ++dayCheck;
        }
        if (dayMS > dayCheck) {
            dayMS -= dayCheck;
            ++monthMS;
        }
        this.dayHold = dayMS;
        this.monthHold = monthMS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayMS + " " + this.months[this.monthHold - 1] + " " + year;
    }

    public String mothersDayUS() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.mothersDayUS(year);
        boolean direction = this.direction(day, month, year, this.dayHold, this.monthHold, year);
        if (!direction) {
            ++year;
        }
        return this.mothersDayUS(year);
    }

    public String mothersDayUS(int year) {
        String dayMSN = this.getDayOfDate(1, "May", year);
        int monthMS = 5;
        int dayOwI = this.getDayOfTheWeekAsInteger(dayMSN) + 1;
        int dayMS = 0;
        dayMS = dayOwI == 1 ? dayOwI + 7 : 16 - dayOwI;
        this.dayHold = dayMS;
        this.monthHold = monthMS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayMS + " May " + year;
    }

    public String fathersDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.fathersDay(year);
        boolean direction = this.direction(day, month, year, this.dayHold, this.monthHold, year);
        if (!direction) {
            ++year;
        }
        return this.fathersDay(year);
    }

    public String fathersDay(int year) {
        String dayMSN = this.getDayOfDate(1, "June", year);
        int monthFD = 6;
        int dayOwI = this.getDayOfTheWeekAsInteger(dayMSN) + 1;
        int dayFD = 0;
        dayFD = dayOwI == 1 ? dayOwI + 14 : 23 - dayOwI;
        this.dayHold = dayFD;
        this.monthHold = monthFD;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayFD + " June " + year;
    }

    public String christmasDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 25, 12, year);
        if (!direction) {
            ++year;
        }
        return this.christmasDay(year);
    }

    public String christmasDay(int year) {
        String day = this.getDayOfDate(25, 12, year);
        this.dayHold = 25;
        this.monthHold = 12;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 25 December " + year;
    }

    public String newYearsDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 1, 1, year);
        if (!direction) {
            ++year;
        }
        return this.newYearsDay(year);
    }

    public String newYearsDay(int year) {
        String day = this.getDayOfDate(1, 1, year);
        this.dayHold = 1;
        this.monthHold = 1;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 1 January " + year;
    }

    public String epiphany() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 6, 1, year);
        if (!direction) {
            ++year;
        }
        return this.epiphany(year);
    }

    public String epiphany(int year) {
        String day = this.getDayOfDate(6, 1, year);
        this.dayHold = 6;
        this.monthHold = 1;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 6 January " + year;
    }

    public String sundayAfterEpiphany() {
        boolean direction;
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        String dayName = this.getDayOfDate(6, 1, year);
        int dayI = this.getDayOfTheWeekAsInteger(dayName);
        int day6plus = 6;
        if (dayI > 0) {
            day6plus += 7 - dayI;
        }
        if (!(direction = this.direction(day, month, year, day6plus, 1, year))) {
            ++year;
        }
        return this.sundayAfterEpiphany(year);
    }

    public String sundayAfterEpiphany(int year) {
        String dayName = this.getDayOfDate(6, 1, year);
        int dayI = this.getDayOfTheWeekAsInteger(dayName);
        int day6plus = 6;
        if (dayI > 0) {
            day6plus += 7 - dayI;
        }
        this.dayHold = day6plus;
        this.monthHold = 1;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + day6plus + " January " + year;
    }

    public String annunciation() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 25, 3, year);
        if (!direction) {
            ++year;
        }
        return this.annunciation(year);
    }

    public String annunciation(int year) {
        String day = this.getDayOfDate(25, 3, year);
        this.dayHold = 25;
        this.monthHold = 3;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 25 March " + year;
    }

    public String assumption() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 15, 8, year);
        if (!direction) {
            ++year;
        }
        return this.assumption(year);
    }

    public String assumption(int year) {
        String day = this.getDayOfDate(15, 8, year);
        this.dayHold = 15;
        this.monthHold = 8;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 15 August " + year;
    }

    public String nativityBlessedVirgin() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 8, 9, year);
        if (!direction) {
            ++year;
        }
        return this.nativityBlessedVirgin(year);
    }

    public String nativityBlessedVirgin(int year) {
        String day = this.getDayOfDate(8, 9, year);
        this.dayHold = 8;
        this.monthHold = 9;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 8 September " + year;
    }

    public String immaculateConception() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 8, 12, year);
        if (!direction) {
            ++year;
        }
        return this.immaculateConception(year);
    }

    public String immaculateConception(int year) {
        String day = this.getDayOfDate(8, 12, year);
        this.dayHold = 8;
        this.monthHold = 12;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 8 December " + year;
    }

    public String purification() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 2, 2, year);
        if (!direction) {
            ++year;
        }
        return this.purification(year);
    }

    public String presentation() {
        return this.purification();
    }

    public String candlemas() {
        return this.purification();
    }

    public String purification(int year) {
        String day = this.getDayOfDate(2, 2, year);
        this.dayHold = 2;
        this.monthHold = 2;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 2 February " + year;
    }

    public String presentation(int year) {
        return this.purification(year);
    }

    public String candlemas(int year) {
        return this.purification(year);
    }

    public String transfiguration() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 6, 8, year);
        if (!direction) {
            ++year;
        }
        return this.transfiguration(year);
    }

    public String transfiguration(int year) {
        String day = this.getDayOfDate(6, 8, year);
        this.dayHold = 6;
        this.monthHold = 8;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 6 August " + year;
    }

    public String remembranceSunday() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        this.remembranceSunday(year);
        int monthRS = this.monthHold;
        int dayRS = this.dayHold;
        boolean direction = this.direction(day, month, year, dayRS, monthRS, year);
        if (!direction) {
            ++year;
        }
        return this.remembranceSunday(year);
    }

    public String remembranceSunday(int year) {
        int monthRS = 11;
        int dayRS = 11;
        String dayNameRS = this.getDayOfDate(11, 11, year);
        int dayRSI = this.getDayOfTheWeekAsInteger(dayNameRS);
        if (dayRSI < 4) {
            if ((dayRS -= dayRSI) < 1) {
                int dayCheck = this.monthDays[monthRS - 2];
                if (this.leapYear(year) && monthRS == 3) {
                    ++dayCheck;
                }
                dayRS = dayCheck + dayRS;
                --monthRS;
            }
        } else {
            dayRS += 7 - dayRSI;
            int dayCheck = this.monthDays[monthRS - 1];
            if (this.leapYear(year) && monthRS == 2) {
                ++dayCheck;
            }
            if (dayRS > dayCheck) {
                dayRS -= dayCheck;
                ++monthRS;
            }
        }
        this.dayHold = dayRS;
        this.monthHold = monthRS;
        this.yearHold = year;
        this.dayNameHold = "Sunday";
        return "Sunday, " + dayRS + " " + this.months[monthRS - 1] + " " + year;
    }

    public String holocaustMemorialDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 27, 1, year);
        if (!direction) {
            ++year;
        }
        return this.holocaustMemorialDay(year);
    }

    public String holocaustMemorialDay(int year) {
        String day = this.getDayOfDate(27, 1, year);
        this.dayHold = 25;
        this.monthHold = 12;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 27 January " + year;
    }

    public String saintPatricksDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 17, 3, year);
        if (!direction) {
            ++year;
        }
        return this.saintPatricksDay(year);
    }

    public String saintPatricksDay(int year) {
        String day = this.getDayOfDate(17, 3, year);
        this.dayHold = 17;
        this.monthHold = 3;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 17 March " + year;
    }

    public String saintBrigidsDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 1, 2, year);
        if (!direction) {
            ++year;
        }
        return this.saintBrigidsDay(year);
    }

    public String saintBrigidsDay(int year) {
        String day = this.getDayOfDate(1, 2, year);
        this.dayHold = 1;
        this.monthHold = 2;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 1 February " + year;
    }

    public String saintColmCillesDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 9, 6, year);
        if (!direction) {
            ++year;
        }
        return this.saintColmCillesDay(year);
    }

    public String saintColumbasDay() {
        return this.saintColmCillesDay();
    }

    public String saintColmcillesDay() {
        return this.saintColmCillesDay();
    }

    public String saintColmCillesDay(int year) {
        String day = this.getDayOfDate(9, 6, year);
        this.dayHold = 9;
        this.monthHold = 6;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 9 June " + year;
    }

    public String saintColumbasDay(int year) {
        return this.saintColmCillesDay(year);
    }

    public String saintColmcillesDay(int year) {
        return this.saintColmCillesDay(year);
    }

    public String saintGeorgesDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 23, 4, year);
        if (!direction) {
            ++year;
        }
        return this.saintGeorgesDay(year);
    }

    public String saintGeorgesDay(int year) {
        String day = this.getDayOfDate(23, 4, year);
        this.dayHold = 23;
        this.monthHold = 4;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 23 April " + year;
    }

    public String saintAndrewsDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 30, 11, year);
        if (!direction) {
            ++year;
        }
        return this.saintAndrewsDay(year);
    }

    public String saintAndrewsDay(int year) {
        String day = this.getDayOfDate(30, 11, year);
        this.dayHold = 30;
        this.monthHold = 11;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 30 November " + year;
    }

    public String saintDavidsDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 1, 3, year);
        if (!direction) {
            ++year;
        }
        return this.saintDavidsDay(year);
    }

    public String saintDavidsDay(int year) {
        String day = this.getDayOfDate(1, 3, year);
        this.dayHold = 1;
        this.monthHold = 3;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 1 March " + year;
    }

    public String saintStephensDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 26, 12, year);
        if (!direction) {
            ++year;
        }
        return this.saintStephensDay(year);
    }

    public String saintStephensDay(int year) {
        String day = this.getDayOfDate(26, 12, year);
        this.dayHold = 26;
        this.monthHold = 12;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 26 December " + year;
    }

    public String saintValentinesDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 14, 2, year);
        if (!direction) {
            ++year;
        }
        return this.saintValentinesDay(year);
    }

    public String saintValentinesDay(int year) {
        String day = this.getDayOfDate(14, 2, year);
        this.dayHold = 14;
        this.monthHold = 2;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 14 February " + year;
    }

    public String burnsNight() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 25, 1, year);
        if (!direction) {
            ++year;
        }
        return this.burnsNight(year);
    }

    public String burnsNight(int year) {
        String day = this.getDayOfDate(25, 1, year);
        this.dayHold = 25;
        this.monthHold = 1;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 25 January " + year;
    }

    public String twelfthJuly() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 12, 7, year);
        if (!direction) {
            ++year;
        }
        return this.twelfthJuly(year);
    }

    public String twelfthJuly(int year) {
        String day = this.getDayOfDate(12, 7, year);
        this.dayHold = 12;
        this.monthHold = 7;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 12 July " + year;
    }

    public String fourthJuly() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 12, 7, year);
        if (!direction) {
            ++year;
        }
        return this.fourthJuly(year);
    }

    public String fourthJuly(int year) {
        String day = this.getDayOfDate(4, 7, year);
        this.dayHold = 4;
        this.monthHold = 7;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 4 July " + year;
    }

    public String thanksgivingDay() {
        boolean direction;
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        String day1 = this.getDayOfDate(1, "November", year);
        int day1I = this.getDayOfTheWeekAsInteger(day1) + 1;
        int day2I = 6 - day1I;
        if (day2I <= 0) {
            day2I += 7;
        }
        if (direction = this.direction(day, month, year, day2I += 14, 11, year)) {
            return "Thursday, " + day2I + " November " + year;
        }
        return this.thanksgivingDay(++year);
    }

    public String thanksgivingDay(int year) {
        String day1 = this.getDayOfDate(1, "November", year);
        int day1I = this.getDayOfTheWeekAsInteger(day1) + 1;
        int day2I = 6 - day1I;
        if (day2I <= 0) {
            day2I += 7;
        }
        this.dayHold = day2I += 14;
        this.monthHold = 11;
        this.yearHold = year;
        this.dayNameHold = "Thursday";
        return "Thursday, " + day2I + " November " + year;
    }

    public String commonwealthDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        String day1 = this.getDayOfDate(1, "March", year);
        int day1I = this.getDayOfTheWeekAsInteger(day1);
        int day2I = 0;
        day2I = day1I > 1 ? 15 - day1I : (day1I == 0 ? 8 : 9);
        boolean direction = this.direction(day, month, year, day2I, 3, year);
        if (direction) {
            this.dayHold = day2I;
            this.monthHold = 3;
            this.yearHold = year;
            this.dayNameHold = "Monday";
            return "Monday, " + day2I + " November " + year;
        }
        return this.commonwealthDay(++year);
    }

    public String commonwealthDay(int year) {
        String day1 = this.getDayOfDate(1, "March", year);
        int day1I = this.getDayOfTheWeekAsInteger(day1);
        int day2I = 0;
        day2I = day1I > 1 ? 16 - day1I : (day1I == 0 ? 9 : 8);
        this.dayHold = day2I;
        this.monthHold = 3;
        this.yearHold = year;
        this.dayNameHold = "Monday";
        return "Monday, " + day2I + " March " + year;
    }

    public String armedForcesDay() {
        int year = this.getYear();
        int month = this.getMonthAsInteger();
        int day = this.getDayOfTheMonth();
        boolean direction = this.direction(day, month, year, 27, 6, year);
        if (!direction) {
            ++year;
        }
        return this.armedForcesDay(year);
    }

    public String veteransDayUK() {
        return this.armedForcesDay();
    }

    public String armedForcesDay(int year) {
        String day = this.getDayOfDate(27, 6, year);
        this.dayHold = 27;
        this.monthHold = 6;
        this.yearHold = year;
        this.dayNameHold = day;
        return day + ", 27 June " + year;
    }

    public String veteransDayUK(int year) {
        return this.armedForcesDay(year);
    }

    public boolean leapYear(int year) {
        boolean test = false;
        test = year % 4 != 0 ? false : (year % 400 == 0 ? true : year % 100 != 0);
        return test;
    }
}

