/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.analysis.ErrorProp;
import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexErrorProp;
import flanagan.math.Fmath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Db {
    private static boolean inputTypeInfo = true;

    public static void setTypeInfoOption(int opt) {
        switch (opt) {
            case 1: {
                inputTypeInfo = true;
                break;
            }
            case 2: {
                inputTypeInfo = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Option " + opt + " not recognised");
            }
        }
    }

    public static final synchronized double readDouble(String mess) {
        String line = "";
        double d = 0.0;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: double\n";
        }
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                d = Double.parseDouble(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized double readDouble(String mess, double dflt) {
        String line = "";
        double d = 0.0;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: double\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                d = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                d = Double.parseDouble(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized double readDouble() {
        String line = "";
        String mess = "Input type: double";
        double d = 0.0;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                d = Double.parseDouble(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized double[] readDoubleArray(String mess) {
        String line = "";
        double[] darray = null;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: double[], each element separated by a comma\n";
        }
        mess = mess + "\n";
        String dfltmess = " ";
        int nElements = 0;
        ArrayList<Double> al = new ArrayList<Double>();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess, (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                line = null;
                continue;
            }
            int pos = -1;
            String hold = null;
            boolean test = true;
            while (test) {
                pos = line.indexOf(44);
                if (pos == -1) {
                    hold = line.trim();
                    test = false;
                    finish = true;
                } else {
                    hold = line.substring(0, pos).trim();
                    line = line.substring(pos + 1);
                }
                try {
                    al.add(Double.valueOf(hold));
                }
                catch (NumberFormatException e) {}
            }
        }
        nElements = al.size();
        darray = new double[nElements];
        for (int i = 0; i < nElements; ++i) {
            darray[i] = (Double)al.get(i);
        }
        return darray;
    }

    public static final synchronized Complex readComplex(String mess) {
        String line = "";
        Complex c = new Complex();
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: Complex (x + jy)\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                c = Complex.parseComplex(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return c;
    }

    public static final synchronized Complex readComplex(String mess, Complex dflt) {
        String line = "";
        Complex c = new Complex();
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: Complex (x + jy)\n";
        }
        String dfltmess = dflt + "";
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                c = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                c = Complex.parseComplex(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return c;
    }

    public static final synchronized Complex readComplex(String mess, String dflt) {
        String line = "";
        Complex c = new Complex();
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: Complex (x + jy)\n";
        }
        String dfltmess = dflt;
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                c = Complex.parseComplex(dflt);
                finish = true;
                line = null;
                continue;
            }
            try {
                c = Complex.parseComplex(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return c;
    }

    public static final synchronized Complex readComplex() {
        String line = "";
        String mess = "Input type: Complex (x + jy)";
        Complex c = new Complex();
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                c = Complex.parseComplex(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return c;
    }

    public static final synchronized Phasor readPhasor(String mess) {
        String line = "";
        Phasor ph = new Phasor();
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                ph = Phasor.parsePhasor(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return ph;
    }

    public static final synchronized Phasor readPhasor(String mess, Phasor dflt) {
        String line = "";
        Phasor ph = new Phasor();
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)\n";
        }
        String dfltmess = dflt + "";
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                ph = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                ph = Phasor.parsePhasor(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return ph;
    }

    public static final synchronized Phasor readPhasor(String mess, String dflt) {
        String line = "";
        Phasor ph = new Phasor();
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)\n";
        }
        String dfltmess = dflt;
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                ph = Phasor.parsePhasor(dflt);
                finish = true;
                line = null;
                continue;
            }
            try {
                ph = Phasor.parsePhasor(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return ph;
    }

    public static final synchronized Phasor readPhasor() {
        String line = "";
        String mess = "Input type: Phasor ('mag'<'phase'deg or 'mag'<'phase'rad)";
        Phasor ph = new Phasor();
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                ph = Phasor.parsePhasor(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return ph;
    }

    public static final synchronized float readFloat(String mess) {
        String line = "";
        float d = 0.0f;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: float\n";
        }
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                d = Float.parseFloat(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized float readFloat(String mess, float dflt) {
        String line = "";
        float d = 0.0f;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: float\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                d = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                d = Float.parseFloat(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized float readFloat() {
        String line = "";
        String mess = "Input type: float";
        float d = 0.0f;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                d = Float.parseFloat(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized int readInt(String mess) {
        String line = "";
        int d = 0;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: int\n";
        }
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                d = Integer.parseInt(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized int readInt(String mess, int dflt) {
        String line = "";
        int d = 0;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: int\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                d = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                d = Integer.parseInt(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized int readInt() {
        String line = "";
        String mess = "Input type: int";
        int d = 0;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                d = Integer.parseInt(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized long readLong(String mess) {
        String line = "";
        long d = 0L;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: long\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                d = Long.parseLong(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized long readLong(String mess, long dflt) {
        String line = "";
        long d = 0L;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: long\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                d = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                d = Long.parseLong(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized long readLong() {
        String line = "";
        String mess = "Input type: long";
        long d = 0L;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                d = Long.parseLong(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized long readShort(String mess) {
        String line = "";
        long d = 0L;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: short\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                d = Short.parseShort(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized short readShort(String mess, short dflt) {
        String line = "";
        short d = 0;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: short\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                d = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                d = Short.parseShort(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized short readShort() {
        String line = "";
        String mess = "Input type: short";
        short d = 0;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                d = Short.parseShort(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized long readByte(String mess) {
        String line = "";
        long d = 0L;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: short\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                d = Byte.parseByte(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized byte readByte(String mess, byte dflt) {
        String line = "";
        byte d = 0;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: byte\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                d = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                d = Byte.parseByte(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized byte readByte() {
        String line = "";
        String mess = "Input type: byte";
        byte d = 0;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                d = Byte.parseByte(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return d;
    }

    public static final synchronized char readChar(String mess) {
        String line = "";
        char d = ' ';
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: char\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null || line.equals("")) continue;
            d = line.charAt(0);
            finish = true;
        }
        return d;
    }

    public static final synchronized char readChar(String mess, char dflt) {
        String line = "";
        char d = ' ';
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: char\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                d = dflt;
                finish = true;
                line = null;
                continue;
            }
            d = line.charAt(0);
            finish = true;
        }
        return d;
    }

    public static final synchronized char readChar() {
        String line = "";
        String mess = "Input type: char";
        char d = ' ';
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null || line.equals("")) continue;
            d = line.charAt(0);
            finish = true;
        }
        return d;
    }

    public static final synchronized String readLine(String mess) {
        String line = "";
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: String [a line]\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            finish = true;
        }
        return line;
    }

    public static final synchronized String readLine(String mess, String dflt) {
        String line = "";
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: String [a line]\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                line = dflt;
                finish = true;
                continue;
            }
            finish = true;
        }
        return line;
    }

    public static final synchronized String readLine() {
        String line = "";
        String mess = "Input type: String [a line]";
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            finish = true;
        }
        return line;
    }

    public static final synchronized boolean readBoolean(String mess, boolean dflt) {
        String line = "";
        boolean b = false;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input boolean\n";
        }
        mess = mess + "\n";
        String dfltmess = dflt + "";
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                b = dflt;
                finish = true;
                line = null;
                continue;
            }
            if (line.equals("true") || line.trim().equals("TRUE")) {
                b = true;
                finish = true;
                continue;
            }
            if (!line.equals("false") && !line.trim().equals("FALSE")) continue;
            b = false;
            finish = true;
        }
        return b;
    }

    public static final synchronized boolean readBoolean(String mess) {
        String line = "";
        boolean b = false;
        boolean finish = false;
        System.out.flush();
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input boolean\n";
        }
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            if (line.equals("true") || line.trim().equals("TRUE")) {
                b = true;
                finish = true;
                continue;
            }
            if (!line.equals("false") && !line.trim().equals("FALSE")) continue;
            b = false;
            finish = true;
        }
        return b;
    }

    public static final synchronized boolean readBoolean() {
        String line = "";
        String mess = "Input type: boolean";
        boolean b = false;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            if (line.equals("true") || line.trim().equals("TRUE")) {
                b = true;
                finish = true;
                continue;
            }
            if (!line.equals("false") && !line.trim().equals("FALSE")) continue;
            b = false;
            finish = true;
        }
        return b;
    }

    public static final synchronized BigDecimal readBigDecimal(String mess) {
        String line = "";
        BigDecimal big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigDecimal\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                big = new BigDecimal(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigDecimal readBigDecimal(String mess, BigDecimal dflt) {
        String line = "";
        BigDecimal big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigDecimal\n";
        }
        String dfltmess = dflt.toString() + "";
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigDecimal(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigDecimal readBigDecimal(String mess, String dflt) {
        String line = "";
        BigDecimal big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigDecimal\n";
        }
        String dfltmess = dflt;
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigDecimal(dflt);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigDecimal(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigDecimal readBigDecimal(String mess, double dflt) {
        String line = "";
        BigDecimal big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigDecimal\n";
        }
        Double dfltD = new Double(dflt);
        String dfltmess = dfltD.toString();
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigDecimal(dfltmess);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigDecimal(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigDecimal readBigDecimal(String mess, float dflt) {
        String line = "";
        BigDecimal big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigDecimal\n";
        }
        Float dfltF = new Float(dflt);
        String dfltmess = dfltF.toString();
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigDecimal(dfltmess);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigDecimal(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigDecimal readBigDecimal(String mess, long dflt) {
        String line = "";
        BigDecimal big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigDecimal\n";
        }
        Long dfltF = new Long(dflt);
        String dfltmess = dfltF.toString();
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigDecimal(dfltmess);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigDecimal(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigDecimal readBigDecimal(String mess, int dflt) {
        String line = "";
        BigDecimal big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigDecimal\n";
        }
        Integer dfltF = new Integer(dflt);
        String dfltmess = dfltF.toString();
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigDecimal(dfltmess);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigDecimal(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigDecimal readBigDecimal() {
        String line = "";
        String mess = "Input type: BigDecimal";
        BigDecimal big = null;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                big = new BigDecimal(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigInteger readBigInteger(String mess) {
        String line = "";
        BigInteger big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigInteger\n";
        }
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess);
            if (line == null) continue;
            try {
                big = new BigInteger(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigInteger readBigInteger(String mess, BigInteger dflt) {
        String line = "";
        BigInteger big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigInteger\n";
        }
        String dfltmess = dflt.toString() + "";
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = dflt;
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigInteger(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigInteger readBigInteger(String mess, String dflt) {
        String line = "";
        BigInteger big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigInteger\n";
        }
        String dfltmess = dflt;
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigInteger(dflt);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigInteger(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigInteger readBigInteger(String mess, long dflt) {
        String line = "";
        BigInteger big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigInteger\n";
        }
        Long dfltF = new Long(dflt);
        String dfltmess = dfltF.toString();
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigInteger(dfltmess);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigInteger(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigInteger readBigInteger(String mess, int dflt) {
        String line = "";
        BigInteger big = null;
        boolean finish = false;
        String mess0 = "";
        if (inputTypeInfo) {
            mess0 = "Input type: BigInteger\n";
        }
        Integer dfltF = new Integer(dflt);
        String dfltmess = dfltF.toString();
        mess = mess + "\n";
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess0 + mess + " [default value = " + dflt + "] ", (Object)dfltmess);
            if (line == null) continue;
            if (line.equals("")) {
                big = new BigInteger(dfltmess);
                finish = true;
                line = null;
                continue;
            }
            try {
                big = new BigInteger(line);
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized BigInteger readBigInteger() {
        String line = "";
        String mess = "Input type: BigInteger";
        BigInteger big = null;
        boolean finish = false;
        System.out.flush();
        while (!finish) {
            line = JOptionPane.showInputDialog(mess);
            if (line == null) continue;
            try {
                big = new BigInteger(line.trim());
                finish = true;
            }
            catch (NumberFormatException e) {}
        }
        return big;
    }

    public static final synchronized boolean yesNo(String question) {
        int ans = JOptionPane.showConfirmDialog(null, question, "Db Class Yes or No Box", 0, 3);
        boolean ansb = false;
        if (ans == 0) {
            ansb = true;
        }
        return ansb;
    }

    public static final synchronized boolean noYes(String question) {
        Object[] opts = new Object[]{"Yes", "No"};
        int ans = JOptionPane.showOptionDialog(null, question, "Db Class Yes or No Box", 0, 3, null, opts, opts[1]);
        boolean ansb = false;
        if (ans == 0) {
            ansb = true;
        }
        return ansb;
    }

    public static final synchronized void show(String message, double output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (double)", 1);
    }

    public static final synchronized void show(double output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (double)", 1);
    }

    public static final synchronized void show(String message, double output, int trunc) {
        JOptionPane.showMessageDialog(null, message + " " + Fmath.truncate(output, trunc), "Db.show (double)", 1);
    }

    public static final synchronized void show(double output, int trunc) {
        JOptionPane.showMessageDialog(null, " " + Fmath.truncate(output, trunc), "Db.show (double)", 1);
    }

    public static final synchronized void show(String message, Double output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (Double)", 1);
    }

    public static final synchronized void show(Double output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (Double)", 1);
    }

    public static final synchronized void show(String message, float output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (float)", 1);
    }

    public static final synchronized void show(float output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (float)", 1);
    }

    public static final synchronized void show(String message, float output, int trunc) {
        JOptionPane.showMessageDialog(null, message + " " + Fmath.truncate(output, trunc), "Db.show (float)", 1);
    }

    public static final synchronized void show(float output, int trunc) {
        JOptionPane.showMessageDialog(null, " " + Fmath.truncate(output, trunc), "Db.show (float)", 1);
    }

    public static final synchronized void show(String message, Float output) {
        JOptionPane.showMessageDialog(null, message + " " + output.floatValue(), "Db.show (float)", 1);
    }

    public static final synchronized void show(Float output) {
        JOptionPane.showMessageDialog(null, " " + output.floatValue(), "Db.show (float)", 1);
    }

    public static final synchronized void show(String message, BigDecimal output) {
        JOptionPane.showMessageDialog(null, message + " " + output.toString(), "Db.show (BigDecimal)", 1);
    }

    public static final synchronized void show(BigDecimal output) {
        JOptionPane.showMessageDialog(null, " " + output.toString(), "Db.show (BigDecimal)", 1);
    }

    public static final synchronized void show(String message, BigInteger output) {
        JOptionPane.showMessageDialog(null, message + " " + output.toString(), "Db.show (BigInteger)", 1);
    }

    public static final synchronized void show(BigInteger output) {
        JOptionPane.showMessageDialog(null, " " + output.toString(), "Db.show (BigInteger)", 1);
    }

    public static final synchronized void show(String message, int output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (int)", 1);
    }

    public static final synchronized void show(int output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (int)", 1);
    }

    public static final synchronized void show(String message, Integer output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (int)", 1);
    }

    public static final synchronized void show(Integer output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (int)", 1);
    }

    public static final synchronized void show(String message, long output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (long)", 1);
    }

    public static final synchronized void show(long output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (long)", 1);
    }

    public static final synchronized void show(String message, Long output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (long)", 1);
    }

    public static final synchronized void show(Long output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (long)", 1);
    }

    public static final synchronized void show(String message, short output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (short)", 1);
    }

    public static final synchronized void show(short output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (short)", 1);
    }

    public static final synchronized void show(String message, Short output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (short)", 1);
    }

    public static final synchronized void show(Short output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (short)", 1);
    }

    public static final synchronized void show(String message, byte output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (byte)", 1);
    }

    public static final synchronized void show(byte output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (byte)", 1);
    }

    public static final synchronized void show(String message, Byte output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (byte)", 1);
    }

    public static final synchronized void show(Byte output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (byte)", 1);
    }

    public static final synchronized void show(String message, Complex output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (Complex)", 1);
    }

    public static final synchronized void show(Complex output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (Complex)", 1);
    }

    public static final synchronized void show(String message, Complex output, int trunc) {
        JOptionPane.showMessageDialog(null, message + " " + Complex.truncate(output, trunc), "Db.show (Complex)", 1);
    }

    public static final synchronized void show(Complex output, int trunc) {
        JOptionPane.showMessageDialog(null, " " + Complex.truncate(output, trunc), "Db.show (Complex)", 1);
    }

    public static final synchronized void show(String message, Phasor output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (Phasor)", 1);
    }

    public static final synchronized void show(Phasor output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (Phasor)", 1);
    }

    public static final synchronized void show(String message, Phasor output, int trunc) {
        JOptionPane.showMessageDialog(null, message + " " + Phasor.truncate(output, trunc), "Db.show (Phasor)", 1);
    }

    public static final synchronized void show(Phasor output, int trunc) {
        JOptionPane.showMessageDialog(null, " " + Phasor.truncate(output, trunc), "Db.show (Phasor)", 1);
    }

    public static final synchronized void show(String message, ErrorProp output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (ErrorProp)", 1);
    }

    public static final synchronized void show(ErrorProp output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (ErrorProp)", 1);
    }

    public static final synchronized void show(String message, ErrorProp output, int trunc) {
        JOptionPane.showMessageDialog(null, message + " " + ErrorProp.truncate(output, trunc), "Db.show (ErrorProp)", 1);
    }

    public static final synchronized void show(ErrorProp output, int trunc) {
        JOptionPane.showMessageDialog(null, " " + ErrorProp.truncate(output, trunc), "Db.show (ErrorProp)", 1);
    }

    public static final synchronized void show(String message, ComplexErrorProp output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(ComplexErrorProp output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(String message, ComplexErrorProp output, int trunc) {
        JOptionPane.showMessageDialog(null, message + " " + ComplexErrorProp.truncate(output, trunc), "Db.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(ComplexErrorProp output, int trunc) {
        JOptionPane.showMessageDialog(null, " " + ComplexErrorProp.truncate(output, trunc), "Db.show (ComplexErrorProp)", 1);
    }

    public static final synchronized void show(String message, boolean output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (boolean)", 1);
    }

    public static final synchronized void show(boolean output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (boolean)", 1);
    }

    public static final synchronized void show(String message, Boolean output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (boolean)", 1);
    }

    public static final synchronized void show(Boolean output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (boolean)", 1);
    }

    public static final synchronized void show(String message, char output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (char)", 1);
    }

    public static final synchronized void show(char output) {
        JOptionPane.showMessageDialog(null, " " + output, "Db.show (char)", 1);
    }

    public static final synchronized void show(String message, Character output) {
        JOptionPane.showMessageDialog(null, message + " " + output.charValue(), "Db.show (char)", 1);
    }

    public static final synchronized void show(Character output) {
        JOptionPane.showMessageDialog(null, " " + output.charValue(), "Db.show (char)", 1);
    }

    public static final synchronized void show(String message, String output) {
        JOptionPane.showMessageDialog(null, message + " " + output, "Db.show (String)", 1);
    }

    public static final synchronized void show(String message) {
        JOptionPane.showMessageDialog(null, message, "Db.show (message only)", 1);
    }

    public static final synchronized int optionBox(String headerComment, String[] comments, String[] boxTitles, int defaultBox) {
        int nChoice = boxTitles.length;
        if (nChoice != comments.length) {
            throw new IllegalArgumentException("There must be the same number of boxTitles and comments");
        }
        Object[] options = new Object[nChoice];
        for (int i = 0; i < nChoice; ++i) {
            options[i] = "(" + (i + 1) + ") " + boxTitles[i];
        }
        String quest = "1. " + comments[0] + "\n";
        for (int i = 1; i < nChoice; ++i) {
            quest = quest + (i + 1) + ". " + comments[i] + "\n";
        }
        return 1 + JOptionPane.showOptionDialog(null, quest, headerComment, 1, 3, null, options, options[defaultBox - 1]);
    }

    public static final synchronized int optionBox(String headerComment, String quest, String[] boxTitles, int defaultBox) {
        int nChoice = boxTitles.length;
        Object[] options = new Object[nChoice];
        for (int i = 0; i < nChoice; ++i) {
            options[i] = "(" + (i + 1) + ") " + boxTitles[i];
        }
        return 1 + JOptionPane.showOptionDialog(null, quest, headerComment, 1, 3, null, options, options[defaultBox - 1]);
    }

    public static final synchronized void endProgram() {
        int ans = JOptionPane.showConfirmDialog(null, "Do you wish to end the program", "End Program", 0, 3);
        if (ans == 0) {
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(null, "Now you must press the appropriate escape key/s, e.g. Ctrl C, to exit this program");
        }
    }
}

