/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import java.util.Collection;
import java.util.HashSet;

public class LossOfFunction {
    public static final int MND_BASES_BEFORE_LAST_JUNCTION = 50;
    public static final double DEFAULT_IGNORE_PROTEIN_CODING_AFTER = 0.95;
    public double ignoreProteinCodingAfter;
    public static final double DEFAULT_IGNORE_PROTEIN_CODING_BEFORE = 0.05;
    public double ignoreProteinCodingBefore;
    public static final double DEFAULT_DELETE_PROTEIN_CODING_BASES = 0.5;
    public double deleteProteinCodingBases;
    Config config;
    HashSet<Transcript> transcriptsLof;
    HashSet<Gene> genesLof;
    HashSet<Transcript> transcriptsNmd;
    HashSet<Gene> genesNmd;
    Collection<ChangeEffect> changeEffects;
    int lofCount = -1;
    int nmdCount = -1;

    public LossOfFunction(Collection<ChangeEffect> changeEffects) {
        this.changeEffects = changeEffects;
        this.transcriptsLof = new HashSet();
        this.genesLof = new HashSet();
        this.transcriptsNmd = new HashSet();
        this.genesNmd = new HashSet();
        this.config = Config.get();
        this.ignoreProteinCodingBefore = this.config.getLofIgnoreProteinCodingBefore();
        this.ignoreProteinCodingAfter = this.config.getLofIgnoreProteinCodingAfter();
        this.deleteProteinCodingBases = this.config.getLofDeleteProteinCodingBases();
    }

    public boolean isLof() {
        if (this.lofCount < 0) {
            this.nmdCount = 0;
            this.lofCount = 0;
            for (ChangeEffect changeEffect : this.changeEffects) {
                if (!this.isLof(changeEffect)) continue;
                ++this.lofCount;
            }
        }
        return this.lofCount > 0;
    }

    protected boolean isLof(ChangeEffect changeEffect) {
        Gene gene = changeEffect.getGene();
        Transcript tr = changeEffect.getTranscript();
        if (gene == null || tr == null || !gene.isProteinCoding() && !this.config.isTreatAllAsProteinCoding() || !tr.isProteinCoding() && !this.config.isTreatAllAsProteinCoding()) {
            return false;
        }
        boolean lof = false;
        if (changeEffect.getEffectType() == ChangeEffect.EffectType.FRAME_SHIFT) {
            double perc = this.percentCds(changeEffect);
            lof |= this.ignoreProteinCodingBefore <= perc && perc <= this.ignoreProteinCodingAfter;
        }
        if (changeEffect.getSeqChange().isDel()) {
            lof |= this.isLofDeletion(changeEffect);
        }
        switch (changeEffect.getEffectType()) {
            case SPLICE_SITE_ACCEPTOR: 
            case SPLICE_SITE_DONOR: {
                SpliceSite spliceSite;
                if (changeEffect.getMarker() == null || !(changeEffect.getMarker() instanceof SpliceSite) || !(spliceSite = (SpliceSite)changeEffect.getMarker()).intersectsCoreSpliceSite(changeEffect.getSeqChange())) break;
                lof = true;
                break;
            }
            case STOP_GAINED: {
                lof |= this.isNmd(changeEffect);
                break;
            }
            case RARE_AMINO_ACID: 
            case START_LOST: {
                lof = true;
                break;
            }
        }
        if (lof) {
            this.transcriptsLof.add(changeEffect.getTranscript());
            this.genesLof.add(changeEffect.getGene());
        }
        return lof;
    }

    protected boolean isLofDeletion(ChangeEffect changeEffect) {
        int end;
        SeqChange seqChange;
        Transcript tr = changeEffect.getTranscript();
        if (tr == null) {
            throw new RuntimeException("Transcript not found for change:\n\t" + changeEffect);
        }
        if (changeEffect.getEffectType() == ChangeEffect.EffectType.EXON_DELETED) {
            seqChange = changeEffect.getSeqChange();
            if (seqChange == null) {
                throw new RuntimeException("Cannot retrieve 'seqChange' from EXON_DELETED effect!");
            }
            if (seqChange.includes(tr.getFirstCodingExon())) {
                return true;
            }
        }
        seqChange = changeEffect.getSeqChange();
        int cdsStart = tr.isStrandPlus() ? tr.getCdsStart() : tr.getCdsEnd();
        int cdsEnd = tr.isStrandPlus() ? tr.getCdsEnd() : tr.getCdsStart();
        Marker coding = new Marker(seqChange.getChromosome(), cdsStart, cdsEnd, 1, "");
        int start = Math.max(cdsStart, seqChange.getStart());
        if (start >= (end = Math.min(cdsEnd, seqChange.getEnd()))) {
            return false;
        }
        Marker codingDeleted = new Marker(seqChange.getChromosome(), start, end, 1, "");
        int codingBasesDeleted = 0;
        int codingBases = 0;
        for (Exon exon : tr) {
            codingBasesDeleted += codingDeleted.intersectSize(exon);
            codingBases += coding.intersectSize(exon);
        }
        double percDeleted = (double)codingBasesDeleted / (double)codingBases;
        return percDeleted > this.deleteProteinCodingBases;
    }

    public boolean isNmd() {
        if (this.nmdCount < 0) {
            this.isLof();
        }
        return this.nmdCount > 0;
    }

    protected boolean isNmd(ChangeEffect changeEffect) {
        boolean nmd;
        Transcript tr = changeEffect.getTranscript();
        if (tr == null) {
            throw new RuntimeException("Transcript not found for change:\n\t" + changeEffect);
        }
        if (tr.numChilds() <= 1) {
            return false;
        }
        int lastNmdPos = this.lastNmdPos(tr);
        if (lastNmdPos < 0) {
            return false;
        }
        SeqChange seqChange = changeEffect.getSeqChange();
        if (tr.isStrandPlus()) {
            nmd = seqChange.getStart() <= lastNmdPos;
        } else {
            boolean bl = nmd = lastNmdPos <= seqChange.getEnd();
        }
        if (nmd) {
            this.transcriptsNmd.add(changeEffect.getTranscript());
            this.genesNmd.add(changeEffect.getGene());
            ++this.nmdCount;
        }
        return nmd;
    }

    public int lastNmdPos(Transcript tr) {
        int cdsEnd = tr.getCdsEnd();
        int cdsStart = tr.getCdsStart();
        Marker cds = new Marker(tr.getChromosome(), Math.min(cdsStart, cdsEnd), Math.max(cdsStart, cdsEnd), tr.getStrand(), "");
        Interval lastExon = null;
        int countCodingExons = 0;
        for (Exon exon : tr.sortedStrand()) {
            if (exon.intersects(cdsEnd)) {
                lastExon = exon;
            }
            if (!cds.intersects(exon)) continue;
            ++countCodingExons;
        }
        if (countCodingExons <= 1) {
            return -1;
        }
        if (lastExon == null) {
            throw new RuntimeException("Cannot find last coding exon for transcript '" + tr.getId() + "' (cdsEnd: " + cdsEnd + ")\n\t" + tr);
        }
        int lastExonJunction = tr.isStrandPlus() ? lastExon.getStart() : lastExon.getEnd();
        int[] chrPos = tr.cdsBaseNumber2ChrPos();
        int lastNmdPos = -1;
        for (int cdsi = chrPos.length - 1; cdsi >= 0; --cdsi) {
            if (chrPos[cdsi] != lastExonJunction) continue;
            if (cdsi <= 50) {
                return tr.isStrandPlus() ? 0 : Integer.MAX_VALUE;
            }
            lastNmdPos = chrPos[cdsi - 50 - 1];
            return lastNmdPos;
        }
        throw new RuntimeException("Cannot find last exon junction position for transcript '" + tr.getId() + "'\n\t" + tr);
    }

    double percentCds(ChangeEffect changeEffect) {
        int cdsLen = changeEffect.getAaLength();
        int codonNum = changeEffect.getCodonNum();
        if (cdsLen >= 0 && codonNum >= 0) {
            return (double)codonNum / (double)cdsLen;
        }
        return Double.NaN;
    }

    double percentOfTranscriptsAffected(Gene gene, HashSet<Transcript> transcripts) {
        if (gene == null) {
            return 0.0;
        }
        int countAffected = 0;
        for (Transcript tr : gene) {
            if (!transcripts.contains(tr)) continue;
            ++countAffected;
        }
        return (double)countAffected / (double)gene.numChilds();
    }

    public String toString() {
        return (this.isLof() ? "LOF=" + this.vcfLofValue() + " " : "") + (this.isNmd() ? "NMD=" + this.vcfNmdValue() : "");
    }

    public String vcfLofValue() {
        StringBuilder sb = new StringBuilder();
        for (Gene gene : this.genesLof) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(String.format("%s|%s|%d|%.2f", gene.getGeneName(), gene.getId(), gene.numChilds(), this.percentOfTranscriptsAffected(gene, this.transcriptsLof)));
        }
        return sb.toString();
    }

    public String vcfNmdValue() {
        StringBuilder sb = new StringBuilder();
        for (Gene gene : this.genesNmd) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(String.format("%s|%s|%d|%.2f", gene.getGeneName(), gene.getId(), gene.numChilds(), this.percentOfTranscriptsAffected(gene, this.transcriptsNmd)));
        }
        return sb.toString();
    }
}

