/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerParentId;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.RareAminoAcid;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteAcceptor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteBranch;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteBranchU12;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteDonor;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;

public class MarkerSerializer {
    PrintStream outFile;
    int lineNum;
    String line;
    int parsedField;
    String[] fields;
    int currId = 0;
    HashMap<Integer, Marker> markerById = new HashMap();
    HashMap<Marker, Integer> idByMarker = new HashMap();

    protected void add(Markers markers, Genome genome) {
        markers.add(genome);
        for (Chromosome chr : genome) {
            markers.add(chr);
        }
        for (Gene g : genome.getGenes()) {
            markers.add(g);
        }
    }

    protected int getIdByMarker(Marker m) {
        Integer id = this.idByMarker.get(m);
        if (id == null) {
            throw new RuntimeException("Marker has no numeric ID. \n\tClass    : " + m.getClass().getSimpleName() + "\n" + "\tMarker ID: '" + m.getId() + "'\n" + "\t" + m);
        }
        return id;
    }

    protected Marker getMarkerById(int id) {
        return this.markerById.get(id);
    }

    protected String getNextField() {
        if (this.fields.length <= this.parsedField) {
            return "";
        }
        return this.fields[this.parsedField++];
    }

    protected boolean getNextFieldBoolean() {
        return Gpr.parseBoolSafe(this.getNextField());
    }

    protected int getNextFieldInt() {
        return Gpr.parseIntSafe(this.getNextField());
    }

    protected Marker getNextFieldMarker() {
        return this.getMarkerById(this.getNextFieldInt());
    }

    protected Markers getNextFieldMarkers() {
        String[] fieldIds;
        Markers markers = new Markers();
        String fieldIdsStr = this.getNextField();
        if (fieldIdsStr.isEmpty()) {
            return markers;
        }
        for (String idStr : fieldIds = fieldIdsStr.split(",")) {
            int id = Gpr.parseIntSafe(idStr);
            Marker m = this.getMarkerById(id);
            if (m == null) {
                throw new RuntimeException("Marker '" + id + "' not found. This should never happen!");
            }
            markers.add(m);
        }
        return markers;
    }

    protected int getNextId() {
        return ++this.currId;
    }

    public Markers load(String fileName) {
        LineFileIterator lfi = new LineFileIterator(fileName, true);
        int lineNum = 0;
        Iterator<String> i$ = lfi.iterator();
        while (i$.hasNext()) {
            String l;
            this.line = l = i$.next();
            this.parsedField = 0;
            this.fields = this.line.split("\t", -1);
            String typeStr = this.fields[0];
            ChangeEffect.EffectType type = ChangeEffect.EffectType.valueOf(typeStr);
            String idStr = this.fields[1];
            int id = Gpr.parseIntSafe(idStr);
            Marker m = null;
            switch (type) {
                case GENOME: {
                    m = new Genome();
                    break;
                }
                case CHROMOSOME: {
                    m = new Chromosome();
                    break;
                }
                case GENE: {
                    m = new Gene();
                    break;
                }
                case TRANSCRIPT: {
                    m = new Transcript();
                    break;
                }
                case CDS: {
                    m = new Cds();
                    break;
                }
                case EXON: {
                    m = new Exon();
                    break;
                }
                case UTR_3_PRIME: {
                    m = new Utr3prime();
                    break;
                }
                case UTR_5_PRIME: {
                    m = new Utr5prime();
                    break;
                }
                case RARE_AMINO_ACID: {
                    m = new RareAminoAcid();
                    break;
                }
                case SPLICE_SITE_ACCEPTOR: {
                    m = new SpliceSiteAcceptor();
                    break;
                }
                case SPLICE_SITE_BRANCH: {
                    m = new SpliceSiteBranch();
                    break;
                }
                case SPLICE_SITE_BRANCH_U12: {
                    m = new SpliceSiteBranchU12();
                    break;
                }
                case SPLICE_SITE_DONOR: {
                    m = new SpliceSiteDonor();
                    break;
                }
                default: {
                    throw new RuntimeException("Unimplemented for type '" + (Object)((Object)type) + "'");
                }
            }
            try {
                m.serializeParse(this);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException("Error parsing line " + (lineNum + 1) + " from file '" + fileName + "'\n\t" + this.line + "\n\tField [" + this.parsedField + "] : '" + (this.parsedField < this.fields.length ? this.fields[this.parsedField] : "-") + "'", t);
            }
            this.markerById.put(id, m);
            ++lineNum;
        }
        Markers markers = new Markers();
        for (Marker m : this.markerById.values()) {
            MarkerParentId mpid = (MarkerParentId)m.getParent();
            int parentId = mpid.getParentId();
            Marker parent = this.getMarkerById(parentId);
            m.setParent(parent);
            markers.add(m);
        }
        return markers;
    }

    protected String save(Iterable<Marker> markersCollection) {
        StringBuilder idStr = new StringBuilder();
        for (Marker m : markersCollection) {
            int id = this.save(m);
            if (idStr.length() > 0) {
                idStr.append(",");
            }
            idStr.append(id);
        }
        return idStr.toString();
    }

    protected int save(Marker m) {
        if (m == null) {
            return -1;
        }
        if (this.idByMarker.containsKey(m)) {
            return this.idByMarker.get(m);
        }
        int id = this.getNextId();
        this.idByMarker.put(m, id);
        String line = m.serializeSave(this);
        this.outFile.print(line + "\n");
        ++this.lineNum;
        return id;
    }

    public void save(String fileName, Genome genome) {
        Markers markers = new Markers();
        this.add(markers, genome);
        this.save(fileName, markers);
    }

    public void save(String fileName, Markers markers) {
        try {
            this.lineNum = 0;
            this.currId = 0;
            this.outFile = new PrintStream(new GZIPOutputStream(new FileOutputStream(fileName)));
            for (Marker m : markers) {
                this.save(m);
            }
            this.outFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(String fileName, SnpEffectPredictor snpEffectPredictor) {
        Markers markers = new Markers();
        this.add(markers, snpEffectPredictor.getGenome());
        markers.add(snpEffectPredictor.getMarkers());
        this.save(fileName, markers);
    }
}

