/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

public class NeedlemanWunsch {
    String alignment;
    char[] a;
    char[] b;
    int[][] score;
    int match = 1;
    int missMatch = -1;
    int deletion = -2;
    int offset = 0;

    public NeedlemanWunsch(String a, String b) {
        this.score = new int[a.length() + 1][b.length() + 1];
        this.a = a.toCharArray();
        this.b = b.toCharArray();
    }

    public String align() {
        this.scoreMatrix();
        this.calcAlignments();
        return this.alignment;
    }

    void calcAlignments() {
        int h;
        int maxLen = Math.max(this.a.length, this.b.length);
        char[] alignmentA = new char[maxLen];
        char[] alignmentB = new char[maxLen];
        int i = this.a.length;
        int j = this.b.length;
        for (h = maxLen - 1; i > 0 && j > 0 && h >= 0; --h) {
            int s = this.getScore(i, j);
            int scorediag = this.getScore(i - 1, j - 1);
            int scoreup = this.getScore(i, j - 1);
            int scoreleft = this.getScore(i - 1, j);
            if (s == scoreup + this.deletion) {
                alignmentA[h] = 45;
                alignmentB[h] = this.b[j - 1];
                --j;
                continue;
            }
            if (s == scoreleft + this.deletion) {
                alignmentA[h] = this.a[i - 1];
                alignmentB[h] = 45;
                --i;
                continue;
            }
            if (s == scorediag + this.simmilarity(i, j)) {
                alignmentA[h] = 32;
                alignmentB[h] = 32;
                --i;
                --j;
                continue;
            }
            throw new RuntimeException("This should never happen!");
        }
        while (i > 0 && h >= 0) {
            alignmentA[h] = this.a[i - 1];
            alignmentB[h] = 45;
            --i;
            --h;
        }
        while (j > 0 && h >= 0) {
            alignmentA[h] = 45;
            alignmentB[h] = this.b[j - 1];
            --j;
            --h;
        }
        this.offset = 0;
        while (this.offset < maxLen && alignmentA[this.offset] == ' ') {
            ++this.offset;
        }
        StringBuffer alsb = new StringBuffer();
        int prev = 32;
        for (i = 0; i < maxLen; ++i) {
            if (alignmentA[i] == '-') {
                if (prev != 45) {
                    alsb.append('-');
                }
                alsb.append(alignmentB[i]);
                prev = 45;
                continue;
            }
            if (alignmentB[i] != '-') continue;
            if (prev != 43) {
                alsb.append('+');
            }
            alsb.append(alignmentA[i]);
            prev = 43;
        }
        this.alignment = alsb.toString();
    }

    public int getAligmentScore() {
        return this.getScore(this.a.length, this.b.length);
    }

    public String getAlignment() {
        return this.alignment;
    }

    public int getOffset() {
        return this.offset;
    }

    int getScore(int i, int j) {
        return this.score[i][j];
    }

    void scoreMatrix() {
        int i;
        for (i = 0; i <= this.a.length; ++i) {
            this.setScore(i, 0, this.deletion * i);
        }
        for (int j = 0; j <= this.b.length; ++j) {
            this.setScore(0, j, this.deletion * j);
        }
        for (i = 1; i <= this.a.length; ++i) {
            for (int j = 1; j <= this.b.length; ++j) {
                int match = this.getScore(i - 1, j - 1) + this.simmilarity(i, j);
                int del = this.getScore(i - 1, j) + this.deletion;
                int ins = this.getScore(i, j - 1) + this.deletion;
                int s = Math.max(match, Math.max(del, ins));
                this.setScore(i, j, s);
            }
        }
    }

    public void setDeletion(int deletion) {
        this.deletion = deletion;
    }

    public void setMatch(int match) {
        this.match = match;
    }

    public void setMissMatch(int missMatch) {
        this.missMatch = missMatch;
    }

    void setScore(int i, int j, int val) {
        this.score[i][j] = val;
    }

    int simmilarity(int i, int j) {
        if (this.a[i - 1] != this.b[j - 1]) {
            return this.missMatch;
        }
        return this.match;
    }
}

