/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import java.util.Collection;

public class StorePipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, Collection> {
    private Collection storage;
    private PipeFunction<S, ?> preStoreFunction = null;

    public StorePipe(Collection storage) {
        this.storage = storage;
    }

    public StorePipe(Collection storage, PipeFunction<S, ?> preStoreFunction) {
        this(storage);
        this.preStoreFunction = preStoreFunction;
    }

    @Override
    protected S processNextStart() {
        Object s = this.starts.next();
        if (null != this.preStoreFunction) {
            this.storage.add(this.preStoreFunction.compute(s));
        } else {
            this.storage.add(s);
        }
        return (S)s;
    }

    @Override
    public Collection getSideEffect() {
        return this.storage;
    }

    @Override
    public void reset() {
        try {
            this.storage = (Collection)this.storage.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.reset();
    }
}

