/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.iterators.HistoryIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractPipe<S, E>
implements Pipe<S, E> {
    protected Iterator<S> starts;
    private E nextEnd;
    protected E currentEnd;
    private boolean available = false;
    protected boolean pathEnabled = false;

    @Override
    public void setStarts(Iterator<S> starts) {
        this.starts = starts instanceof Pipe ? starts : new HistoryIterator<S>(starts);
    }

    @Override
    public void setStarts(Iterable<S> starts) {
        this.setStarts(starts.iterator());
    }

    public void setStarts(Pipe<?, S> starts) {
        this.setStarts(starts.iterator());
    }

    @Override
    public void reset() {
        if (this.starts instanceof Pipe) {
            ((Pipe)this.starts).reset();
        }
        this.nextEnd = null;
        this.currentEnd = null;
        this.available = false;
    }

    @Override
    public List getCurrentPath() {
        if (this.pathEnabled) {
            List pathElements = this.getPathToHere();
            int size = pathElements.size();
            if (size == 0 || pathElements.get(size - 1) != this.currentEnd) {
                pathElements.add(this.currentEnd);
            }
            return pathElements;
        }
        throw new RuntimeException("Path calculations are not enabled");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E next() {
        if (this.available) {
            this.available = false;
            this.currentEnd = this.nextEnd;
            return this.currentEnd;
        }
        this.currentEnd = this.processNextStart();
        return this.currentEnd;
    }

    @Override
    public boolean hasNext() {
        if (this.available) {
            return true;
        }
        try {
            this.nextEnd = this.processNextStart();
            this.available = true;
            return true;
        }
        catch (NoSuchElementException e) {
            this.available = false;
            return false;
        }
    }

    @Override
    public void enablePath(boolean enable) {
        this.pathEnabled = enable;
        if (this.starts instanceof Pipe) {
            ((Pipe)this.starts).enablePath(enable);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public String toString() {
        return PipeHelper.makePipeString(this, new Object[0]);
    }

    protected abstract E processNextStart() throws NoSuchElementException;

    protected List getPathToHere() {
        if (this.starts instanceof Pipe) {
            return ((Pipe)this.starts).getCurrentPath();
        }
        if (this.starts instanceof HistoryIterator) {
            ArrayList list = new ArrayList();
            list.add(((HistoryIterator)this.starts).getLast());
            return list;
        }
        return new ArrayList();
    }
}

