/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.cli.cmd.CommandUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class UpdateColumnsTsvCommand
implements CommandPlugin {
    private static final String OPTION_COLUMNS_TSV_TO_MODIFY = "f";
    private static final String OPTION_COLUMNS_TSV_PATCH = "p";
    private static final String OPTION_TEST_ONLY = "t";
    static Logger sLogger = Logger.getLogger(UpdateColumnsTsvCommand.class);
    private String mCmdName;

    public void init(Properties properties) throws Exception {
        this.mCmdName = properties.getProperty("command.name");
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        try {
            boolean isTestOnly = cl.hasOption(OPTION_TEST_ONLY);
            File columnsTsvToModify = this.getColsTsvFileToModify(cl, OPTION_COLUMNS_TSV_TO_MODIFY, isTestOnly);
            File patchFile = this.getPatchFile(cl, isTestOnly);
            this.updateColumnsTsv(columnsTsvToModify, patchFile, isTestOnly);
        }
        catch (Exception e) {
            sLogger.error((Object)("Error while executing command " + this.mCmdName), (Throwable)e);
            throw e;
        }
    }

    private File getPatchFile(CommandLine cl, boolean isTestOnly) throws Exception {
        String patchFilePath = cl.getOptionValue(OPTION_COLUMNS_TSV_PATCH);
        File patchFile = null;
        if (isTestOnly) {
            patchFile = this.isGiven(patchFilePath) ? new File(patchFilePath) : null;
        } else {
            List<CommandUtil.FileAttributes> fileAttrs = Arrays.asList(CommandUtil.FileAttributes.EXISTS, CommandUtil.FileAttributes.READABLE);
            patchFile = CommandUtil.handleFile(cl, OPTION_COLUMNS_TSV_PATCH, fileAttrs);
        }
        return patchFile;
    }

    private File getColsTsvFileToModify(CommandLine cl, String optionStr, boolean isTestOnly) throws Exception {
        List<CommandUtil.FileAttributes> fileAttrs = isTestOnly ? Arrays.asList(CommandUtil.FileAttributes.EXISTS, CommandUtil.FileAttributes.READABLE) : Arrays.asList(CommandUtil.FileAttributes.EXISTS, CommandUtil.FileAttributes.READABLE, CommandUtil.FileAttributes.WRITEABLE);
        File file = CommandUtil.handleFile(cl, optionStr, fileAttrs);
        return file;
    }

    private void updateColumnsTsv(File columnsTsvToModify, File patchFile, boolean isTestOnly) throws IOException {
        ColumnMetaDataOperations colOps = new ColumnMetaDataOperations(columnsTsvToModify);
        List colsTarget = colOps.loadAsList();
        HashMap colsPatchMap = new HashMap();
        if (patchFile != null && patchFile.exists() && patchFile.canRead()) {
            ColumnMetaDataOperations colOpsPatch = new ColumnMetaDataOperations(patchFile);
            colsPatchMap = colOpsPatch.load();
        }
        for (ColumnMetaData targetColMeta : colsTarget) {
            ColumnMetaData patchColMeta = (ColumnMetaData)colsPatchMap.get(targetColMeta.getColumnName());
            String diffs = this.getDiffs(targetColMeta, patchColMeta, isTestOnly);
            String verify = this.getVerifyMsgs(targetColMeta, isTestOnly);
            this.printMsgs(targetColMeta, diffs, verify);
        }
        if (!isTestOnly) {
            colOps.save(colsTarget, true);
        } else {
            System.err.println("\nNOTE: The test-only flag was supplied, so changes will NOT go into the target columns.tsv\n");
        }
    }

    private void printMsgs(ColumnMetaData targetColMeta, String diffs, String verify) {
        String allMsgs = this.trimOutsideNewlines(diffs + verify);
        if (allMsgs.length() > 0) {
            System.err.println("\n--------------------------------------------\nField: " + targetColMeta.getColumnName() + "\n" + allMsgs);
        }
    }

    private String trimOutsideNewlines(String s) {
        StringBuilder str = new StringBuilder(s);
        while (str.length() > 0 && str.charAt(0) == '\n') {
            str.deleteCharAt(0);
        }
        while (str.length() > 0 && str.charAt(str.length() - 1) == '\n') {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    private String getDiffs(ColumnMetaData targetColMeta, ColumnMetaData patchColMeta, boolean isTestOnly) {
        StringBuilder msg = new StringBuilder();
        if (patchColMeta != null) {
            msg.append(this.updateHumanReadableName(targetColMeta, patchColMeta, isTestOnly));
            msg.append(this.updateDescription(targetColMeta, patchColMeta, isTestOnly));
            msg.append(this.warnIfTypeDiff(targetColMeta, patchColMeta));
            msg.append(this.warnIfCountDiff(targetColMeta, patchColMeta));
        }
        return msg.toString();
    }

    private String getVerifyMsgs(ColumnMetaData targetColMeta, boolean isTestOnly) {
        StringBuilder msg = new StringBuilder();
        msg.append(this.warnAndFixDoubleQuotes(targetColMeta, isTestOnly));
        msg.append(this.warnAndFixBlankColumns(targetColMeta, isTestOnly));
        msg.append(this.errorOnBadColumnNameCountAndType(targetColMeta, isTestOnly));
        msg.append(this.warnHumanReadableNameSameAsColumnName(targetColMeta));
        return msg.toString();
    }

    private String updateHumanReadableName(ColumnMetaData targetColMeta, ColumnMetaData patchColMeta, boolean isTestOnly) {
        String msg = "";
        if (this.isGiven(patchColMeta.getHumanReadableName()) && !this.isSame(targetColMeta.getHumanReadableName(), patchColMeta.getHumanReadableName())) {
            msg = "  HumanReadableName updated: [" + targetColMeta.getHumanReadableName() + "] ==> [" + patchColMeta.getHumanReadableName() + "]\n";
            targetColMeta.setHumanReadableName(patchColMeta.getHumanReadableName());
        }
        return msg;
    }

    private String updateDescription(ColumnMetaData targetColMeta, ColumnMetaData patchColMeta, boolean isTestOnly) {
        String msg = "";
        if (this.isGiven(patchColMeta.getDescription()) && !this.isSame(targetColMeta.getDescription(), patchColMeta.getDescription())) {
            msg = "  Description updated:       [" + targetColMeta.getDescription() + "] ==> [" + patchColMeta.getDescription() + "]\n";
            targetColMeta.setDescription(patchColMeta.getDescription());
        }
        return msg;
    }

    private boolean isSame(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private String warnIfTypeDiff(ColumnMetaData targetColMeta, ColumnMetaData patchColMeta) {
        if (this.isDifferent(targetColMeta.getTypeStrOriginal(), patchColMeta.getTypeStrOriginal())) {
            return "  Warning: Type is different between target [" + targetColMeta.getTypeStrOriginal() + "] and patch [" + patchColMeta.getTypeStrOriginal() + "]\n";
        }
        return "";
    }

    private boolean isDifferent(String targetStr, String patchStr) {
        return this.isGiven(targetStr) && this.isGiven(patchStr) && !targetStr.equals(patchStr);
    }

    private String warnIfCountDiff(ColumnMetaData targetColMeta, ColumnMetaData patchColMeta) {
        if (this.isDifferent(targetColMeta.getCount(), patchColMeta.getCount())) {
            return "  Warning: Count is different between target [" + targetColMeta.getCount() + "] and patch [" + patchColMeta.getCount() + "]\n";
        }
        return "";
    }

    private String warnAndFixDoubleQuotes(ColumnMetaData targetColMeta, boolean isTestOnly) {
        StringBuilder msg = new StringBuilder();
        if (targetColMeta.getColumnName().contains("\"")) {
            msg.append("  ERROR: ColumnName cannot contain double-quotes.\n");
        }
        if (targetColMeta.getHumanReadableName().contains("\"")) {
            msg.append("  Warning: HumanReadableName cannot contain double-quotes.  These have been converted to single quotes.\n");
            targetColMeta.setHumanReadableName(targetColMeta.getHumanReadableName().replaceAll("\"", "'"));
        }
        if (targetColMeta.getDescription().contains("\"")) {
            msg.append("  Warning: Description cannot contain double-quotes.  These have been converted to single quotes.\n");
            targetColMeta.setDescription(targetColMeta.getDescription().replaceAll("\"", "'"));
        }
        return msg.toString();
    }

    private Object warnAndFixBlankColumns(ColumnMetaData targetColMeta, boolean isTestOnly) {
        StringBuilder msg = new StringBuilder();
        if (!this.isGiven(targetColMeta.getColumnName())) {
            msg.append("  ERROR: ColumnName cannot be blank.\n");
        }
        if (!this.isGiven(targetColMeta.getDescription()) || targetColMeta.getDescription().equals(".")) {
            msg.append("  Warning: Description is missing.");
            if (!targetColMeta.getDescription().equals(".")) {
                msg.append("  Setting this to dot.");
                targetColMeta.setDescription(".");
            }
            msg.append("\n");
        }
        if (!this.isGiven(targetColMeta.getHumanReadableName()) || targetColMeta.getHumanReadableName().equals(".")) {
            msg.append("  Warning: HumanReadableName is missing.   Setting this to to the same as the ColumnName.\n");
            targetColMeta.setHumanReadableName(targetColMeta.getColumnName());
        }
        return msg.toString();
    }

    private String errorOnBadColumnNameCountAndType(ColumnMetaData targetColMeta, boolean isTestOnly) {
        StringBuilder msg = new StringBuilder();
        if (!this.isValidType(targetColMeta.getType())) {
            msg.append("  ERROR: Type [" + targetColMeta.getTypeStrOriginal() + "] is not valid.  Possible types include: " + this.getTypesAsList() + "\n");
        }
        if (!this.isValidCount(targetColMeta.getCount())) {
            msg.append("  ERROR: Count [" + targetColMeta.getCount() + "] is not valid.  It must be one of the values: '.', 'A', 'G', 'R', or a non-negative integer (0,1,2...)\n");
        }
        return msg.toString();
    }

    private boolean isValidType(ColumnMetaData.Type type) {
        return type != null;
    }

    private String getTypesAsList() {
        StringBuilder s = new StringBuilder();
        for (ColumnMetaData.Type type : ColumnMetaData.Type.values()) {
            if (s.length() > 0) {
                s.append(",  ");
            }
            s.append(type.name());
        }
        return s.toString();
    }

    private boolean isValidCount(String count) {
        return ".".equals(count) || "A".equalsIgnoreCase(count) || "R".equalsIgnoreCase(count) || "G".equalsIgnoreCase(count) || this.isZeroOrPositiveInt(count);
    }

    private boolean isZeroOrPositiveInt(String count) {
        try {
            Integer i = Integer.parseInt(count);
            return i >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String warnHumanReadableNameSameAsColumnName(ColumnMetaData targetColMeta) {
        String humanReadableName;
        String colName = targetColMeta.getColumnName();
        if (colName.equals(humanReadableName = targetColMeta.getHumanReadableName())) {
            return "  Warning: HumanReadableName is same as ColumnName [" + colName + "].  Please update the HumanReadableName";
        }
        return "";
    }

    private boolean isGiven(String s) {
        return s != null && s.length() > 0;
    }
}

