/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.SNPEff.SNPEFFPipeline;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.util.ClasspathUtil;
import edu.mayo.bior.util.DependancyUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class SNPEffCommand
implements CommandPlugin {
    public static final String DEFAULT_GENOME_VERSION = "GRCh37.64";
    private static final String OPTION_HOMO = "hom";
    private static final String OPTION_SNP = "snp";
    private static final String OPTION_HET = "het";
    private static final String OPTION_DELETIONS = "del";
    private static final String OPTION_INSERTIONS = "ins";
    private static final String OPTION_MINQ = "minQ";
    private static final String OPTION_MAXQ = "maxQ";
    private static final String OPTION_MINC = "minC";
    private static final String OPTION_MAXC = "maxC";
    private static final String OPTION_NODOWNSTREAM = "no_downstream";
    private static final String OPTION_NOINTERGENIC = "no_integenic";
    private static final String OPTION_NOINTRON = "no_intron";
    private static final String OPTION_NOUPSTREAM = "no_upstream";
    private static final String OPTION_NOUTR = "no_utr";
    private static final String OPTION_ONLYCODING = "onlyCoding";
    private static final String OPTION_UPDOWNSTREAMLENGTH = "ud";
    private static final char OPTION_STATSFILE = 's';
    private static final String OPTION_INTERVALFILE = "interval";
    private static final String OPTION_PICKALL = "all";
    private static final String OPTION_DASH = "-";
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;
    private static final Logger sLogger = Logger.getLogger(SNPEffCommand.class);

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        System.err.println("WARNING:  THIS COMMAND WILL BE REMOVED IN BIOR v5.0.0!");
        System.err.println("You can continue to use older versions of BioR to run this command");
        System.err.println("SNPEFF Starting up... this will take about a minute");
        if (!DependancyUtil.isSNPEffInstalled()) {
            throw new Exception("Error: SnpEffect is not installed");
        }
        SNPEFFPipeline snpEffPipe = null;
        boolean pickworst = Boolean.TRUE;
        if (line.hasOption(OPTION_PICKALL)) {
            pickworst = Boolean.FALSE;
        }
        File dataSourceProps = ClasspathUtil.loadResource("/tools/snpeff.datasource.properties");
        File columnProps = ClasspathUtil.loadResource("/tools/snpeff.columns.tsv");
        Metadata metadata = new Metadata(dataSourceProps.getCanonicalPath(), columnProps.getCanonicalPath(), this.operation);
        try {
            snpEffPipe = new SNPEFFPipeline(this.getCommandLineOptions(line), pickworst);
            HistoryInPipe preLogic = new HistoryInPipe(metadata);
            SNPEFFPipeline logic = snpEffPipe;
            HistoryOutPipe postLogic = new HistoryOutPipe();
            this.mPipeline.execute(preLogic, logic, postLogic);
        }
        catch (Exception e) {
            sLogger.error((Object)("Could not execute SNPEffCommand.  " + e.getMessage()));
            throw e;
        }
        finally {
            if (snpEffPipe != null) {
                snpEffPipe.terminate();
            }
        }
    }

    private String[] getCommandLineOptions(CommandLine line) {
        ArrayList<String> cmdoptions = new ArrayList<String>();
        if (line.hasOption(OPTION_SNP)) {
            cmdoptions.add("-snp");
        }
        if (line.hasOption(OPTION_HET)) {
            cmdoptions.add("-het");
        }
        if (line.hasOption(OPTION_HOMO)) {
            cmdoptions.add("-hom");
        }
        if (line.hasOption(OPTION_DELETIONS)) {
            cmdoptions.add("-del");
        }
        if (line.hasOption(OPTION_INSERTIONS)) {
            cmdoptions.add("-ins");
        }
        if (line.hasOption(OPTION_NODOWNSTREAM)) {
            cmdoptions.add(OPTION_DASH + OPTION_NODOWNSTREAM.replace("_", OPTION_DASH));
        }
        if (line.hasOption(OPTION_NOINTERGENIC)) {
            cmdoptions.add(OPTION_DASH + OPTION_NOINTERGENIC.replace("_", OPTION_DASH));
        }
        if (line.hasOption(OPTION_NOINTRON)) {
            cmdoptions.add(OPTION_DASH + OPTION_NOINTRON.replace("_", OPTION_DASH));
        }
        if (line.hasOption(OPTION_NOUPSTREAM)) {
            cmdoptions.add(OPTION_DASH + OPTION_NOUPSTREAM.replace("_", OPTION_DASH));
        }
        if (line.hasOption(OPTION_NOUTR)) {
            cmdoptions.add(OPTION_DASH + OPTION_NOUTR.replace("_", OPTION_DASH));
        }
        if (line.hasOption(OPTION_INTERVALFILE)) {
            cmdoptions.add("-interval");
            cmdoptions.add(line.getOptionValue(OPTION_INTERVALFILE));
        }
        if (line.hasOption(OPTION_MAXQ)) {
            cmdoptions.add("-maxQ");
            cmdoptions.add(line.getOptionValue(OPTION_MAXQ));
        }
        if (line.hasOption(OPTION_MINQ)) {
            cmdoptions.add("-minQ");
            cmdoptions.add(line.getOptionValue(OPTION_MINQ));
        }
        if (line.hasOption(OPTION_MAXC)) {
            cmdoptions.add("-maxC");
            cmdoptions.add(line.getOptionValue(OPTION_MAXC));
        }
        if (line.hasOption(OPTION_MINC)) {
            cmdoptions.add("-minC");
            cmdoptions.add(line.getOptionValue(OPTION_MINC));
        }
        if (line.hasOption('s')) {
            cmdoptions.add("-s");
            cmdoptions.add(line.getOptionValue('s'));
        }
        if (line.hasOption(OPTION_UPDOWNSTREAMLENGTH)) {
            cmdoptions.add("-ud");
            cmdoptions.add(line.getOptionValue(OPTION_UPDOWNSTREAMLENGTH));
        }
        if (line.hasOption(OPTION_ONLYCODING)) {
            cmdoptions.add("-onlyCoding");
            cmdoptions.add(line.getOptionValue(OPTION_ONLYCODING));
        }
        return cmdoptions.toArray(new String[cmdoptions.size()]);
    }
}

