/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.modify.ModifyJsonPipe;
import edu.mayo.pipes.history.History;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class ModifyTjsonCommand
implements CommandPlugin {
    private static final char OPTION_CONFIG_FILE = 'f';
    private static final char OPTION_JSON_COLUMN = 'c';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        int jsonCol = this.getDrillColumn(line);
        File configFile = this.getConfigFile(line);
        StringToHistoryPipe preLogic = new StringToHistoryPipe();
        ModifyJsonPipe logic = new ModifyJsonPipe(jsonCol, configFile);
        HistoryToStringPipe postLogic = new HistoryToStringPipe();
        this.mPipeline.execute(preLogic, logic, postLogic);
    }

    private Integer getDrillColumn(CommandLine line) {
        Integer col = -1;
        if (line.hasOption('c')) {
            col = new Integer(line.getOptionValue('c'));
        }
        return col;
    }

    private File getConfigFile(CommandLine line) {
        File configFile = null;
        if (line.hasOption('f')) {
            configFile = new File(line.getOptionValue('f'));
        }
        return configFile;
    }

    class HistoryToStringPipe
    extends AbstractPipe<History, String> {
        HistoryToStringPipe() {
        }

        protected String processNextStart() throws NoSuchElementException {
            History line = (History)this.starts.next();
            return line.getMergedData("\t");
        }
    }

    class StringToHistoryPipe
    extends AbstractPipe<String, History> {
        StringToHistoryPipe() {
        }

        protected History processNextStart() throws NoSuchElementException {
            String line = (String)this.starts.next();
            return new History(line.split("\t"));
        }
    }
}

