/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.MarkdownUtils;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogDiffStatistics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CatalogContentChangesImpl
implements MarkdownTransformer {
    static final String TEMPLATE_KEYWORD = "COMPARISON_STATISTICS_CONTENT_CHANGES_TABLE";
    private CatalogDiffStatistics stats;

    CatalogContentChangesImpl(CatalogDiffStatistics stats) {
        this.stats = stats;
    }

    @Override
    public String transform(String markdown) throws TransformException {
        if (this.stats == null) {
            return markdown.replace(TEMPLATE_KEYWORD, "Information is not available");
        }
        return markdown.replace(TEMPLATE_KEYWORD, MarkdownUtils.chompTrailingNewlines(this.buildTable()));
    }

    private String buildTable() {
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        Map<String, CatalogDiffStatistics.ColumnStats> columnStatsMap = this.indexByColumnName(this.stats.getColumnStats());
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.addAll(columnStatsMap.keySet());
        Collections.sort(columnNames);
        pWtr.println("ColumnName | Removed | Added | Changed | Datatype | Unchanged");
        pWtr.println("--- | --- | --- | --- | --- | ---");
        for (String columnName : columnNames) {
            CatalogDiffStatistics.ColumnStats columnStats = columnStatsMap.get(columnName);
            float TOTAL = columnStats.getRemoved() + columnStats.getAdded() + columnStats.getValueChanged() + columnStats.getDatatypeChanged() + columnStats.getValueUnchanged();
            pWtr.println(String.format("%s | %d (%.3f%%) | %d (%.3f%%) | %d (%.3f%%) | %d (%.3f%%) | %d (%.3f%%)", MarkdownUtils.escapeChrs(columnName), columnStats.getRemoved(), Float.valueOf((float)columnStats.getRemoved() / TOTAL * 100.0f), columnStats.getAdded(), Float.valueOf((float)columnStats.getAdded() / TOTAL * 100.0f), columnStats.getValueChanged(), Float.valueOf((float)columnStats.getValueChanged() / TOTAL * 100.0f), columnStats.getDatatypeChanged(), Float.valueOf((float)columnStats.getDatatypeChanged() / TOTAL * 100.0f), columnStats.getValueUnchanged(), Float.valueOf((float)columnStats.getValueUnchanged() / TOTAL * 100.0f)));
        }
        float TOTAL = this.stats.getSummaryStats().getCatalogColumnRemoved() + this.stats.getSummaryStats().getCatalogColumnAdded() + this.stats.getSummaryStats().getCatalogColumnValueChanged() + this.stats.getSummaryStats().getCatalogColumnDataTypeChange() + this.stats.getSummaryStats().getCatalogColumnValueUnchanged();
        pWtr.println(String.format("%s | %d (%.3f%%) | %d (%.3f%%) | %d (%.3f%%) | %d (%.3f%%) | %d (%.3f%%)", "TOTAL", this.stats.getSummaryStats().getCatalogColumnRemoved(), Float.valueOf((float)this.stats.getSummaryStats().getCatalogColumnRemoved() / TOTAL * 100.0f), this.stats.getSummaryStats().getCatalogColumnAdded(), Float.valueOf((float)this.stats.getSummaryStats().getCatalogColumnAdded() / TOTAL * 100.0f), this.stats.getSummaryStats().getCatalogColumnValueChanged(), Float.valueOf((float)this.stats.getSummaryStats().getCatalogColumnValueChanged() / TOTAL * 100.0f), this.stats.getSummaryStats().getCatalogColumnDataTypeChange(), Float.valueOf((float)this.stats.getSummaryStats().getCatalogColumnDataTypeChange() / TOTAL * 100.0f), this.stats.getSummaryStats().getCatalogColumnValueUnchanged(), Float.valueOf((float)this.stats.getSummaryStats().getCatalogColumnValueUnchanged() / TOTAL * 100.0f)));
        IOUtils.closeQuietly((Writer)pWtr);
        IOUtils.closeQuietly((Writer)sWtr);
        return sWtr.toString();
    }

    private Map<String, CatalogDiffStatistics.ColumnStats> indexByColumnName(CatalogDiffStatistics.ColumnStats[] arr) {
        HashMap<String, CatalogDiffStatistics.ColumnStats> map = new HashMap<String, CatalogDiffStatistics.ColumnStats>();
        for (CatalogDiffStatistics.ColumnStats columnStats : arr) {
            map.put(columnStats.getName(), columnStats);
        }
        return map;
    }
}

