/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildStepKey;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.pipeline.createcatalog.TjsonToCatalog;
import edu.mayo.bior.util.validation.CatalogFileValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CreateStep
implements BuildCatalogStepInterface {
    private static Logger sLogger = Logger.getLogger(CreateStep.class);
    private static final String STEP_DISPLAY_NAME = BuildStepKey.MAKE_CATALOG.getDisplayName();
    private static final String TAB = "\t";
    private BuildInfo mBuildInfo;
    private StepLogger mStepLogger;
    private String mTjsonInputFilePath = null;
    private String mOutputPath = null;
    private String mCatalogOutputBgzFilePath = null;
    private boolean mIsSortCatalogOnCreate = false;
    private String mChrSortOrderFilePath = null;
    private Integer mTjsonCol = -1;
    private String mTempDirPath = null;
    private boolean mIsInputFileAlreadyInFinalCtgFormatAndBgzipped = false;
    private String input_buildAssembly = null;
    private HumanBuildAssembly mBuildAssembly = null;
    private boolean mNormalizeInputChromosomes = false;

    public CreateStep(BuildInfo buildInfo, StepLogger stepLogger) {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = stepLogger;
        this.init(this.mBuildInfo);
    }

    @Override
    public void execute() throws BuildCatalogStepInputException, BuildCatalogStepExecuteException {
        this.mStepLogger.log(String.format("%s step: Checking inputs...", STEP_DISPLAY_NAME));
        this.checkInput();
        this.mStepLogger.logAndSummary(String.format("Creating catalog from JSON in last column of: '%s'", this.mTjsonInputFilePath));
        TjsonToCatalog tjsonToCatalog = new TjsonToCatalog();
        try {
            String tabixIndexFile;
            File createdCatalogIndex;
            tjsonToCatalog.createCatalog(this.mTjsonInputFilePath, this.mCatalogOutputBgzFilePath, this.mIsSortCatalogOnCreate, this.mChrSortOrderFilePath, this.mTjsonCol, this.mTjsonCol == 0, this.mTempDirPath, this.mBuildAssembly, this.mNormalizeInputChromosomes, this.mIsInputFileAlreadyInFinalCtgFormatAndBgzipped);
            File createdCatalog = new File(this.mCatalogOutputBgzFilePath);
            if (createdCatalog.exists()) {
                this.mStepLogger.logAndSummary("Catalog created: " + this.mCatalogOutputBgzFilePath);
            }
            if ((createdCatalogIndex = new File(tabixIndexFile = this.mCatalogOutputBgzFilePath + ".tbi")).exists()) {
                this.mStepLogger.logAndSummary("Tabix index created: " + tabixIndexFile);
            }
        }
        catch (Exception e) {
            this.mStepLogger.logAndSummary("Error while building catalog: " + e.getMessage());
            throw new BuildCatalogStepExecuteException(e);
        }
        this.mStepLogger.log("Create catalog step: checking outputs ... " + this.mTjsonInputFilePath);
        this.checkOutput();
    }

    public String getLog() throws Exception {
        return null;
    }

    private void init(BuildInfo buildInfo) {
        this.mTjsonInputFilePath = buildInfo.getMakeJsonOutputFilePath();
        this.mOutputPath = buildInfo.getTargetDirectory();
        this.mTjsonCol = buildInfo.getinputJSONColumnNum();
        this.mIsSortCatalogOnCreate = buildInfo.getSortCatalogOnCreate();
        this.mChrSortOrderFilePath = buildInfo.getChromosomeSortOrderFileName();
        this.mTempDirPath = buildInfo.getBaseTempDirectory();
        this.mStepLogger.log("CreateStep.init(): TEMP_DIR value: " + this.mTempDirPath);
        String input_buildAssembly = buildInfo.getDataSourceBuild();
        if (input_buildAssembly != null && input_buildAssembly.startsWith(HumanBuildAssembly.GRCh37.name())) {
            this.mBuildAssembly = HumanBuildAssembly.GRCh37;
        } else if (input_buildAssembly != null && input_buildAssembly.startsWith(HumanBuildAssembly.GRCh38.name())) {
            this.mBuildAssembly = HumanBuildAssembly.GRCh38;
        }
        this.mNormalizeInputChromosomes = true;
        this.mIsInputFileAlreadyInFinalCtgFormatAndBgzipped = buildInfo.getInFinalFormat();
    }

    private void checkInput() throws BuildCatalogStepInputException {
        try {
            File tempdir;
            this.mStepLogger.log("CreateStep.checkInput(): Creating TEMP_DIR value: " + this.mTempDirPath);
            if (this.mTempDirPath != null && !(tempdir = new File(this.mTempDirPath)).exists()) {
                this.mStepLogger.log("CreateStep.checkInput(): Creating TEMP_DIR value: " + this.mTempDirPath);
                tempdir.mkdirs();
            }
        }
        catch (Exception io) {
            throw new BuildCatalogStepInputException("CreateStep.checkInput(): Failed creating specified TEMP_DIR value: " + this.mTempDirPath);
        }
        try {
            File inputTjsonFile = null;
            if (this.mTjsonInputFilePath == null) {
                throw new BuildCatalogStepInputException("CreateStep.checkInput(): Input TJSON file value is null.");
            }
            if (this.mTjsonInputFilePath.length() == 0) {
                throw new BuildCatalogStepInputException("CreateStep.checkInput(): Input TJSON file value is an empty string.");
            }
            inputTjsonFile = new File(this.mTjsonInputFilePath);
            if (!inputTjsonFile.canRead()) {
                throw new BuildCatalogStepInputException(String.format("CreateStep.checkInput(): Input TJSON file '%s' does not exist or cannot be read.", this.mTjsonInputFilePath));
            }
            this.verifyTJSON(inputTjsonFile);
        }
        catch (Exception e) {
            throw new BuildCatalogStepInputException("CreateStep.checkInput(): Exception raised checking input: " + e.getMessage());
        }
        try {
            File outDir;
            if (this.mOutputPath == null || this.mOutputPath.length() <= 0) {
                this.mOutputPath = new File(".").getCanonicalPath();
                System.err.println("No output directory specified.  Defaulting to the current directory: " + this.mOutputPath);
            }
            if (!(outDir = new File(this.mOutputPath)).isDirectory()) {
                throw new BuildCatalogStepInputException("Output directory specified [" + this.mOutputPath + "] does not exist or is not a directory. Please create the directory, check the build info TARGET_DIR property, and retry.");
            }
            if (!outDir.canWrite()) {
                throw new BuildCatalogStepInputException("Output directory specified [" + this.mOutputPath + "] is not writable. Please modify the permissions on this directory and retry.");
            }
        }
        catch (IOException io) {
            throw new BuildCatalogStepInputException("IO Exception raised while checking output path specified. Exception: " + io.getMessage());
        }
        try {
            this.mCatalogOutputBgzFilePath = this.mOutputPath + "/" + this.mBuildInfo.getCatalogPrefix() + ".tsv.bgz";
            this.mStepLogger.log("Catalog file path we will be creating: " + new File(this.mCatalogOutputBgzFilePath).getCanonicalPath());
        }
        catch (IOException io) {
            throw new BuildCatalogStepInputException("CreateStep.init(): Failed getting path for catalog to create.");
        }
        File outputCatFile = new File(this.mCatalogOutputBgzFilePath);
        if (!CatalogFileValidator.hasExpectedSuffix(this.mCatalogOutputBgzFilePath)) {
            throw new BuildCatalogStepInputException("CreateStep.checkInput(): Catalog file is not a valid file. Does not have expected catalog file name suffix.");
        }
        if (outputCatFile.exists()) {
            if (outputCatFile.canWrite()) {
                this.mStepLogger.log("WARNING: CreateStep.checkInput(): Output catalog file specified already exists. It will be overwritten.");
            } else {
                throw new BuildCatalogStepInputException("ERROR: CreateStep.checkInput(): Output catalog file specified already exists. It is not writable so cannot be overwritten.");
            }
        }
    }

    private void checkOutput() throws BuildCatalogStepExecuteException {
        if (!CatalogFileValidator.catalogExists(this.mCatalogOutputBgzFilePath)) {
            throw new BuildCatalogStepExecuteException("CreateStep.checkOutput(): Output catalog file is not a valid file. Please check catalog-build create-catalog step results.");
        }
        if (!CatalogFileValidator.hasExpectedSuffix(this.mCatalogOutputBgzFilePath)) {
            throw new BuildCatalogStepExecuteException("CreateStep.checkOutput(): Output catalog file is not a valid file [" + this.mCatalogOutputBgzFilePath + "]. Does not have expected file suffix of [" + ".tsv.bgz" + "].");
        }
        try {
            sLogger.info((Object)("Generated output catalog: " + new File(this.mCatalogOutputBgzFilePath).getCanonicalPath()));
        }
        catch (IOException io) {
            throw new BuildCatalogStepExecuteException("Unable to report canonical path of catalog output file for value: " + this.mCatalogOutputBgzFilePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyTJSON(File tjsonInFile) throws BuildCatalogStepInputException {
        BufferedReader rdr = null;
        try {
            rdr = TjsonToCatalog.getBufferedReader(tjsonInFile);
            String ln = null;
            Integer previousLineElemSize = null;
            while ((ln = rdr.readLine()) != null) {
                if (ln.startsWith("#") || ln.trim().length() == 0) continue;
                String[] lineElements = ln.split(TAB);
                if (lineElements == null) {
                    System.err.println("WARNING: CreateStep.verifyTJSON(): Please check input TJSON file. The current line had a null tab-delimited element list so skipping it: " + ln);
                    continue;
                }
                if (this.mTjsonCol != -1) {
                    if (this.mTjsonCol - 1 >= lineElements.length) {
                        rdr.close();
                        throw new BuildCatalogStepInputException("User-specified JSON input column number [" + this.mTjsonCol + "] in TJSON input file is not a valid column number. Column number should be the one-based column number of the JSON column that should be used to build the catalog.");
                    }
                    if (!this.isTJsonString(lineElements[this.mTjsonCol - 1])) {
                        rdr.close();
                        throw new BuildCatalogStepInputException("User-specified JSON input column number [" + this.mTjsonCol + "] in TJSON input file is not a JSON column. Column number should be the one-based column number of the JSON column that should be used to build the catalog. Column element is not JSON: [" + lineElements[this.mTjsonCol - 1] + "]");
                    }
                } else if (this.mTjsonCol == -1 && !this.isTJsonString(lineElements[lineElements.length - 1])) {
                    rdr.close();
                    throw new BuildCatalogStepInputException("There is no user-specified JSON input column number for TJSON input file but last column in the input is not a JSON string. Column element is not JSON: [" + lineElements[lineElements.length - 1] + "]");
                }
                if (lineElements.length >= 1) {
                    if (previousLineElemSize == null) {
                        previousLineElemSize = lineElements.length;
                        continue;
                    }
                    if (previousLineElemSize != lineElements.length) {
                        rdr.close();
                        throw new BuildCatalogStepInputException("Input TJSON file has inconsistent number of elements between previous line [" + previousLineElemSize + "] and current line [" + lineElements.length + "].  current line content: " + ln);
                    }
                    previousLineElemSize = lineElements.length;
                    continue;
                }
                System.err.println("Skipping input line with white space: [" + ln + "].");
            }
            return;
        }
        catch (Exception e) {
            throw new BuildCatalogStepInputException("Exception occurred while verifying TJSON input file. Exception: " + e.getMessage());
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isTJsonString(String s) {
        return s.startsWith("{") && s.endsWith("}");
    }
}

