/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesIntervalSeqChange
extends TestCase {
    boolean debug = false;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    char[] chromoBases;

    public TestCasesIntervalSeqChange() {
        this.init();
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20120426L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, maxGeneLen, maxTranscripts, maxExons);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    public void test_01() {
        int N = 1000;
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("INTERVAL (seqChange) Test iteration: " + i + "\n" + this.transcript);
            } else {
                System.out.println("INTERVAL (seqChange) Test iteration: " + i);
            }
            for (int pos = 0; pos < this.chromosome.size(); ++pos) {
                int intLen = this.rand.nextInt(100) + 1;
                int start = pos;
                int end = Math.min(pos + intLen, this.chromosome.getEnd());
                SeqChange seqChange = new SeqChange(this.chromosome, start, end, "");
                Assert.assertEquals((boolean)true, (boolean)seqChange.isInterval());
                String expectedEffect = null;
                if (this.transcript.intersects(seqChange)) {
                    for (Exon ex : this.transcript) {
                        if (!ex.intersects(seqChange)) continue;
                        expectedEffect = "EXON";
                    }
                    for (Intron intron : this.transcript.introns()) {
                        if (!intron.intersects(seqChange)) continue;
                        expectedEffect = "INTRON";
                    }
                    if (expectedEffect == null) {
                        expectedEffect = "INTRAGENIC";
                    }
                } else {
                    expectedEffect = "INTERGENIC";
                }
                List<ChangeEffect> effectsAll = this.snpEffectPredictor.seqChangeEffect(seqChange);
                ArrayList<ChangeEffect> effects = new ArrayList<ChangeEffect>();
                for (ChangeEffect eff : effectsAll) {
                    boolean copy = true;
                    if (eff.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR) {
                        copy = false;
                    }
                    if (eff.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_DONOR) {
                        copy = false;
                    }
                    if (!copy) continue;
                    effects.add(eff);
                }
                Assert.assertEquals((boolean)false, (boolean)effects.isEmpty());
                if (this.debug && effects.size() > 1) {
                    System.out.println("Found more than one effect: " + effects.size() + "\n" + this.transcript);
                    for (ChangeEffect eff : effects) {
                        System.out.println("\t" + eff);
                    }
                }
                boolean isExpectedOK = false;
                StringBuilder effSb = new StringBuilder();
                for (ChangeEffect effect : effects) {
                    String effstr = effect.effect(true, true, true);
                    isExpectedOK |= effstr.equals(expectedEffect);
                    effSb.append(effstr + " ");
                }
                if (this.debug) {
                    System.out.println("SeqChange: " + seqChange + "\nExpected Effect :\t" + expectedEffect + "\nEffects         :\t" + effSb + "\n--------------------------------------------------------------\n");
                }
                Assert.assertEquals((boolean)true, (boolean)isExpectedOK);
            }
        }
    }
}

