/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.genBank.Feature;
import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.genBank.FeaturesFile;
import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public abstract class SnpEffPredictorFactoryFeatures
extends SnpEffPredictorFactory {
    public static boolean debug = false;
    public static final int OFFSET = 1;
    Chromosome chromosome;
    FeaturesFile featuresFile;

    public SnpEffPredictorFactoryFeatures(Config config) {
        super(config, 1);
    }

    protected void addFeatures(Features features) {
        String trId;
        int end;
        int start;
        for (Feature f : features.getFeatures()) {
            start = f.getStart() - this.inOffset;
            end = f.getEnd() - this.inOffset;
            if (f.getType() != Feature.Type.SOURCE) continue;
            if (this.chromosome != null) {
                throw new RuntimeException("SOURCE already assigned to chromosome");
            }
            String chrName = this.chromoName(features, f);
            this.chromosome = new Chromosome(this.genome, start, end, 1, chrName);
            this.add(this.chromosome);
        }
        if (this.chromosome == null) {
            String chrName = this.chromoName(features, null);
            int chrSize = this.sequence(features).length();
            this.chromosome = new Chromosome(this.genome, 0, chrSize, 1, chrName);
            this.add(this.chromosome);
        }
        if (this.chromosome == null) {
            throw new RuntimeException("Could not find SOURCE feature");
        }
        if (this.verbose) {
            System.err.println("Chromosome: '" + this.chromosome.getId() + "'\tlength: " + this.chromosome.size());
        }
        for (Feature f : features.getFeatures()) {
            if (f.getType() != Feature.Type.GENE) continue;
            this.findOrCreateGene(f, this.chromosome, false);
        }
        for (Feature f : features.getFeatures()) {
            if (f.getType() != Feature.Type.MRNA) continue;
            start = f.getStart() - this.inOffset;
            end = f.getEnd() - this.inOffset;
            trId = this.getTrId(f);
            Gene gene = this.findOrCreateGene(f, this.chromosome, false);
            Transcript tr = new Transcript(gene, start, end, f.isComplement() ? -1 : 1, trId);
            this.add(tr);
        }
        for (Feature f : features.getFeatures()) {
            if (f.getType() != Feature.Type.CDS) continue;
            start = f.getStart() - this.inOffset;
            end = f.getEnd() - this.inOffset;
            trId = this.getTrId(f);
            Transcript tr = this.findTranscript(trId);
            if (tr == null) {
                Gene gene = this.findOrCreateGene(f, this.chromosome, false);
                if (debug) {
                    System.err.println("Transcript '" + trId + "' not found. Creating new transcript for gene '" + gene.getId() + "'.\n" + f);
                }
                if ((tr = this.findTranscript(trId)) == null) {
                    tr = new Transcript(gene, start, end, f.isComplement() ? -1 : 1, trId);
                    this.add(tr);
                }
            }
            if (f.get("translation") != null) {
                tr.setProteinCoding(true);
            }
            Cds cds = new Cds(tr, f.getStart() - this.inOffset, f.getEnd() - this.inOffset, f.isComplement() ? -1 : 1, "CDS_" + trId);
            this.add(cds);
        }
    }

    String chromoName(Features features, Feature sourceFeature) {
        String chrName;
        if (sourceFeature != null) {
            if (sourceFeature.getType() != Feature.Type.SOURCE) {
                throw new RuntimeException("Cannot find chromosome name in a non-SOURCE feature");
            }
            chrName = sourceFeature.get("chromosome");
            if (chrName != null) {
                return chrName;
            }
        }
        if ((chrName = features.getLocusName()) != null) {
            return chrName;
        }
        return this.genome.getId();
    }

    @Override
    public SnpEffectPredictor create() {
        System.out.println("Config: " + this.config.getGenome());
        try {
            for (Features features : this.featuresFile) {
                this.chromosome = null;
                this.addFeatures(features);
                this.beforeExonSequences();
                String sequence = this.sequence(features);
                this.addExonSequences(this.chromosome.getId(), sequence);
            }
            this.finishUp(false);
            System.out.println(this.config.getGenome());
            boolean error = this.config.getGenome().isMostExonsHaveSequence();
            if (error) {
                throw new RuntimeException("Most Exons do not have sequences!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    Gene findOrCreateGene(Feature f, Chromosome chr, boolean warn) {
        int start = f.getStart() - this.inOffset;
        int end = f.getEnd() - this.inOffset;
        String geneId = this.geneId(f, start, end);
        String geneName = this.geneName(f, start, end);
        Gene gene = this.findGene(geneId);
        if (gene == null) {
            gene = new Gene(chr, start, end, f.isComplement() ? -1 : 1, geneId, geneName, "");
            this.add(gene);
            if (debug) {
                System.err.println("WARNING: Gene '" + geneId + "' not found: created.");
            }
        }
        return gene;
    }

    protected String geneId(Feature f, int start, int end) {
        String geneId = f.get("locus_tag");
        if (geneId != null) {
            return geneId;
        }
        geneId = f.get("gene");
        if (geneId != null) {
            return geneId;
        }
        geneId = f.get("db_xref");
        if (geneId != null) {
            return geneId;
        }
        return "Gene_" + start + "_" + end;
    }

    protected String geneName(Feature f, int start, int end) {
        String geneName = f.get("gene");
        if (geneName != null) {
            return geneName;
        }
        geneName = f.get("locus_tag");
        if (geneName != null) {
            return geneName;
        }
        return "Gene_" + start + "_" + end;
    }

    protected String getTrId(Feature f) {
        String trId = f.get("locus_tag");
        if (trId != null) {
            return trId;
        }
        trId = f.get("gene");
        if (trId != null) {
            return "Tr_" + trId;
        }
        trId = f.get("product");
        if (trId != null) {
            trId = trId.replaceAll("\\s", "_");
        }
        return trId;
    }

    String sequence(Features features) {
        String seq = features.getSequence();
        if (seq != null && !seq.isEmpty()) {
            return seq;
        }
        if (this.verbose) {
            System.out.println("No sequence found in feature file.");
        }
        for (String fastaFile : this.config.getFileListGenomeFasta()) {
            if (this.verbose) {
                System.out.println("\tTrying fasta file '" + fastaFile + "'");
            }
            if (!Gpr.canRead(fastaFile) || (seq = GprSeq.fastaSimpleRead(fastaFile)) == null || seq.isEmpty()) continue;
            return seq;
        }
        throw new RuntimeException("Cannot find sequence for '" + this.config.getGenome().getVersion() + "'");
    }
}

