/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import java.util.List;

public class Utr3prime
extends Utr {
    private static final long serialVersionUID = 5688641008301281991L;

    protected Utr3prime() {
        this.type = ChangeEffect.EffectType.UTR_3_PRIME;
    }

    public Utr3prime(Exon parent, int start, int end, int strand, String id) {
        super(parent, start, end, strand, id);
        this.type = ChangeEffect.EffectType.UTR_3_PRIME;
    }

    @Override
    public boolean isUtr3prime() {
        return true;
    }

    @Override
    public boolean isUtr5prime() {
        return false;
    }

    @Override
    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        if (seqChange.includes(this) && seqChange.getChangeType() == SeqChange.ChangeType.DEL) {
            changeEffect.set(this, ChangeEffect.EffectType.UTR_3_DELETED, "");
            return changeEffect.newList();
        }
        Transcript tint = (Transcript)this.findParent(Transcript.class);
        String utrDistStr = this.utrDistance(seqChange, tint);
        changeEffect.set(this, this.type, utrDistStr);
        Exon exon = (Exon)this.findParent(Exon.class);
        if (exon != null) {
            exon.check(seqChange, changeEffect);
        }
        return changeEffect.newList();
    }

    @Override
    String utrDistance(SeqChange snp, Transcript tint) {
        List<Utr3prime> utrs = tint.get3primeUtrs();
        boolean fromEnd = this.strand < 0;
        int dist = snp.distanceFrom(utrs, fromEnd) + 1;
        return dist + " bases from CDS";
    }
}

