/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class GenBank
extends Features {
    public static final int FEATURE_NAME_FIELD_LEN = 20;

    public GenBank(LineFileIterator lineFileIterator) {
        super(lineFileIterator);
    }

    public GenBank(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean isNewFeature(String line) {
        return !line.substring(0, 20).trim().isEmpty();
    }

    protected void parseFieldLine(String name, String valueOri, int fieldLineNum) {
        String value = valueOri.trim();
        if (name.equals("LOCUS")) {
            String[] subfields = value.split(" ");
            this.locusName = subfields[0];
            if (subfields.length > 1) {
                this.sequenceLength = Gpr.parseIntSafe(subfields[1]);
            }
            if (subfields.length > 2) {
                this.moleculeType = subfields[2];
            }
            if (subfields.length > 3) {
                this.shape = subfields[3];
            }
            if (subfields.length > 4) {
                this.division = subfields[4];
            }
            if (subfields.length > 5) {
                this.date = subfields[5];
            }
        } else if (name.equals("DEFINITION")) {
            this.definition = this.definition + value;
        } else if (name.equals("ACCESSION")) {
            this.accession = this.accession + value;
        } else if (name.equals("VERSION")) {
            this.version = this.version + value;
        } else if (name.equals("KEYWORDS")) {
            this.keywords = this.keywords + value;
        } else if (name.equals("SOURCE")) {
            this.source = this.source + value;
        } else if (name.equals("REFERENCE")) {
            if (fieldLineNum == 0) {
                this.references.add(new StringBuffer());
            }
            ((StringBuffer)this.references.get(this.references.size() - 1)).append(value + "\n");
        } else if (name.equals("FEATURES")) {
            if (fieldLineNum > 0) {
                this.featuresStr.append(valueOri + "\n");
            }
        } else if (name.equals("ORIGIN")) {
            String[] seq = value.split(" ", 2);
            if (seq.length > 1) {
                String s = seq[1].replaceAll("\\s", "");
                this.sequence.append(s);
            }
        } else {
            System.err.println("Ignored feature '" + name + "'");
        }
    }

    @Override
    public void readFile() {
        int fieldLineNum = 0;
        String name = null;
        String value = "";
        for (String line : this.lineFileIterator) {
            String[] kv;
            if (line.equals("//")) break;
            value = line;
            if (!line.startsWith(" ") && (kv = line.split(" ", 2)).length > 1) {
                name = kv[0];
                value = kv[1];
                fieldLineNum = 0;
            }
            this.parseFieldLine(name, value, fieldLineNum);
            ++fieldLineNum;
        }
        this.parseFeatures();
    }
}

