/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.utils;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;

public class SAMSequenceDictionaryExtractor {
    public static SAMSequenceDictionary extractDictionary(File file) {
        return TYPE.forFile(file).extractDictionary(file);
    }

    static enum TYPE {
        FASTA(ReferenceSequenceFileFactory.FASTA_EXTENSIONS){

            @Override
            SAMSequenceDictionary extractDictionary(File file) {
                SAMSequenceDictionary sAMSequenceDictionary = ReferenceSequenceFileFactory.getReferenceSequenceFile(file).getSequenceDictionary();
                if (sAMSequenceDictionary == null) {
                    throw new SAMException("Could not find dictionary next to reference file " + file.getAbsoluteFile());
                }
                return sAMSequenceDictionary;
            }
        }
        ,
        DICTIONARY(new String[]{".dict"}){

            @Override
            SAMSequenceDictionary extractDictionary(File file) {
                SAMSequenceDictionary sAMSequenceDictionary;
                BufferedLineReader bufferedLineReader = null;
                try {
                    bufferedLineReader = new BufferedLineReader(new FileInputStream(file));
                    SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
                    SAMFileHeader sAMFileHeader = sAMTextHeaderCodec.decode(bufferedLineReader, file.toString());
                    sAMSequenceDictionary = sAMFileHeader.getSequenceDictionary();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        throw new SAMException("Could not open sequence dictionary file: " + file, fileNotFoundException);
                    }
                    catch (Throwable throwable) {
                        CloserUtil.close(bufferedLineReader);
                        throw throwable;
                    }
                }
                CloserUtil.close(bufferedLineReader);
                return sAMSequenceDictionary;
            }
        }
        ,
        SAM(new String[]{".sam", ".bam"}){

            @Override
            SAMSequenceDictionary extractDictionary(File file) {
                return SamReaderFactory.makeDefault().getFileHeader(file).getSequenceDictionary();
            }
        }
        ,
        VCF(IOUtil.VCF_EXTENSIONS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            SAMSequenceDictionary extractDictionary(File file) {
                SAMSequenceDictionary sAMSequenceDictionary;
                VCFFileReader vCFFileReader = null;
                try {
                    vCFFileReader = new VCFFileReader(file, false);
                    sAMSequenceDictionary = vCFFileReader.getFileHeader().getSequenceDictionary();
                }
                catch (Throwable throwable) {
                    CloserUtil.close(vCFFileReader);
                    throw throwable;
                }
                CloserUtil.close(vCFFileReader);
                return sAMSequenceDictionary;
            }
        }
        ,
        INTERVAL_LIST(new String[]{".interval_list"}){

            @Override
            SAMSequenceDictionary extractDictionary(File file) {
                return IntervalList.fromFile(file).getHeader().getSequenceDictionary();
            }
        };

        final Collection<String> applicableExtensions;

        private TYPE(String ... stringArray) {
            this.applicableExtensions = CollectionUtil.makeSet(stringArray);
        }

        private TYPE(Collection<String> collection) {
            this.applicableExtensions = collection;
        }

        abstract SAMSequenceDictionary extractDictionary(File var1);

        static TYPE forFile(File file) {
            for (TYPE tYPE : TYPE.values()) {
                for (String string : tYPE.applicableExtensions) {
                    if (!file.getName().endsWith(string)) continue;
                    return tYPE;
                }
            }
            throw new SAMException("Cannot figure out type of file " + file.getAbsolutePath() + " from extension. Current implementation understands the following types: " + Arrays.toString((Object[])TYPE.values()));
        }

        public String toString() {
            return super.toString() + ": " + this.applicableExtensions.toString();
        }
    }
}

