/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.bed;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.tribble.bed.FullBEDFeature;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.util.ParsingUtils;
import java.util.regex.Pattern;

public class BEDCodec
extends AsciiFeatureCodec<BEDFeature> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\t|( +)");
    private final int startOffsetValue;

    public BEDCodec() {
        this(StartOffset.ONE);
    }

    public BEDCodec(StartOffset startOffset) {
        super(BEDFeature.class);
        this.startOffsetValue = startOffset.value();
    }

    public BEDFeature decodeLoc(String string) {
        return this.decode(string);
    }

    @Override
    public BEDFeature decode(String string) {
        if (string.trim().length() == 0) {
            return null;
        }
        if (string.startsWith("#") || string.startsWith("track") || string.startsWith("browser")) {
            this.readHeaderLine(string);
            return null;
        }
        String[] stringArray = SPLIT_PATTERN.split(string, -1);
        return this.decode(stringArray);
    }

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        return null;
    }

    @Override
    public BEDFeature decode(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        if (n2 < 2) {
            return null;
        }
        String string2 = stringArray[0];
        int n3 = n = Integer.parseInt(stringArray[1]) + this.startOffsetValue;
        if (n2 > 2) {
            n3 = Integer.parseInt(stringArray[2]);
        }
        FullBEDFeature fullBEDFeature = new FullBEDFeature(string2, n, n3);
        if (n2 > 3) {
            string = stringArray[3].replaceAll("\"", "");
            fullBEDFeature.setName(string);
        }
        if (n2 > 4) {
            try {
                float f = Float.parseFloat(stringArray[4]);
                fullBEDFeature.setScore(f);
            }
            catch (NumberFormatException numberFormatException) {
                return fullBEDFeature;
            }
        }
        if (n2 > 5) {
            int n4;
            string = stringArray[5].trim();
            int n5 = n4 = string.length() == 0 ? 32 : (int)string.charAt(0);
            if (n4 == 45) {
                fullBEDFeature.setStrand(Strand.NEGATIVE);
            } else if (n4 == 43) {
                fullBEDFeature.setStrand(Strand.POSITIVE);
            } else {
                fullBEDFeature.setStrand(Strand.NONE);
            }
        }
        if (n2 > 8) {
            string = stringArray[8];
            fullBEDFeature.setColor(ParsingUtils.parseColor(string));
        }
        if (n2 > 11) {
            this.createExons(n, stringArray, fullBEDFeature, fullBEDFeature.getStrand());
        }
        return fullBEDFeature;
    }

    protected boolean readHeaderLine(String string) {
        return false;
    }

    private void createExons(int n, String[] stringArray, FullBEDFeature fullBEDFeature, Strand strand) throws NumberFormatException {
        int n2;
        int n3 = Integer.parseInt(stringArray[6]) + this.startOffsetValue;
        int n4 = Integer.parseInt(stringArray[7]);
        int n5 = Integer.parseInt(stringArray[9]);
        String[] stringArray2 = new String[n5];
        String[] stringArray3 = new String[n5];
        ParsingUtils.split(stringArray[10], stringArray2, ',');
        ParsingUtils.split(stringArray[11], stringArray3, ',');
        int n6 = n2 = strand == Strand.NEGATIVE ? n5 : 1;
        if (stringArray3.length == stringArray2.length) {
            for (int i = 0; i < stringArray3.length; ++i) {
                int n7 = n + Integer.parseInt(stringArray3[i]);
                int n8 = n7 + Integer.parseInt(stringArray2[i]) - 1;
                fullBEDFeature.addExon(n7, n8, n3, n4, n2);
                if (strand == Strand.NEGATIVE) {
                    --n2;
                    continue;
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean canDecode(String string) {
        return string.toLowerCase().endsWith(".bed");
    }

    public int getStartOffset() {
        return this.startOffsetValue;
    }

    public static enum StartOffset {
        ZERO(0),
        ONE(1);

        private int start;

        private StartOffset(int n2) {
            this.start = n2;
        }

        public int value() {
            return this.start;
        }
    }
}

