/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;

abstract class AbstractFastaSequenceFile
implements ReferenceSequenceFile {
    protected final File file;
    protected SAMSequenceDictionary sequenceDictionary;

    AbstractFastaSequenceFile(File file) {
        this.file = file;
        File file2 = AbstractFastaSequenceFile.findSequenceDictionary(file);
        if (file2 != null) {
            IOUtil.assertFileIsReadable(file2);
            try {
                SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
                BufferedLineReader bufferedLineReader = new BufferedLineReader(new FileInputStream(file2));
                SAMFileHeader sAMFileHeader = sAMTextHeaderCodec.decode(bufferedLineReader, file2.toString());
                if (sAMFileHeader.getSequenceDictionary() != null && sAMFileHeader.getSequenceDictionary().size() > 0) {
                    this.sequenceDictionary = sAMFileHeader.getSequenceDictionary();
                }
                bufferedLineReader.close();
            }
            catch (Exception exception) {
                throw new SAMException("Could not open sequence dictionary file: " + file2, exception);
            }
        }
    }

    protected static File findSequenceDictionary(File file) {
        String string = file.getAbsolutePath();
        String string2 = file.getAbsolutePath();
        boolean bl = false;
        for (String object2 : ReferenceSequenceFileFactory.FASTA_EXTENSIONS) {
            if (!string.endsWith(object2)) continue;
            string2 = new String(string);
            string2 = string2 + ".dict";
            string = string.substring(0, string.lastIndexOf(object2));
            string = string + ".dict";
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("File is not a supported reference file type: " + file.getAbsolutePath());
        }
        File file2 = new File(string);
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(string2);
        if (file3.exists()) {
            return file3;
        }
        return null;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public ReferenceSequence getSequence(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String string, long l, long l2) {
        throw new UnsupportedOperationException("Index does not appear to exist for" + this.file.getAbsolutePath() + ".  samtools faidx can be used to create an index");
    }
}

