/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli;

import com.google.gson.JsonSyntaxException;
import edu.mayo.cli.ArgumentDefinition;
import edu.mayo.cli.CLIInitialization;
import edu.mayo.cli.CLILogHandler;
import edu.mayo.cli.CLIUsageHandler;
import edu.mayo.cli.InvalidNumberOfArgsException;
import edu.mayo.cli.util.CLIConstants;
import edu.mayo.cli.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class CLIErrorHandler {
    private static Logger sLogger = Logger.getLogger(CLIInitialization.class);
    private static final String MISSING_REQUIRED_OPTION_OG = "Missing a required option. One and only one of the following options must be specified:";
    private static final String TOO_MANY_REQUIRED_OPTIONS_OG = "2 or more of the following options have been found. One and only one of the can be specified:";
    private CLIInitialization initialization;
    private CLILogHandler logHandler;
    String scriptName;
    String[] cmdArgs;
    Options opts;
    List<ArgumentDefinition> argDefs;
    String synopsis;
    private static String EOL = "\n";

    public CLIErrorHandler(CLIInitialization initialization, CLILogHandler logHandler, CLIUsageHandler usageHandler) throws IOException {
        this.initialization = initialization;
        this.logHandler = logHandler;
        this.scriptName = initialization.getScriptName();
        this.cmdArgs = initialization.getCmdArgs();
        this.opts = initialization.getOptions();
        this.argDefs = initialization.getArgumentDefinitions();
        this.synopsis = usageHandler.getSynopsisText();
    }

    public void processError(Throwable t) throws IOException {
        if (t instanceof JsonSyntaxException) {
            this.jasonErrorHandler((JsonSyntaxException)t);
            return;
        }
        if (t instanceof MissingOptionException) {
            this.missingOptionExceptionHandler((MissingOptionException)t);
        } else if (t instanceof AlreadySelectedException) {
            this.alreadySelectedExceptionHandler((AlreadySelectedException)t);
        } else if (t instanceof ParseException) {
            this.parseExceptionHandler((ParseException)t);
        } else if (t instanceof InvalidNumberOfArgsException) {
            this.invalidNumberOfArgsExceptionHandler((InvalidNumberOfArgsException)t);
        } else if (t instanceof RuntimeException) {
            this.runtimeExceptionHandler((RuntimeException)t);
        } else if (t instanceof Exception) {
            this.exceptionHandler((Exception)t);
        } else {
            this.throwableHandler(t);
        }
    }

    private String getMissingOptionGroupText(OptionGroup og, String message) throws IOException {
        Collection options = og.getOptions();
        String txt = message + EOL;
        for (Option opt : options) {
            txt = txt + this.getMissingOptionText(opt);
        }
        return txt;
    }

    private String getMissingOptionText(Option opt) throws IOException {
        String optStr = "-" + opt.getOpt() + ", --" + opt.getLongOpt();
        if (opt.hasArg()) {
            optStr = optStr + " <" + opt.getArgName() + ">";
        }
        String txt = StringUtils.indent(optStr, 1) + EOL + StringUtils.indent(StringUtils.wrap(opt.getDescription(), 94), 2) + EOL;
        return txt;
    }

    private void jasonErrorHandler(JsonSyntaxException je) {
        System.err.println("Error in command properties file.");
        je.printStackTrace(System.err);
    }

    private void missingOptionExceptionHandler(MissingOptionException moe) throws IOException {
        System.err.println("Usage: " + this.synopsis);
        System.err.println();
        System.err.println("The command requires the following options:");
        System.err.println();
        TreeMap<String, String> sortedShortflagToTextMap = new TreeMap<String, String>();
        List missingOptions = moe.getMissingOptions();
        for (Object missingOption : missingOptions) {
            if (missingOption instanceof OptionGroup) {
                ArrayList optionsInGroup = new ArrayList(((OptionGroup)missingOption).getOptions());
                Collections.sort(optionsInGroup, CLIUsageHandler.mShortOptionComparator);
                String firstShortOptionInGroup = ((Option)optionsInGroup.get(0)).getOpt();
                String missingOptionText = this.getMissingOptionGroupText((OptionGroup)missingOption, MISSING_REQUIRED_OPTION_OG);
                sortedShortflagToTextMap.put(firstShortOptionInGroup, missingOptionText);
                continue;
            }
            String shortOptionName = (String)missingOption;
            String missingOptionText = this.getMissingOptionText(this.opts.getOption(shortOptionName));
            sortedShortflagToTextMap.put(shortOptionName, missingOptionText);
        }
        for (String key : sortedShortflagToTextMap.keySet()) {
            System.err.println((String)sortedShortflagToTextMap.get(key));
        }
        System.err.println("Execute the command with -h or --help to find out more information.");
        System.err.println();
    }

    private void alreadySelectedExceptionHandler(AlreadySelectedException e) throws IOException {
        OptionGroup og = e.getOptionGroup();
        System.err.println(this.getMissingOptionGroupText(og, TOO_MANY_REQUIRED_OPTIONS_OG));
    }

    private void parseExceptionHandler(ParseException pe) {
        System.err.println("Usage: " + this.synopsis);
        System.err.println(pe.getMessage());
        System.err.println();
        System.err.println("Execute the command with -h or --help to find out more information.");
        System.err.println();
    }

    private void invalidNumberOfArgsExceptionHandler(InvalidNumberOfArgsException inae) {
        if (inae.getActualArgs() == null) {
            System.err.println("Usage: " + this.synopsis);
            System.err.println();
            System.err.println(inae.getMessage());
            System.err.println();
            System.err.println("Execute the command with -h or --help to find out more information.");
            System.err.println();
        } else {
            System.err.println("Usage: " + this.synopsis);
            System.err.println();
            System.err.println("Invalid number of argument values specified.");
            System.err.println();
            System.err.println("Arguments that are required:");
            for (ArgumentDefinition argDef : this.argDefs) {
                System.err.println("\t" + argDef.getName());
            }
            System.err.println();
            System.err.println("Arguments specified by user:");
            for (String actualArg : inae.getActualArgs()) {
                System.err.println("\t" + actualArg);
            }
            System.err.println();
            System.err.println("Execute the command with -h or --help to find out more information.");
            System.err.println();
        }
    }

    private void runtimeExceptionHandler(RuntimeException re) {
        this.logUnixEnvironment();
        this.logCommandsWithArgs();
        sLogger.error((Object)re.getMessage(), (Throwable)re);
        this.printRuntimeErrorMessage(re);
    }

    private void logUnixEnvironment() {
        StringBuilder environmentVariables = new StringBuilder();
        environmentVariables.append(CLIConstants.NEW_LINE);
        environmentVariables.append("ENVIRONMENT VARIABLES:" + CLIConstants.NEW_LINE);
        for (String name : System.getenv().keySet()) {
            String value = System.getenv().get(name);
            environmentVariables.append(String.format("\t%s=%s" + CLIConstants.NEW_LINE, name, value));
        }
        environmentVariables.append(CLIConstants.NEW_LINE);
        sLogger.error((Object)environmentVariables.toString());
    }

    private void logCommandsWithArgs() {
        String cmd = CLIConstants.NEW_LINE + "COMMAND:" + CLIConstants.NEW_LINE + "\t" + "Script=" + this.scriptName + CLIConstants.NEW_LINE;
        for (String cmdArg : this.cmdArgs) {
            cmd = cmd + "\tArg=" + cmdArg + CLIConstants.NEW_LINE;
        }
        sLogger.error((Object)cmd);
    }

    private void printRuntimeErrorMessage(RuntimeException re) {
        System.err.println("Application error " + this.initialization.getScriptName() + ":");
        String message = re.getMessage() == null ? "" : ": " + re.getMessage();
        System.err.println(message);
        System.err.println();
        String logMessage = this.logHandler.isLoggingOn() ? String.format("See the log file '%s'", this.logHandler.getLogName()) : String.format("Execute %s with logging enabled using the -l or --log option", this.scriptName);
        System.err.println(logMessage);
        System.err.println();
        System.err.println("Command executed " + this.getCmdWithArgsForErrorMsg());
        System.err.println();
    }

    private String getCmdWithArgsForErrorMsg() {
        String cmdLine = this.scriptName + " ";
        for (String cmdArg : this.cmdArgs) {
            cmdLine = cmdLine + cmdArg + " ";
        }
        return cmdLine;
    }

    private void exceptionHandler(Exception e) {
        System.err.println("Error in " + this.initialization.getScriptName() + CLIConstants.NEW_LINE + e.getMessage());
        System.err.println();
        if (this.logHandler.isLoggingOn()) {
            sLogger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void throwableHandler(Throwable t) {
        System.err.println("Error in " + this.initialization.getScriptName() + CLIConstants.NEW_LINE + t.getMessage());
        System.err.println();
        if (this.logHandler.isLoggingOn()) {
            sLogger.error((Object)t.getMessage(), t);
        }
        try {
            this.logUnixEnvironment();
            this.logCommandsWithArgs();
        }
        catch (Exception e) {
            sLogger.error((Object)"Error: Could not log unix environment and command args");
        }
    }
}

