/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.lib.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class DeterministicExecutor
implements Executor {
    private List<Runnable> commands = new ArrayList<Runnable>();

    public boolean isIdle() {
        return this.commands.isEmpty();
    }

    public void runPendingCommands() {
        List<Runnable> commandsToRun = this.commands;
        this.commands = new ArrayList<Runnable>();
        for (Runnable command : commandsToRun) {
            command.run();
        }
    }

    public void runUntilIdle() {
        while (!this.isIdle()) {
            this.runPendingCommands();
        }
    }

    public void execute(Runnable command) {
        this.commands.add(command);
    }
}

