/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.alignment.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelabeledAlignment
extends Unchangeable
implements Alignment {
    private Alignment delegate;
    private Map<String, String> labelMap = new HashMap<String, String>();

    public RelabeledAlignment(Alignment delegate) {
        this.delegate = delegate;
        for (String label : delegate.getLabels()) {
            this.labelMap.put(label, label);
        }
    }

    @Override
    public List<String> getLabels() {
        return new ArrayList<String>(this.labelMap.keySet());
    }

    @Override
    public Symbol symbolAt(String label, int column) throws NoSuchElementException {
        return this.delegate.symbolAt(this.map(label), column);
    }

    @Override
    public SymbolList symbolListForLabel(String label) throws NoSuchElementException {
        return this.delegate.symbolListForLabel(this.map(label));
    }

    @Override
    public Alignment subAlignment(Set<String> labels, Location loc) throws NoSuchElementException {
        return new RelabeledAlignment(this.delegate.subAlignment(this.map(labels), loc));
    }

    @Override
    public String seqString() {
        return this.delegate.seqString();
    }

    @Override
    public String subStr(int min, int max) {
        return this.delegate.subStr(min, max);
    }

    @Override
    public Alphabet getAlphabet() {
        return this.delegate.getAlphabet();
    }

    public Iterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    public List toList() {
        return this.delegate.toList();
    }

    @Override
    public SymbolList subList(int min, int max) {
        return this.delegate.subList(min, max);
    }

    @Override
    public Symbol symbolAt(int pos) {
        return this.delegate.symbolAt(pos);
    }

    @Override
    public void edit(Edit edit) throws IllegalAlphabetException, ChangeVetoException {
        this.delegate.edit(edit);
    }

    public Iterator symbolListIterator() {
        return new Alignment.SymbolListIterator(this);
    }

    protected Set<String> map(Set<String> labels) {
        HashSet<String> set = new HashSet<String>();
        Iterator<String> i = labels.iterator();
        while (i.hasNext()) {
            set.add(this.map(i.next()));
        }
        return set;
    }

    protected String map(Object label) {
        return this.labelMap.get(label);
    }
}

