/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListTools;

public class PairDistribution
extends AbstractChangeable
implements Serializable,
Distribution {
    private static Map cache = new HashMap();
    private Distribution first;
    private Distribution second;
    private Alphabet alphabet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Distribution getNullModel(Distribution first, Distribution second) {
        Map map = cache;
        synchronized (map) {
            Distribution dist;
            first = first.getNullModel();
            second = second.getNullModel();
            ListTools.Doublet distL = new ListTools.Doublet(first, second);
            SoftReference ref = (SoftReference)cache.get(distL);
            if (ref == null) {
                dist = new PairDistribution(first, second);
                cache.put(distL, new SoftReference<Distribution>(dist));
            } else {
                dist = (Distribution)ref.get();
                if (dist == null) {
                    dist = new PairDistribution(first, second);
                    cache.put(distL, new SoftReference<Distribution>(dist));
                }
            }
            return dist;
        }
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Distribution getNullModel() {
        return PairDistribution.getNullModel(this.first, this.second);
    }

    public void setNullModel(Distribution nullModel) throws IllegalAlphabetException, ChangeVetoException {
        throw new ChangeVetoException("PairDistribution objects can't have their null models changed.");
    }

    public void registerWithTrainer(ModelTrainer trainer) {
        trainer.registerDistribution(this.first);
        trainer.registerDistribution(this.second);
        trainer.registerTrainer(this, new PairTrainer());
    }

    public double getWeight(Symbol sym) throws IllegalSymbolException {
        if (sym instanceof BasisSymbol) {
            List symL = ((BasisSymbol)sym).getSymbols();
            Symbol f = (Symbol)symL.get(0);
            Symbol s = (Symbol)symL.get(1);
            return this.first.getWeight(f) * this.second.getWeight(s);
        }
        double score = 0.0;
        Iterator<Symbol> i = ((FiniteAlphabet)sym.getMatches()).iterator();
        while (i.hasNext()) {
            AtomicSymbol s = (AtomicSymbol)i.next();
            score += this.getWeight(s);
        }
        return score;
    }

    public void setWeight(Symbol sym, double weight) throws ChangeVetoException {
        throw new ChangeVetoException("Can't set the weight directly in a PairDistribution. You must set the weights in the underlying distributions.");
    }

    public PairDistribution(Distribution first, Distribution second) {
        this.first = first;
        this.second = second;
        this.alphabet = AlphabetManager.getCrossProductAlphabet(Arrays.asList(first.getAlphabet(), second.getAlphabet()));
    }

    public void registerWithTrainer(DistributionTrainerContext dtc) {
        dtc.registerTrainer(this, new PairTrainer());
    }

    public Symbol sampleSymbol() {
        try {
            return this.getAlphabet().getSymbol(Arrays.asList(this.first.sampleSymbol(), this.second.sampleSymbol()));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Couldn't sample symbol", ise);
        }
    }

    private class PairTrainer
    extends IgnoreCountsTrainer
    implements Serializable {
        private PairTrainer() {
        }

        public double getCount(DistributionTrainerContext dtc, AtomicSymbol as) throws IllegalSymbolException {
            PairDistribution.this.getAlphabet().validate(as);
            List symL = as.getSymbols();
            Symbol f = (Symbol)symL.get(0);
            Symbol s = (Symbol)symL.get(1);
            return (dtc.getCount(PairDistribution.this.first, f) + dtc.getCount(PairDistribution.this.second, s)) * 0.5;
        }

        public void addCount(DistributionTrainerContext dtc, Symbol sym, double times) throws IllegalSymbolException {
            PairDistribution.this.getAlphabet().validate(sym);
            if (!(sym instanceof AtomicSymbol)) {
                throw new IllegalSymbolException("Can't add counts for ambiguity symbols. Got: " + sym.getName());
            }
            List symL = ((BasisSymbol)sym).getSymbols();
            Symbol f = (Symbol)symL.get(0);
            Symbol s = (Symbol)symL.get(1);
            dtc.addCount(PairDistribution.this.first, f, times);
            dtc.addCount(PairDistribution.this.second, s, times);
        }
    }
}

