import java.text.Collator

if( args.length < 3 ) {
  println("USAGE:  <EXPECTED_FILE>  <ACTUAL_FILE>  <COL_TO_SORT...>")
  return -1
}
  
String[] linesExpected = new File(args[0])
String[] linesActual = new File(args[1])
List<Integer> colsToSortZeroBased = new ArrayList<Integer>()
for(int i=2; i < args.length; i++)
  colsToSortZeroBased.add(Integer.parseInt(args[i]) - 1)

errorIfLineCountMismatch(linesExpected, linesActual)

int numLinesMismatched = 0
for(int i=0; i < linesExpected.length; i++) {
  if( linesExpected[i].startsWith("#") )
    continue
  String[] colsExpected = linesExpected[i].split("\t")
  String[] colsActual   = linesActual[i].split("\t")
  for(int colToSortZeroBased : colsToSortZeroBased) {
    colsExpected[colToSortZeroBased] = sortFieldsInCol(colsExpected, colToSortZeroBased)
    colsActual[colToSortZeroBased]   = sortFieldsInCol(colsActual, colToSortZeroBased)
  }
  String exp = join(colsExpected, "\t")
  String act = join(colsActual, "\t")
  if( ! exp.equals(act) ) {
    numLinesMismatched++
    printDiff(exp, act, i+1)
  }
}

if( numLinesMismatched == 0 ) 
  println("All match")
else
  println("\n\nERROR: # lines mismatched: " + numLinesMismatched)
  
  
  

private void errorIfLineCountMismatch(String[] linesExpected, String[] linesActual) {
  if( linesExpected.length != linesActual.length ) {
    String msg = "ERROR: Line count mismatch in files"
    println(msg)
    println("# lines:")
    println("  Expected: " + linesExpected.length)
    println("  Actual:   " + linesActual.length)
    throw new IllegalArgumentException(msg)
  }
}

private String sortFieldsInCol(String[] cols, int colToSort) {
  String col  = cols[colToSort]
  //println("before: " + col)
  
  // Some cases where "0.0" became "0", and "[1.0]" became "[1]"
  col = col.replace(".0,",  ",").replace("[1.0]",  "[1]")

  boolean isJson = col.startsWith("{") && col.endsWith("}")
  if( isJson )
    col = col.substring(1, col.length() - 1)

  String[] pairs = col.split(",")
  Arrays.sort(pairs, Collator.getInstance())
  col = join(pairs, ",")
  
  if( isJson )
    col = "{" + col + "}"
  
  //println("after:  " + col)
  return col
}

private String join(String[] cols, String delim) {
  StringBuilder s = new StringBuilder()
  for(int i=0; i < cols.length; i++) {
    if( i > 0 )
      s.append(delim)
    s.append(cols[i])
  }
  return s.toString()
}

private void printDiff(String exp, String act, int lineNum) {
  println("----------- Diff (line " + (lineNum+1) + ") --------------")
  println("Expected: " + exp)
  println("Actual  : " + act)
  String[] colsExpected = exp.split("\t")
  String[] colsActual   = act.split("\t")
  for(int i=0; i < colsExpected.length; i++) {
    if( ! colsExpected[i].equals(colsActual[i]) ) {
      println("====")
      println("  Expected[" + (i+1) + "]: " + colsExpected[i])
      println("    Actual[" + (i+1) + "]: " + colsActual[i])
      println("====")
    }
  }      
  println("----------------------------------------------------")
}