#!/bin/sh

# exit if any statement returns a non-zero exit code
set -e

if [ "$#" -ne 1 ]; then
	echo "Usage: count_users_from_usage.sh user_report_path"
	exit 1
fi

bior_drill=bior_drill
count_users_ruby=count_users_from_usage.rb
type $bior_drill >/dev/null 2>&1 || { echo >&2 "Can't find command $bior_drill"; exit 1; }
type $count_users_ruby >/dev/null 2>&1 || { echo >&2 "Can't find command $count_users_ruby"; exit 1; }

sage_url=http://bsu-sage/prod.log
echo "Getting usage from $sage_url and producing intermediate report file"
output=/tmp/usage_report$$
curl $sage_url | $bior_drill -p @fields.app -p @fields.user -p @fields.evt| grep -v "^#" | grep "^bior_" | cut -f 2,3 | $count_users_ruby > $output

sorted_user_report=$1
shift
echo "Producing report in '$sorted_user_report'"

echo -e "user\temail\tcount" > $sorted_user_report
sort -nrk3 -t$'\t' $output >> $sorted_user_report

echo "removing temp files"
rm -f $output
