#!/bin/sh

# exit if any statement returns a non-zero exit code
set -e

if [ "$#" -ne 2 ]; then
	echo "Usage: count_catalogs_from_usage.sh catalog_total_report_path user_catalog_count_report_path"
	exit 1
fi

bior_drill=bior_drill
count_catalogs_ruby=count_catalogs_from_usage.rb
type $bior_drill >/dev/null 2>&1 || { echo >&2 "Can't find command $bior_drill"; exit 1; }
type $count_catalogs_ruby >/dev/null 2>&1 || { echo >&2 "Can't find command $count_catalogs_ruby"; exit 1; }

sage_url=http://bsu-sage/prod.log
echo "Getting usage from $sage_url and producing intermediate report file"
catalog_total_label=catalog_total
user_catalog_count_label=user_count
bior_commands_match_file=/tmp/pattern$$
echo "bior_overlap" > $bior_commands_match_file
echo "bior_same_variant" >> $bior_commands_match_file
output=/tmp/usage_report$$
curl $sage_url | $bior_drill -p @fields.app -p @fields.OPT_d -p @fields.evt -p @fields.user | grep -v "^#" |\
   grep -f $bior_commands_match_file | cut -f 2-4 | $count_catalogs_ruby $catalog_total_label $user_catalog_count_label > $output

sorted_catalog_report=$1
shift
user_catalog_count_report=$1
shift
echo "Producing reports in $sorted_catalog_report and $user_catalog_count_report"

echo -e "catalog_path\tcount" > $sorted_catalog_report
grep $catalog_total_label $output | cut -f 2-3 | sort -nrk2 >> $sorted_catalog_report
echo -e "catalog_path\tcount\tuser" > $user_catalog_count_report
grep $user_catalog_count_label $output | cut -f 2-4 | sort -k3 >> $user_catalog_count_report

echo "removing temp files"
rm -f $bior_commands_match_file $output
