#!/usr/bin/ruby

class ItemCount
   def initialize()
      @item_map = Hash.new
   end
   def add(item)
      count = @item_map[item]
      count = 0 if (count.nil?)
      count += 1
      @item_map[item] = count   
   end
   def each_count
      @item_map.each() { |item, count| yield item,count }
   end
   def count(item)
      count = @item_map[item]
      return 0 if count.nil?
      count
   end
   def total()
      total = 0
      @item_map.each_value() do |count|
         total += count
      end
      total
   end
end

# Test it
#item_count=ItemCount.new
#item_count.add("m026366")
#item_count.add("m026366")
#item_count.add("m026366")
#item_count.add("m042195")
#item_count.add("m042195")
#STDERR.puts item_count.total

def read_data(user_catalog_map, catalog_user_map)
   while (line = gets)
      fields = line.chomp.split(/\t/)
      catalog = fields[0]
      next if (catalog == ".")
      begin_end = fields[1]
      next if (begin_end != "BEGIN")
      user = fields[2]
      catalog_count = user_catalog_map[user]
      if (catalog_count.nil?)
         catalog_count = ItemCount.new
         user_catalog_map[user] = catalog_count
      end
      catalog_count.add(catalog)
   
      user_count = catalog_user_map[catalog]
      if (user_count.nil?)
         user_count = ItemCount.new
         catalog_user_map[catalog] = user_count
      end
      user_count.add(user)
   end
end

if (ARGV.size < 2)
   STDERR.puts "Usage: count_catalogs_from_usage.rb catalog_total_label user_catalog_count_label -|tab_delimited_usage_file [tab_delimited_usage_file ...]"
   STDERR.puts "  where catalog_total_label will be output in first column of catalog total counts"
   STDERR.puts "        user_catalog_count_label will be output in first column of user counts by catalog"
   STDERR.puts "        multiple tab_delimited_usage_file arguments can be supplied but usually only 1 is given or supplied from STDIN. Content is expected to have:"
   STDERR.puts "           column 1 - catalog name ('.' is skipped)"
   STDERR.puts "           column 2 - type of transaction - only BEGIN is kept"
   STDERR.puts "           column 3 - LAN ID"
   exit 1
end
   
catalog_total_label = ARGV.shift
user_catalog_count_label = ARGV.shift

user_catalog_map = Hash.new
catalog_user_map = Hash.new
read_data(user_catalog_map, catalog_user_map)

data = Array.new
catalog_user_map.each() do |catalog, user_count|
   data.clear
   data.push(catalog_total_label)
   data.push(catalog)
   data.push(user_count.total)
   puts data.join("\t")
end

user_catalog_map.each() do |user, catalog_count|
   catalog_count.each_count() do |catalog, count|
      data.clear
      data.push(user_catalog_count_label)
      data.push(catalog)
      data.push(count)
      data.push(user)
      puts data.join("\t")
   end
end

