export GIT_BRANCH_OR_TAG=$1
export RELEASE=$2

if [ -z "$GIT_BRANCH_OR_TAG" ] || [ -z "$RELEASE" ] ; then
  echo "USAGE:  deploy.sh  <GIT_BRANCH_OR_TAG>  <RELEASE>"
  echo "  Ex:  deploy.sh  bior-toolkit-4.3.1--2017-09-29  4.3.1"
  exit 1
fi



export DATE=`date +%Y-%m-%d_%H-%M-%S`
# NOTE: SHARED_DIR *must* be a folder that is accessible by grid engine tasks!
export SHARED_DIR=/data5/bsi/BIOR/Deployment/Temp/bior_${RELEASE}_${USER}_${DATE}
mkdir –p $SHARED_DIR
cd $SHARED_DIR

echo "Testing from dir: $SHARED_DIR"

# Clone the repo and create a branch
echo "Clone the bior-toolkit repo (1 min)..."
git clone http://tfs.mayo.edu:8080/tfs/MayoClinic/IMA/_git/bior-toolkit
cd bior-toolkit
# NOTE: SHOULD CREATE A BRANCH THROUGH TFS-GIT WEBPAGE AND TIE DEPLOYMENT TO A USER-REQUEST
# Create a "Release" branch from dev
git checkout $GIT_BRANCH_OR_TAG


#=========================================================================
# Compile
#=========================================================================
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  Compile  (1 min)..." 
mvn clean package -DskipTests  > $SHARED_DIR/1_compile.log  2> $SHARED_DIR/1_compile.err

source ./setupEnv.sh
# Verify BioR build
#   Ex:  /local2/tmp/m054457/bior-toolkit/target/bior_pipeline-4.3.1/bin/bior_drill
build=`which bior_drill`
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  Compile finished"
if [[ $build =~ "${RELEASE}" ]] ; then
  echo "1) Compile - OK"
else
  echo "1) Compile - FAILED!!!"
  exit 1
fi


#=========================================================================
# Verify unit and integration tests
#=========================================================================
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  Verify unit and integration tests  (20 min)..."
mvn clean verify > $SHARED_DIR/2_verify.log  2> $SHARED_DIR/2_verify.err
exitCode=$?
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  Verify finished"
if [ $exitCode == 0 ] ; then
  echo "Verify unit and integration tests - OK"
else
  echo "Verify of unit and integration tests - FAILED!!!
  exit 1
fi


#=========================================================================
# Smoke tests
#=========================================================================
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  Run smoke tests  (15 min)..."
cd $SHARED_DIR/scripts/DeploymentTests
./runTests.sh  > $SHARED_DIR/3_smokeTests.log  2> $SHARED_DIR/3_smokeTests.err
exitCode=$?
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  Smoke tests finished"
if [ $exitCode == 0 ] ; then
  echo "Smoke tests - OK"
else
  echo "Smoke tests - FAILED!!!
  exit 1
fi


#=========================================================================
# bior_annotate.sh tests
#=========================================================================
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  Run bior_annotate.sh scripts..."
cd $SHARED_DIR/
git clone https://github.com/Steven-N-Hart/bior_annotate.git
cd bior_annotate
mkdir -p tmp_tests

# This will modify the tool_info.txt in-place
perl -i -pe "s#^BIOR=.*#BIOR=$BIOR_LITE_HOME/bin/#"  trunk/config/tool_info.txt
perl -i -pe 's#^BIOR_PROFILE=.*$#BIOR_PROFILE=\"\$\{BIOR\}/../../PKG_PROFILE\"#'  trunk/config/tool_info.txt

# Create a PKG_PROFILE file if one does not exist (they only exist in the mayobiotools dirs; so if it doesn't exist, we are probably still in a pre-release dir)
if [ ! -f $BIOR_LITE_HOME/../PKG_PROFILE ] ; then
  # Copy a known good PKG_PROFILE
  cp /usr/local/biotools/bior_scripts/4.3.0/PKG_PROFILE  $BIOR_LITE_HOME/..;
  # Update BIOR_LITE_HOME variable in it
  sed -i "s#^BIOR_LITE_HOME=.*#BIOR_LITE_HOME=$BIOR_LITE_HOME#g" $BIOR_LITE_HOME/../PKG_PROFILE;
fi

cd trunk/tests/
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  bior_annotate.sh standalone (5 min)..."
./test_good_path_standalone.sh  -d  $SHARED_DIR/bior_annotate/trunk  -t $SHARED_DIR/bior_annotate/tmp_tests  > $SHARED_DIR/4_biorAnnot.log  2> $SHARED_DIR/4_biorAnnot.err
exitCode=$?
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  bior_annotate.sh standalone finished"
if [ $exitCode == 0 ] ; then
  echo "bior_annotate.sh standalone tests - OK"
else
  echo "bior_annotate.sh standalone tests - FAILED!!!
  exit 1
fi

## TODO:  How to grab the output of this one and see if it succeeded:?????????????
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  bior_annotate.sh grid (10 min)..."
echo "Check your email in 10 min to see if it finished successfully"
./test_good_path_grid.sh        -d  $SHARED_DIR/bior_annotate/trunk  -t $SHARED_DIR/bior_annotate/tmp_tests  > $SHARED_DIR/4_biorAnnot.log  2> $SHARED_DIR/4_biorAnnot.err
exitCode=$?
timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  bior_annotate.sh grid finished"
if [ $exitCode == 0 ] ; then
  echo "bior_annotate.sh standalone tests - OK"
else
  echo "bior_annotate.sh standalone tests - FAILED!!!
  exit 1
fi

timestamp=$(date +%Y-%m-%d_%H:%M:%S) 
echo "$timestamp  DONE-ALL."