#!/bin/sh

# exit if any statement returns a non-zero exit code
set -e

if [ "$#" -ne 2 ]; then
	echo "Usage: detail_bior_create_catalog_users_after_date_from_usage.sh YYYY-MM-DD user_report_path"
	exit 1
fi

bior_drill=bior_drill
detail_users_ruby=detail_bior_create_catalog_users_after_date_from_usage.rb
type $bior_drill >/dev/null 2>&1 || { echo >&2 "Can't find command $bior_drill"; exit 1; }
type $detail_users_ruby >/dev/null 2>&1 || { echo >&2 "Can't find command $detail_users_ruby"; exit 1; }


target_date=$1
shift

app_name=bior_create_catalog
sage_url=http://bsu-sage/prod.log
echo "Getting usage from $sage_url and producing intermediate report file"
output=/tmp/usage_report$$
curl $sage_url | $bior_drill -p @fields.app -p @fields.user -p @fields.OPT_i -p @timestamp -p @fields.evt | grep -v "^#" | grep "^${app_name}" \
	| grep "BEGIN" | cut -f 1-4 | $detail_users_ruby $target_date > $output

sorted_user_report=$1
shift
echo "Producing report in '$sorted_user_report'"

echo -e "user\temail\tcatalog\trun_date" > $sorted_user_report
sort -k1 -t$'\t' $output >> $sorted_user_report

echo "removing temp files"
rm -f $output
