#!/usr/bin/ruby

# Usage: count_users_from_usage.rb -|user_file [user_file ...]"
#        multiple user_file arguments can be supplied but usually only 1 is given or supplied from STDIN. Content is expected to have:"
#           column 1 - user name ('.' is skipped). This is repeated for all the times this user has called a BioR command"
#           column 2 - type of transaction - only BEGIN is kept"
   
class ItemCount
   def initialize()
      @item_map = Hash.new
   end
   def add(item)
      count = @item_map[item]
      count = 0 if (count.nil?)
      count += 1
      @item_map[item] = count   
   end
   def each_count
      @item_map.each() { |item, count| yield item,count }
   end
   def count(item)
      count = @item_map[item]
      return 0 if count.nil?
      count
   end
   def total()
      total = 0
      @item_map.each_value() do |count|
         total += count
      end
      total
   end
end

def email_for_lan_id(lan_id)
   cmd = "curl -s -B 'ldap://ldap.mayo.edu/o=Mayo,c=US??sub?(preferredRfc822Recipient=#{lan_id}@exchange.mayo.edu)'"
   user_info = `#{cmd}`
   if ($?.nil?)
      STDERR.puts "Unknown problem running '#{cmd} to get email"
      return ""
   elsif ($?.exitstatus != 0)
      STDERR.puts "Couldn't get email for #{lan_id} due to non-zero exit status #{$?.exitstatus} running '#{cmd}'"
      return ""
   end

   email = nil
   for line in user_info.split("\n")
      fields = line.strip.split(/:/)
      key = fields[0]
      email = fields[1].strip if (key == "mail")
   end      
   if (email.nil?)
      STDERR.puts "Couldn't get email for #{lan_id}"
      return ""
   end
   
   email
end

def read_data()
   user_count = ItemCount.new
   while (line = gets)
      fields = line.chomp.split(/\t/)
      user = fields[0]
      next if (user == ".")
      begin_end = fields[1]
      next if (begin_end != "BEGIN")
      user_count.add(user)
   end
   user_count
end


user_count = read_data

data = Array.new
user_count.each_count() do |user, count|
   data.clear
   data.push(user)
   data.push(email_for_lan_id(user))
   data.push(count)
   puts data.join("\t")
end


