#!/usr/bin/env ruby
 
require 'date'
  
class ItemCount
   def initialize()
      @item_map = Hash.new
   end
   def add(item)
      count = @item_map[item]
      count = 0 if (count.nil?)
      count += 1
      @item_map[item] = count   
   end
   def each_count
      @item_map.each() { |item, count| yield item,count }
   end
   def count(item)
      count = @item_map[item]
      return 0 if count.nil?
      count
   end
   def total()
      total = 0
      @item_map.each_value() do |count|
         total += count
      end
      total
   end
end

def email_for_lan_id(lan_id)
   cmd = "curl -s -B 'ldap://ldap.mayo.edu/o=Mayo,c=US??sub?(preferredRfc822Recipient=#{lan_id}@exchange.mayo.edu)'"
   user_info = `#{cmd}`
   if ($?.nil?)
      STDERR.puts "Unknown problem running '#{cmd} to get email"
      return ""
   elsif ($?.exitstatus != 0)
      STDERR.puts "Couldn't get email for #{lan_id} due to non-zero exit status #{$?.exitstatus} running '#{cmd}'"
      return ""
   end

   email = nil
   for line in user_info.split("\n")
      fields = line.strip.split(/:/)
      key = fields[0]
      email = fields[1].strip if (key == "mail")
   end      
   if (email.nil?)
      STDERR.puts "Couldn't get email for #{lan_id}"
      return ""
   end
   
   email
end

def parse_date(date_str)
   DateTime.parse(date_str).to_time
end

def read_data(match_this_app_name, target_date)
   user_count = ItemCount.new
   while (line = gets)
      fields = line.chomp.split(/\t/)
      app_name = fields[0]
      next if (app_name != match_this_app_name)
      user = fields[1]
      next if (user == ".")
      run_date = DateTime.parse(fields[2]).to_time
      next if (run_date < target_date)
      user_count.add(user)
   end
   user_count
end

if (ARGV.size < 2)
   STDERR.puts "Usage: count_app_users_after_date_from_usage.rb app_name YYYY-MM-DD -|user_file [user_file ...]"
   STDERR.puts "        app_name is the value of @fields.app in logstash (e.g. bior_drill, bior_overlap). Should work with any app name, not just bior_ apps"
   STDERR.puts "        YYYY-MM-DD is the date after which you want to grab data (e.g. 2016-01-15 is January 15, 2016)"
   STDERR.puts "        multiple user_file arguments can be supplied but usually only 1 is given or supplied from STDIN. Content is expected to have:"
   STDERR.puts "           column 1 - app name. Only app names matching the supplied app name are kept"
   STDERR.puts "           column 2 - user name ('.' is skipped). This is repeated for all the times this user has called a BioR command"
   STDERR.puts "           column 3 - timestamp (looks like 2013-05-07T14:57:48.610Z from logstash)"
   exit 1
end

app_name = ARGV.shift

target_date_str = ARGV.shift
target_date = parse_date(target_date_str)
if (target_date.nil?)
   STDERR.puts "Problem parsing #{target_date_str}. Should look like 'YYYY-MM-DD"
   exit 1
end

user_count = read_data(app_name, target_date)

data = Array.new
user_count.each_count() do |user, count|
   data.clear
   data.push(user)
   data.push(email_for_lan_id(user))
   data.push(count)
   puts data.join("\t")
end
