/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VEPFormatter
implements Formatter {
    private boolean isJsonPathsInitialized = false;
    private List<JsonPath> mCompiledJsonPaths = null;
    private List<String> paths = Arrays.asList("Allele", "Gene", "Feature", "Feature_type", "Consequence", "cDNA_position", "CDS_position", "Protein_position", "Amino_acids", "Codons", "HGNC", "SIFT_TERM", "SIFT_Score", "PolyPhen_TERM", "PolyPhen_Score");

    private void initCompiledJsonPaths() {
        this.mCompiledJsonPaths = new ArrayList<JsonPath>();
        for (int i = 0; i < this.paths.size(); ++i) {
            this.mCompiledJsonPaths.add(JsonPath.compile((String)this.paths.get(i), (Predicate[])new Predicate[0]));
        }
        this.isJsonPathsInitialized = true;
    }

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.VEP;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("VEP.Allele", "VEP.Gene", "VEP.Feature", "VEP.Feature_type", "VEP.Consequence", "VEP.cDNA_position", "VEP.CDS_position", "VEP.Protein_position", "VEP.Amino_acids", "VEP.Codons", "VEP.HGNC", "SIFT.TERM", "SIFT.Score", "PolyPhen.TERM", "PolyPhen.Score");
    }

    @Override
    public List<String> format(String json) {
        if (!this.isJsonPathsInitialized) {
            this.initCompiledJsonPaths();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (JsonPath path : this.mCompiledJsonPaths) {
            values.add(FormatUtils.drill(path, json));
        }
        return values;
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return this.paths;
    }
}

