/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class EspFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"EA._maf", "AA._maf"};
    private static final JsonPath PATH_EUROPEAN_MAF = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_AFRICAN_MAF = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Predicate[])new Predicate[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.ESP;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("ESP6500.EUR_MAF", "ESP6500.AFR_MAF");
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_EUROPEAN_MAF, json), FormatUtils.drill(PATH_AFRICAN_MAF, json));
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }
}

