/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.IdentityPipe;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.Treat.Cleaner;
import edu.mayo.bior.pipeline.Treat.TreatPipe;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.JSON.RemoveAllJSONPipe;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.JSON.tabix.OverlapPipe;
import edu.mayo.pipes.JSON.tabix.SameVariantPipe;
import edu.mayo.pipes.bioinformatics.VCF2VariantPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.pipes.util.BiorProperties;
import java.io.IOException;
import java.util.List;

public class OverlapingFeaturesPipeline
extends Pipeline
implements Cleaner {
    private BiorProperties biorProps = new BiorProperties();
    private String baseDir;
    private boolean header = true;
    private int deleteColCount = 0;
    private int numCols = 0;
    private int firstCol = 0;
    private static final int kGeneName = 0;
    private static final int kNCBIEntrezGeneID = 1;
    private static final int kNCBICols = 2;
    private static final String[] kGeneDrill = new String[]{"gene", "GeneID"};
    private static final int kdbSNPBuild = 0;
    private static final int kdbSNPSuspect = 1;
    private static final int kdbSNPClinical = 2;
    private static final int kdbSNPDisease = 3;
    private static final int kdbSNPAllele = 4;
    private static final int kdbSNPID = 5;
    private static final int kdbSNPRef = 6;
    private static final int kdbSNPAlt = 7;
    private static final int kdbSNPCols = 12;
    private static final String[] kDbSnpDrill = new String[]{"INFO.dbSNPBuildID", "INFO.SSR", "INFO.SCS", "INFO.CLN", "INFO.SAO", "_id", "REF", "ALT", "INFO.SYN", "INFO.S3D", "INFO.U5", "INFO.NSF"};
    private static final String[] kDbSnpSuspectLookup = new String[]{"unspecified", "Paralog", "byEST", "Para_EST", "oldAlign", "other"};
    private static final String[] kDbSnpClinicalLookup = new String[]{"unknown", "untested", "non-pathogenic", "probable-non-pathogenic", "probable-pathogenic", "pathogenic", "drug-response", "histocompatibility", "other"};
    private static final String[] kDbSnpAlleleLookup = new String[]{"unspecified", "Germline", "Somatic", "Both", "not-tested", "tested-inconclusive", "other"};
    private static final int kHGNCSymbol = 0;
    private static final int kHGNCEntrezGeneID = 1;
    private static final int kHGNCEnsemblGeneID = 2;
    private static final int kHGNCCols = 3;
    private static final String[] kHGNCDrill = new String[]{"Approved_Symbol", "Entrez_Gene_ID", "Ensembl_Gene_ID"};
    private static final int kCosmicID = 0;
    private static final int kCosmicCDS = 1;
    private static final int kCosmicAA = 2;
    private static final int kCosmicStrand = 3;
    private static final int kCosmicCols = 4;
    private static final String[] kCosmicDrill = new String[]{"Mutation_ID", "Mutation_CDS", "Mutation_AA", "Mutation_GRCh37_strand"};
    private static final int kOMIMDisorder = 0;
    private static final int kOMIMCols = 1;
    private static final String[] kOMIMDrill = new String[]{"Disorders"};
    private static final int kBlacklistScore = 0;
    private static final int kBlacklistCols = 1;
    private static final String[] kBlacklistDrill = new String[]{"score"};
    private static final int kConservationScore = 0;
    private static final int kConservationCols = 1;
    private static final String[] kConservationDrill = new String[]{"score"};
    private static final int kEnhancerScore = 0;
    private static final int kEnhancerCols = 1;
    private static final String[] kEnhancerDrill = new String[]{"score"};
    private static final int kTFBSScore = 0;
    private static final int kTFBSCols = 1;
    private static final String[] kTFBSDrill = new String[]{"score"};
    private static final int kTSSScore = 0;
    private static final int kTSSCols = 1;
    private static final String[] kTSSDrill = new String[]{"score"};
    private static final int kUniqueScore = 0;
    private static final int kUniqueCols = 1;
    private static final String[] kUniqueDrill = new String[]{"score"};
    private static final int kRegulationName = 0;
    private static final int kRegulationCols = 1;
    private static final String[] kRegulationDrill = new String[]{"name"};
    private static final int kRepeatName = 0;
    private static final int kRepeatCols = 1;
    private static final String[] kRepeatDrill = new String[]{"repName"};
    private static final int kMiRLandmark = 0;
    private static final int kMiRType = 1;
    private static final int kMiRMinBP = 2;
    private static final int kMiRMaxBP = 3;
    private static final int kMiRStrand = 4;
    private static final int kMiRAcc = 5;
    private static final int kMiRID = 6;
    private static final int kMiRCols = 7;
    private static final String[] kMiRBaseDrill = new String[]{"_landmark", "type", "_minBP", "_maxBP", "_strand", "ACC", "ID"};
    private static final String kBlank = ".";
    private static final int kScoreCutoff = 500;
    private static final String kPlusStrand = "+";
    private static final String[] kSNVHeader = new String[]{"dbSNP135", "dbSNP135Alleles", "Gene ID", "Gene Name", "Entrez_id", "OMIM Disease"};
    private static final String[] kSNVHeaderGGPS = new String[]{"COSMIC", "BlacklistedRegion", "Alignability/Uniquness", "Repeat_Region", "DiseaseVariant", "miRbase", "SNP_SuspectRegion", "SNP_ClinicalSig", "polyphen2", "Variant_AlleleOrigin", "First_dbSNP_Build", "UniprotID"};
    protected static final String[] kSNVHeaderSift = new String[]{"Codons", "Transcript ID", "Protein ID", "Substitution", "Region", "SNP Type", "Prediction", "Score", "Median Info", "Gene ID", "Gene Name", "OMIM Disease", "Average Allele Freqs", "User Comment", "SynonymousCodonUsage", "Difference"};
    private static final String[] kSNVHeaderUCSC = new String[]{"conservation", "regulation", "tfbs", "tss", "enhancer"};
    protected static final String kSNVHeaderSSeq = "# inDBSNPOrNot\taccession\tfunctionGVS\taminoAcids\tproteinPosition\tpolyPhen\tgeneList\tEntrez_id\tGene_title\tclosest_transcript_id\tTissue_specificity\tpathway\tGeneCards\tKaviar_Variants";
    protected static final String[] kSNVHeaderSEffect = new String[]{"Homozygous", "Bio_type", "accession", "Exon_ID", "Exon_Rank", "Effect", "aminoAcids", "proteinPosition", "Codon_Degeneracy", "geneList", "Entrez_id", "Gene_title", "Tissue_specificity", "pathway", "GeneCards", "Kaviar_Variants"};

    public OverlapingFeaturesPipeline() throws IOException {
        this.baseDir = this.biorProps.get("fileBase");
        this.init((Pipe)new IdentityPipe(), (Pipe)new IdentityPipe(), false);
    }

    public OverlapingFeaturesPipeline(Pipe input, Pipe output) throws IOException {
        this.baseDir = this.biorProps.get("fileBase");
        this.init(input, output, false);
    }

    public OverlapingFeaturesPipeline(Pipe input, Pipe output, boolean clean) throws IOException {
        this.baseDir = this.biorProps.get("fileBase");
        this.init(input, output, clean);
    }

    public OverlapingFeaturesPipeline(Pipe input, Pipe output, String baseDir, boolean clean) throws IOException {
        if (baseDir != null) {
            this.baseDir = baseDir;
        }
        this.init(input, output, clean);
    }

    public void init(Pipe input, Pipe output, boolean clean) throws IOException {
        Object cleaner = clean ? new TransformFunctionPipe((PipeFunction)new TreatPipe(this)) : new IdentityPipe();
        if (this.baseDir == null) {
            this.baseDir = this.biorProps.get("fileBase");
        }
        if (this.baseDir == null) {
            this.baseDir = "";
        }
        String genesFile = this.baseDir + this.biorProps.get("genesFile");
        String hgncFile = this.baseDir + this.biorProps.get("hgncFile");
        String dbsnpFile = this.baseDir + this.biorProps.get("dbsnpFile");
        String cosmicFile = this.baseDir + this.biorProps.get("cosmicFile");
        String hgncIndexFile = this.baseDir + this.biorProps.get("hgncIndexFile");
        String omimFile = this.baseDir + this.biorProps.get("omimFile");
        String omimIndexFile = this.baseDir + this.biorProps.get("omimIndexFile");
        String conservationFile = this.baseDir + this.biorProps.get("conservationFile");
        String repeatFile = this.baseDir + this.biorProps.get("repeatFile");
        String regulationFile = this.baseDir + this.biorProps.get("regulationFile");
        String uniqueFile = this.baseDir + this.biorProps.get("uniqueFile");
        String tssFile = this.baseDir + this.biorProps.get("tssFile");
        String tfbsFile = this.baseDir + this.biorProps.get("tfbsFile");
        String enhancerFile = this.baseDir + this.biorProps.get("enhancerFile");
        String blacklistedFile = this.baseDir + this.biorProps.get("blacklistedFile");
        String mirBaseFile = this.baseDir + this.biorProps.get("mirBaseFile");
        String[] geneDrill = kGeneDrill;
        String[] hgncDrill = kHGNCDrill;
        String[] dbSnpDrill = kDbSnpDrill;
        String[] cosmicDrill = kCosmicDrill;
        String[] omimDrill = kOMIMDrill;
        String[] blacklistDrill = kBlacklistDrill;
        String[] conservationDrill = kConservationDrill;
        String[] enhancerDrill = kEnhancerDrill;
        String[] tfbsDrill = kTFBSDrill;
        String[] tssDrill = kTSSDrill;
        String[] uniqueDrill = kUniqueDrill;
        String[] repeatDrill = kRepeatDrill;
        String[] regulationDrill = kRegulationDrill;
        String[] mirBaseDrill = kMiRBaseDrill;
        int posCol = -1;
        Pipeline p = new Pipeline(new Pipe[]{input, new VCF2VariantPipe(), new OverlapPipe(genesFile), new DrillPipe(false, geneDrill), new LookupPipe(hgncFile, hgncIndexFile, (posCol -= geneDrill.length) + 1), new DrillPipe(false, hgncDrill), new SameVariantPipe(dbsnpFile, posCol -= hgncDrill.length), new DrillPipe(false, dbSnpDrill), new SameVariantPipe(cosmicFile, posCol -= dbSnpDrill.length), new DrillPipe(false, cosmicDrill), new LookupPipe(omimFile, omimIndexFile, (posCol -= cosmicDrill.length) + 1), new DrillPipe(false, omimDrill), new OverlapPipe(blacklistedFile, posCol -= omimDrill.length), new DrillPipe(false, blacklistDrill), new OverlapPipe(conservationFile, posCol -= blacklistDrill.length), new DrillPipe(false, conservationDrill), new OverlapPipe(enhancerFile, posCol -= conservationDrill.length), new DrillPipe(false, enhancerDrill), new OverlapPipe(tfbsFile, posCol -= enhancerDrill.length), new DrillPipe(false, tfbsDrill), new OverlapPipe(tssFile, posCol -= tfbsDrill.length), new DrillPipe(false, tssDrill), new OverlapPipe(uniqueFile, posCol -= tssDrill.length), new DrillPipe(false, uniqueDrill), new OverlapPipe(repeatFile, posCol -= uniqueDrill.length), new DrillPipe(false, repeatDrill), new OverlapPipe(regulationFile, posCol -= repeatDrill.length), new DrillPipe(false, regulationDrill), new OverlapPipe(mirBaseFile, posCol -= regulationDrill.length), new DrillPipe(false, mirBaseDrill), new RemoveAllJSONPipe(), cleaner, output});
        this.setPipes(p.getPipes());
        this.deleteColCount = mirBaseDrill.length - posCol;
    }

    @Override
    public History doClean(History history) {
        String name;
        if (this.header) {
            this.header = false;
            this.numCols = history.size();
            this.firstCol = this.numCols - this.deleteColCount + 1;
            HistoryMetaData metaData = history.getMetaData();
            List columns = metaData.getColumns();
            for (int i = this.numCols - 1; i >= this.firstCol; --i) {
                columns.remove(i);
            }
            this.addVariantColumns(columns);
        }
        int startCol = this.firstCol;
        String geneSymbol = OverlapingFeaturesPipeline.getString((String)history.get((startCol += 2) + 0));
        int entrezGeneID = OverlapingFeaturesPipeline.parseInt((String)history.get(startCol + 1));
        String ensemblGeneID = OverlapingFeaturesPipeline.getString((String)history.get(startCol + 2));
        int firstBuild = OverlapingFeaturesPipeline.parseInt((String)history.get((startCol += 3) + 0));
        String suspectRegion = OverlapingFeaturesPipeline.lookupString((String)history.get(startCol + 1), kDbSnpSuspectLookup);
        String clinicalSig = OverlapingFeaturesPipeline.lookupString((String)history.get(startCol + 2), kDbSnpClinicalLookup);
        String alleleOrigin = OverlapingFeaturesPipeline.lookupString((String)history.get(startCol + 4), kDbSnpAlleleLookup);
        boolean diseaseVariant = Boolean.parseBoolean((String)history.get(startCol + 3));
        String dbSNPsID = OverlapingFeaturesPipeline.getString((String)history.get(startCol + 5));
        String dbSNPsRef = OverlapingFeaturesPipeline.getString((String)history.get(startCol + 6));
        String dbSNPsAlt = OverlapingFeaturesPipeline.getString((String)history.get(startCol + 7));
        int mutationID = OverlapingFeaturesPipeline.parseInt((String)history.get((startCol += 12) + 0));
        String cosmicCDS = (String)history.get(startCol + 1);
        String cosmicAA = (String)history.get(startCol + 2);
        boolean strand = kPlusStrand.equals(history.get(startCol + 3));
        String omimDisease = OverlapingFeaturesPipeline.getString((String)history.get((startCol += 4) + 0));
        boolean blacklisted = OverlapingFeaturesPipeline.isAboveCutoff((String)history.get(++startCol + 0));
        boolean conserved = OverlapingFeaturesPipeline.isAboveCutoff((String)history.get(++startCol + 0));
        boolean enhancer = OverlapingFeaturesPipeline.isAboveCutoff((String)history.get(++startCol + 0));
        boolean tfbs = OverlapingFeaturesPipeline.isAboveCutoff((String)history.get(++startCol + 0));
        boolean tss = OverlapingFeaturesPipeline.isAboveCutoff((String)history.get(++startCol + 0));
        boolean unique = OverlapingFeaturesPipeline.isAboveCutoff((String)history.get(++startCol + 0));
        boolean repeat = !OverlapingFeaturesPipeline.isEmpty(name = OverlapingFeaturesPipeline.getString((String)history.get(++startCol + 0)));
        name = OverlapingFeaturesPipeline.getString((String)history.get(++startCol + 0));
        boolean regulatory = !OverlapingFeaturesPipeline.isEmpty(name);
        String landmark = OverlapingFeaturesPipeline.getString((String)history.get(++startCol + 0));
        String type = OverlapingFeaturesPipeline.getString((String)history.get(startCol + 1));
        int minBP = OverlapingFeaturesPipeline.parseInt((String)history.get(startCol + 2));
        int maxBP = OverlapingFeaturesPipeline.parseInt((String)history.get(startCol + 3));
        boolean miRStrand = kPlusStrand.equals(history.get(startCol + 4));
        String acc = OverlapingFeaturesPipeline.getString((String)history.get(startCol + 5));
        String id = OverlapingFeaturesPipeline.getString((String)history.get(startCol + 6));
        for (int i = (startCol += 7) - 1; i >= this.firstCol; --i) {
            history.remove(i);
        }
        this.addDbSNPs(dbSNPsID, dbSNPsRef, dbSNPsAlt, history);
        this.addString(ensemblGeneID, history);
        this.addString(geneSymbol, history);
        this.addNonZeroInt(entrezGeneID, history);
        this.addString(omimDisease, history);
        this.addCosmic(mutationID, cosmicCDS, cosmicAA, strand, history);
        this.addBoolean(blacklisted, history);
        this.addBoolean(unique, history);
        this.addBoolean(repeat, history);
        this.addBoolean(diseaseVariant, history);
        this.addmiRBase(landmark, type, minBP, maxBP, miRStrand, acc, id, history);
        this.addString(suspectRegion, history);
        this.addString(clinicalSig, history);
        history.add((Object)kBlank);
        this.addString(alleleOrigin, history);
        this.addNonZeroInt(firstBuild, history);
        history.add((Object)kBlank);
        this.addBoolean(conserved, history);
        this.addBoolean(regulatory, history);
        this.addBoolean(tfbs, history);
        this.addBoolean(tss, history);
        this.addBoolean(enhancer, history);
        return history;
    }

    private void addVariantColumns(List<ColumnMetaData> columns) {
        for (String columnName : kSNVHeader) {
            columns.add(new ColumnMetaData(columnName));
        }
        for (String columnName : kSNVHeaderGGPS) {
            columns.add(new ColumnMetaData(columnName));
        }
        for (String columnName : kSNVHeaderUCSC) {
            columns.add(new ColumnMetaData(columnName));
        }
    }

    private void addDbSNPs(String dbSNPsID, String dbSNPsRef, String dbSNPsAlt, History history) {
        history.add((Object)dbSNPsID);
        if (!OverlapingFeaturesPipeline.isEmpty(dbSNPsRef)) {
            history.add((Object)(dbSNPsRef + "/" + dbSNPsAlt));
        } else {
            history.add((Object)kBlank);
        }
    }

    private void addNonZeroInt(int theInt, History history) {
        if (theInt > 0) {
            history.add((Object)("" + theInt));
        } else {
            history.add((Object)kBlank);
        }
    }

    private void addString(String theString, History history) {
        if (!OverlapingFeaturesPipeline.isEmpty(theString)) {
            history.add((Object)theString);
        } else {
            history.add((Object)kBlank);
        }
    }

    private void addBoolean(boolean theBool, History history) {
        if (theBool) {
            history.add((Object)"1");
        } else {
            history.add((Object)"0");
        }
    }

    private void addCosmic(int mutationID, String cosmicCDS, String cosmicAA, boolean strand, History history) {
        if (mutationID <= 0) {
            history.add((Object)kBlank);
            return;
        }
        StringBuilder result = new StringBuilder();
        result.append(mutationID);
        result.append(';');
        result.append(cosmicCDS);
        result.append(';');
        result.append(cosmicAA);
        if (strand) {
            result.append(";+");
        } else {
            result.append(";-");
        }
        history.add((Object)result.toString());
    }

    private void addmiRBase(String landmark, String type, int minBP, int maxBP, boolean miRStrand, String acc, String id, History history) {
        if (id == null) {
            history.add((Object)kBlank);
            return;
        }
        StringBuilder result = new StringBuilder();
        result.append(landmark);
        result.append('/');
        result.append(type);
        result.append('/');
        result.append(minBP);
        result.append('/');
        result.append(maxBP);
        if (miRStrand) {
            result.append("/+/");
        } else {
            result.append("/-/");
        }
        result.append(acc);
        result.append('/');
        result.append(id);
        history.add((Object)result.toString());
    }

    private static final boolean isAboveCutoff(String testStr) {
        int score = OverlapingFeaturesPipeline.parseInt(testStr);
        return score >= 500;
    }

    private static final boolean isEmpty(String theString) {
        return theString == null || theString.isEmpty();
    }

    private static final String getString(String theString) {
        if (theString == null || theString.isEmpty()) {
            return null;
        }
        if (theString.equals(kBlank)) {
            return null;
        }
        return theString;
    }

    private static final int parseInt(String theInt) {
        int result = 0;
        if (!theInt.equals(kBlank)) {
            try {
                result = Integer.parseInt(theInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static final String lookupString(String theInt, String[] theLookup) {
        int result = 0;
        if (!theInt.equals(kBlank)) {
            try {
                result = Integer.parseInt(theInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (result > theLookup.length) {
            return theLookup[0];
        }
        return theLookup[result];
    }
}

