/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.catalog.GoldenAttribute;
import edu.mayo.bior.pipeline.createCatalogProps.ColumnMetaFromCatalogCrawling;
import edu.mayo.bior.pipeline.createCatalogProps.ColumnMetaFromVcf;
import edu.mayo.bior.pipeline.exception.CatalogMetadataInputException;
import edu.mayo.bior.util.CatalogUtils;
import edu.mayo.bior.util.ClasspathUtil;
import edu.mayo.bior.util.progress.NumLineProgressHandler;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class CreateCatalogPropsCommand
implements CommandPlugin {
    private static final Logger sLogger = Logger.getLogger(CreateCatalogPropsCommand.class);
    public static long PROGRESS_HANDLER_NUM_LINES_CALLBACK_ON = 10000L;
    public static final char OPTION_CATALOG = 'd';
    public static final char OPTION_ORIGINAL_VCF = 'v';
    public static final char OPTION_TARGET_DIR = 't';
    private List<AddMetadataLines.BiorMetaControlledVocabulary> biorMetaControlledVocabulary = Arrays.asList(AddMetadataLines.BiorMetaControlledVocabulary.values());
    private boolean mIsVerbose = true;
    private StepLogger mStepLogger;

    public void init(Properties props) throws Exception {
    }

    public void setStepLogger(StepLogger stepLogger) {
        this.mStepLogger = stepLogger;
    }

    public void execute(CommandLine line, Options opts) throws InvalidDataException, IOException {
        String catalogBgzipPath = line.getOptionValue('d');
        CatalogUtils.warnIfDeprecated(catalogBgzipPath);
        boolean isVcfSpecified = line.hasOption('v');
        String catalogOriginalVcfPath = line.getOptionValue('v');
        String targetDir = line.getOptionValue('t');
        try {
            this.execNoCmd(catalogBgzipPath, catalogOriginalVcfPath, targetDir, isVcfSpecified, new ProgressHandler());
        }
        catch (IOException ioe) {
            throw new InvalidDataException("Error accessing one of the files: " + ioe.getMessage());
        }
        catch (URISyntaxException e) {
            throw new InvalidDataException("Could not find the columns defaults properties file: " + e.getMessage());
        }
        catch (ConfigurationException e) {
            throw new InvalidDataException("Error modifying the properties file: " + e.getMessage());
        }
    }

    public void execNoCmd(String catalogBgzipPath, String catalogOriginalVcfPath, String targetDirPath, boolean isVcfSpecified, NumLineProgressHandler progressHandler) throws InvalidDataException, IOException, URISyntaxException, ConfigurationException {
        File originalVcfFile;
        String catalogFullFilename;
        File targetDir;
        File catalogFile = new File(catalogBgzipPath);
        if (!catalogFile.exists()) {
            throw new IOException("Catalog file could not be found: " + catalogBgzipPath);
        }
        if (targetDirPath == null || targetDirPath.length() == 0) {
            targetDirPath = new File(catalogBgzipPath).getCanonicalFile().getParent();
        }
        if (!(targetDir = new File(targetDirPath).getCanonicalFile()).exists()) {
            throw new IOException("Target directory does not exist: " + targetDir);
        }
        if (!targetDir.isDirectory()) {
            throw new IOException("Target directory is not a directory: " + targetDir);
        }
        if (!targetDir.canWrite()) {
            throw new IOException("Target directory is not writable: " + targetDir);
        }
        String catalogFilenamePrefix = catalogFullFilename = catalogFile.getName();
        if (catalogFullFilename.endsWith(".tsv")) {
            catalogFilenamePrefix = catalogFullFilename.substring(0, catalogFullFilename.lastIndexOf(".tsv"));
        } else if (catalogFullFilename.endsWith(".tsv.bgz")) {
            catalogFilenamePrefix = catalogFullFilename.substring(0, catalogFullFilename.lastIndexOf(".tsv.bgz"));
        }
        File datasrcPropsFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".datasource.properties");
        File columnsPropsFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".columns.tsv");
        File blacklistFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".columns.tsv.blacklist");
        File blacklistBiorwebFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".columns.tsv.blacklist.biorweb");
        if (datasrcPropsFile.isDirectory()) {
            throw new IOException("Datasource properties file is an existing directory.  It should be a file");
        }
        if (columnsPropsFile.isDirectory()) {
            throw new IOException("Columns properties file is an existing directory.  It should be a file");
        }
        File file = originalVcfFile = isVcfSpecified ? new File(catalogOriginalVcfPath) : null;
        if (isVcfSpecified && (originalVcfFile == null || !originalVcfFile.exists())) {
            throw new IOException("Orginal VCF source file that the catalog was built from does not exist!: " + catalogOriginalVcfPath);
        }
        boolean isCrawlCatalog = !isVcfSpecified;
        this.warnIfLargeCatalog(catalogFile, isCrawlCatalog);
        this.createDatasourcePropsFile(datasrcPropsFile);
        this.createColumnPropsFile(columnsPropsFile, catalogFile, originalVcfFile, isVcfSpecified, progressHandler);
        try {
            File NewColumnsTsvFileObj = new File(columnsPropsFile.getCanonicalPath());
            this.createBlackListFiles(NewColumnsTsvFileObj, blacklistFile, blacklistBiorwebFile);
            if (!blacklistFile.exists() || !blacklistBiorwebFile.exists()) {
                throw new IOException("Unable to create the blacklist or blacklist biorweb file successfully.");
            }
        }
        catch (CatalogMetadataInputException i) {
            throw new InvalidDataException(i.getMessage());
        }
        catch (IOException io) {
            throw io;
        }
        sLogger.info((Object)"Done.");
    }

    private void warnIfLargeCatalog(File catalogFile, boolean isCrawlCatalog) {
        if (isCrawlCatalog) {
            boolean isBig;
            long MB = 0x100000L;
            boolean isZip = catalogFile.getName().toLowerCase().endsWith(".gz") || catalogFile.getName().toLowerCase().endsWith(".bgz");
            long sizeMB = catalogFile.length() / 0x100000L;
            boolean bl = isZip ? sizeMB > 50L : (isBig = sizeMB > 200L);
            if (isBig) {
                String msg = "  WARNING: Catalog is large (" + catalogFile.length() / 0x100000L + "MB).  This may take a while to process...";
                System.err.println(msg);
                sLogger.warn((Object)msg);
            }
        }
    }

    protected void createDatasourcePropsFile(File datasourcePropsFile) throws InvalidDataException, IOException, ConfigurationException {
        String catalogNamePrefix = datasourcePropsFile.getName().replace(".datasource.properties", "");
        String deployedDistributionDefault = "datasource.properties.default";
        String uri = this.getClass().getClassLoader().getResource(deployedDistributionDefault).getPath();
        File defaultDataSrcProps = null;
        if (uri != null && uri.length() > 0) {
            defaultDataSrcProps = new File(uri);
        } else {
            String testEnvDistributionDefault = "src/main/resources/datasource.properties.default";
            File testEnvDefaultDataSrcProps = new File(testEnvDistributionDefault);
            if (testEnvDefaultDataSrcProps.canRead()) {
                defaultDataSrcProps = testEnvDefaultDataSrcProps;
            } else {
                System.err.println("Unable to locate file:" + deployedDistributionDefault);
                throw new IOException("Unable to locate file:" + deployedDistributionDefault);
            }
        }
        String datasourcePropsContents = FileUtils.readFileToString((File)defaultDataSrcProps).replace("_CATALOG_PREFIX_", catalogNamePrefix);
        File dataSrcDefaultFile = new File(datasourcePropsFile.getParentFile().getCanonicalPath() + "/" + "build", datasourcePropsFile.getName() + ".default");
        FileUtils.writeStringToFile((File)dataSrcDefaultFile, (String)datasourcePropsContents);
        if (!datasourcePropsFile.exists()) {
            FileUtils.writeStringToFile((File)datasourcePropsFile, (String)datasourcePropsContents);
            this.logAll("Datasource properties file created at: " + datasourcePropsFile.getCanonicalPath());
        } else {
            this.logAll("Datasource properties file already exists.  No change.");
        }
    }

    private void logAll(String msg) {
        if (this.mStepLogger != null) {
            this.mStepLogger.logAndSummary(msg);
        }
        sLogger.info((Object)msg);
    }

    protected void createColumnPropsFile(File columnPropsFile, File catalogFile, File originalVcfFile, boolean isVcfSpecified, NumLineProgressHandler progressHandler) throws InvalidDataException, IOException, URISyntaxException {
        List<ColumnMetaData> colMetaList = this.mergeCrawlerWithVcf(catalogFile, originalVcfFile, isVcfSpecified, progressHandler);
        colMetaList = this.mergeWithDefaults(colMetaList);
        StringBuilder content = this.getColumnContents(columnPropsFile, colMetaList);
        File defaultColumnsTsvFile = new File(columnPropsFile.getParentFile().getCanonicalPath() + "/" + "build", columnPropsFile.getName() + ".default");
        FileUtils.writeStringToFile((File)defaultColumnsTsvFile, (String)content.toString());
        if (!columnPropsFile.exists()) {
            columnPropsFile.createNewFile();
            FileUtils.writeStringToFile((File)columnPropsFile, (String)content.toString());
            this.logAll("Columns properties file created at: " + columnPropsFile.getCanonicalPath());
        } else {
            this.logAll("Columns properties file already exists.  No change.");
        }
    }

    protected void createBlackListFiles(File columnPropsFile, File blacklistPropsFile, File blacklistBiorwebFile) throws CatalogMetadataInputException, IOException {
        String blacklistTopRow = "### These columns are to generally be ignored within UIs as they are duplicates or are normalized versions of the original columns.\n";
        String blacklistBiorwebTopRow = "### These fields will NOT be shown in BioRWeb.  All others will.\n";
        StringBuilder blackListContent = new StringBuilder("### If this file is NOT present, then assume that all fields, except for the golden attributes (those beginning with _) should be shown.\n### If this file is present, but contains no columns, then assume that all fields should be shown.\n");
        HashMap columnKeyToMetaMap = null;
        try {
            columnKeyToMetaMap = new ColumnMetaDataOperations(columnPropsFile).load();
        }
        catch (IOException e) {
            throw new CatalogMetadataInputException("Could not create blacklist file. Could not get columns.tsv info from file: " + columnPropsFile.getCanonicalPath() + "\nError: " + e.getMessage());
        }
        for (String colName : columnKeyToMetaMap.keySet()) {
            if (!this.isGoldenAttribute(colName)) continue;
            blackListContent.append(colName + "\n");
        }
        String buildDir = blacklistPropsFile.getParentFile().getCanonicalPath() + "/" + "build";
        File blacklistPropsFileDefault = new File(buildDir, blacklistPropsFile.getName() + ".default");
        FileUtils.writeStringToFile((File)blacklistPropsFileDefault, (String)(blacklistTopRow + blackListContent.toString()));
        File blacklistBiorwebFileDefault = new File(buildDir, blacklistBiorwebFile.getName() + ".default");
        FileUtils.writeStringToFile((File)blacklistBiorwebFileDefault, (String)(blacklistBiorwebTopRow + blackListContent.toString()));
        if (!blacklistPropsFile.exists()) {
            FileUtils.writeStringToFile((File)blacklistPropsFile, (String)(blacklistTopRow + blackListContent.toString()));
            this.logAll("Blacklist properties file created at: " + blacklistPropsFile.getCanonicalPath());
        } else {
            this.logAll("Blacklist properties file already exists.  No change.");
        }
        if (!blacklistBiorwebFile.exists()) {
            FileUtils.writeStringToFile((File)blacklistBiorwebFile, (String)(blacklistBiorwebTopRow + blackListContent.toString()));
            this.logAll("Blacklist (BioRWeb) properties file created at: " + blacklistBiorwebFile.getCanonicalPath());
        } else {
            this.logAll("Blacklist (BioRWeb) properties file already exists.  No change.");
        }
    }

    private boolean isGoldenAttribute(String colName) {
        GoldenAttribute[] goldenAttributes;
        for (GoldenAttribute golden : goldenAttributes = GoldenAttribute.values()) {
            if (!colName.equals(golden.name())) continue;
            return true;
        }
        return false;
    }

    private List<ColumnMetaData> mergeCrawlerWithVcf(File catalogFile, File originalVcfFile, boolean isVcfSpecified, NumLineProgressHandler progressHandler) throws IOException, InvalidDataException {
        ColumnMetaFromCatalogCrawling catalogCrawler = new ColumnMetaFromCatalogCrawling();
        List<ColumnMetaData> colMetaList = catalogCrawler.getColumnMetadata(catalogFile.getCanonicalPath(), progressHandler);
        if (isVcfSpecified && originalVcfFile != null && originalVcfFile.exists()) {
            List<ColumnMetaData> fromVcfColMetaList = new ColumnMetaFromVcf().getColumnMetadata(originalVcfFile.getCanonicalPath());
            for (ColumnMetaData colMetaVcf : fromVcfColMetaList) {
                for (int i = colMetaList.size() - 1; i >= 0; --i) {
                    if (!colMetaList.get(i).getColumnName().equals(colMetaVcf.getColumnName())) continue;
                    colMetaList.remove(i);
                }
                colMetaList.add(colMetaVcf);
            }
        }
        return colMetaList;
    }

    private List<ColumnMetaData> mergeWithDefaults(List<ColumnMetaData> colMetaList) throws URISyntaxException, IOException {
        File colDefaultsProps = ClasspathUtil.loadResource("/allCatalogs.columns.tsv");
        HashMap defaultsColNameToMetaMap = new AddMetadataLines().parseColumnProperties(colDefaultsProps.getCanonicalPath());
        for (int i = 0; i < colMetaList.size(); ++i) {
            String colName = colMetaList.get(i).getColumnName();
            if (!defaultsColNameToMetaMap.containsKey(colName)) continue;
            colMetaList.set(i, (ColumnMetaData)defaultsColNameToMetaMap.get(colName));
        }
        return colMetaList;
    }

    private StringBuilder getColumnContents(File columnPropsFile, List<ColumnMetaData> colMetaList) {
        ColumnMetaDataOperations colMetaOps = new ColumnMetaDataOperations();
        StringBuilder content = new StringBuilder(colMetaOps.getLinesAsString(colMetaOps.getDefaultColumnsTsvHeader()));
        Collections.sort(colMetaList);
        for (ColumnMetaData colMeta : colMetaList) {
            content.append(colMeta.toString() + "\n");
        }
        return content;
    }

    public class ProgressHandler
    implements NumLineProgressHandler {
        public long NUM_LINES_CALLBACK_ON = PROGRESS_HANDLER_NUM_LINES_CALLBACK_ON;

        @Override
        public long getNumLinesToCallbackOn() {
            return this.NUM_LINES_CALLBACK_ON;
        }

        @Override
        public void startingRead() {
            System.out.println("Reading lines from catalog:  .=" + this.NUM_LINES_CALLBACK_ON + "  o=" + this.NUM_LINES_CALLBACK_ON * 10L + "  |=" + this.NUM_LINES_CALLBACK_ON * 100L + "  X=" + this.NUM_LINES_CALLBACK_ON * 1000L);
        }

        @Override
        public void readNumLines(long numLines, long numLinesInFile) {
            if (numLines % (this.NUM_LINES_CALLBACK_ON * 1000L) == 0L) {
                System.out.println("X");
            } else if (numLines % (this.NUM_LINES_CALLBACK_ON * 100L) == 0L) {
                System.out.println("|");
            } else if (numLines % (this.NUM_LINES_CALLBACK_ON * 10L) == 0L) {
                System.out.print("o");
            } else if (numLines % this.NUM_LINES_CALLBACK_ON == 0L) {
                System.out.print(".");
            }
            if (numLines % 100000L == 0L) {
                sLogger.info((Object)String.format("Read %d lines of catalog", numLines));
            }
        }

        @Override
        public void readAllLines(long lineNumber) {
            System.out.println("\n# catalog lines crawled: " + lineNumber);
            sLogger.info((Object)String.format("Finished reading %d lines of catalog", lineNumber));
        }
    }
}

