/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.metadata;

import edu.mayo.pipes.util.FieldSpecification;

public class Metadata {
    private CmdType mCmdType;
    private String mDataSourceCanonicalPath;
    private String mColumnCanonicalPath;
    private String mOperator;
    private String mFullCanonicalPath;
    private String mDatasourcePath;
    private String mColumnsPath;
    private int mColNum = -1;
    private String[] mDrillPaths;
    private boolean mKeepJSON = false;
    private String[] mNewColNamesForDrillPaths;
    private String mDelimiter;
    private String mEscDelimiter;
    private FieldSpecification mCompressFieldSpecs;

    public Metadata(String operator) {
        this.mCmdType = CmdType.ToTJson;
        this.mOperator = operator;
    }

    public Metadata(String mFullCanonicalPath, String operator) {
        this.mCmdType = CmdType.Query;
        this.mOperator = operator;
        this.mFullCanonicalPath = mFullCanonicalPath;
    }

    public Metadata(int colNum, String operator, boolean keepJSON, String arrayDelimiter, String ... drillPaths) {
        this.mDrillPaths = drillPaths;
        this.mCmdType = CmdType.Drill;
        this.mOperator = operator;
        this.mKeepJSON = keepJSON;
        this.mColNum = colNum;
        this.mDelimiter = arrayDelimiter;
    }

    public Metadata(String fullCanonicalPathDataSourceProps, String fullCanonicalPathColumnProps, String operator) {
        this.mCmdType = CmdType.Tool;
        this.mColumnsPath = fullCanonicalPathColumnProps;
        this.mDatasourcePath = fullCanonicalPathDataSourceProps;
        this.mOperator = operator;
    }

    public Metadata(String operator, String fullCanonicalPathCatalog, String[] colNamesToAdd, String[] drillPaths) {
        this.mOperator = operator;
        this.mFullCanonicalPath = fullCanonicalPathCatalog;
        this.mNewColNamesForDrillPaths = colNamesToAdd;
        this.mDrillPaths = drillPaths;
        this.mCmdType = CmdType.Annotate;
    }

    public Metadata(String operator, String dataSourcecanonicalPath, String columnsCanonicalPath, String[] colNamesToAdd, String[] drillPaths) {
        this.mOperator = operator;
        this.mDataSourceCanonicalPath = dataSourcecanonicalPath;
        this.mColumnCanonicalPath = columnsCanonicalPath;
        this.mNewColNamesForDrillPaths = colNamesToAdd;
        this.mDrillPaths = drillPaths;
        this.mCmdType = CmdType.Annotate;
    }

    public Metadata(String operationOrCmdName, String delimiter, String escapedDelimiter, FieldSpecification fieldSpecs) {
        this.mDelimiter = delimiter;
        this.mEscDelimiter = escapedDelimiter;
        this.mCompressFieldSpecs = fieldSpecs;
        this.mCmdType = CmdType.Compress;
        this.mOperator = operationOrCmdName;
    }

    public CmdType getCmdType() {
        return this.mCmdType;
    }

    public void setCmdType(CmdType cmdType) {
        this.mCmdType = cmdType;
    }

    public String getFullCanonicalPath() {
        return this.mFullCanonicalPath;
    }

    public void setFullCanonicalPath(String fullCanonicalPath) {
        this.mFullCanonicalPath = fullCanonicalPath;
    }

    public int getColNum() {
        return this.mColNum;
    }

    public void setColNum(int colNum) {
        this.mColNum = colNum;
    }

    public String[] getDrillPaths() {
        return this.mDrillPaths;
    }

    public void setDrillPaths(String[] drillPaths) {
        this.mDrillPaths = drillPaths;
    }

    public String getOperator() {
        return this.mOperator;
    }

    public void setOperator(String operator) {
        this.mOperator = operator;
    }

    public boolean isKeepJSON() {
        return this.mKeepJSON;
    }

    public void setKeepJSON(boolean keepJSON) {
        this.mKeepJSON = keepJSON;
    }

    public String getDatasourcePath() {
        return this.mDatasourcePath;
    }

    public void setDatasourcePath(String datasourcePath) {
        this.mDatasourcePath = datasourcePath;
    }

    public String getColumnsPath() {
        return this.mColumnsPath;
    }

    public void setColumnsPath(String columnsPath) {
        this.mColumnsPath = columnsPath;
    }

    public String[] getNewColNamesForDrillPaths() {
        return this.mNewColNamesForDrillPaths;
    }

    public void setNewColNamesForDrillPaths(String[] newColNamesForDrillPaths) {
        this.mNewColNamesForDrillPaths = newColNamesForDrillPaths;
    }

    public String getDataSourceCanonicalPath() {
        return this.mDataSourceCanonicalPath;
    }

    public void setDataSourceCanonicalPath(String dataSourceCanonicalPath) {
        this.mDataSourceCanonicalPath = dataSourceCanonicalPath;
    }

    public String getColumnCanonicalPath() {
        return this.mColumnCanonicalPath;
    }

    public void setColumnCanonicalPath(String columnCanonicalPath) {
        this.mColumnCanonicalPath = columnCanonicalPath;
    }

    public String getDelimiter() {
        return this.mDelimiter;
    }

    public void setDelimiter(String delimiter) {
        this.mDelimiter = delimiter;
    }

    public String getEscapedDelimiter() {
        return this.mEscDelimiter;
    }

    public void setEscapedDelimiter(String escapedDelimiter) {
        this.mEscDelimiter = escapedDelimiter;
    }

    public FieldSpecification getCompressFieldSpecs() {
        return this.mCompressFieldSpecs;
    }

    public void setCompressFieldSpecs(FieldSpecification fieldSpecs) {
        this.mCompressFieldSpecs = fieldSpecs;
    }

    public static enum CmdType {
        Query,
        Drill,
        ToTJson,
        Tool,
        Annotate,
        Compress;

    }
}

