/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class BiorProperties {
    private static final String BIOR_PROP = "BIOR_PROP";
    private static String file;
    private Properties mProp = null;
    private static Logger sLogger;
    private final String DEFAULT_PROP_FILE_NAME = "bior.properties";

    private void initFile() {
        if (System.getenv(BIOR_PROP) != null) {
            file = System.getenv(BIOR_PROP);
        } else if (new File(System.getenv("HOME") + "/" + "bior.properties").exists()) {
            file = System.getenv("HOME") + "/" + "bior.properties";
        } else if (System.getProperty(BIOR_PROP) != null) {
            file = System.getProperty(BIOR_PROP);
        } else if (new File(System.getenv("user.dir") + "/" + "bior.properties").exists()) {
            file = System.getProperty("user.dir") + "/" + "bior.properties";
        } else if (BiorProperties.class.getClassLoader().getResource("bior.properties") != null) {
            URL url = BiorProperties.class.getClassLoader().getResource("bior.properties");
            file = url.getFile();
        }
        sLogger.info((Object)("using " + file + " for " + "bior.properties"));
    }

    public static void setFile(String f) {
        file = f;
    }

    public static String getFile() {
        return file;
    }

    public BiorProperties() throws IOException {
        if (file == null) {
            this.initFile();
        }
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            this.mProp = new Properties();
            this.mProp.load(inStream);
        }
        catch (IOException ex) {
            sLogger.error((Object)("Error loading properties file: " + file), (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ex) {
                sLogger.error((Object)("Error closing properties file: " + file), (Throwable)ex);
                throw ex;
            }
        }
    }

    public String get(Key key) {
        return this.mProp.getProperty(key.toString());
    }

    public int getAsInt(Key key, int defaultVal) {
        String valStr = this.get(key);
        int valInt = this.isInteger(valStr) ? Integer.parseInt(valStr) : defaultVal;
        return valInt;
    }

    private boolean isInteger(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String get(String key) {
        return this.mProp.getProperty(key);
    }

    public Set<String> keySet() {
        return this.mProp.stringPropertyNames();
    }

    static {
        sLogger = Logger.getLogger(BiorProperties.class);
    }

    public static enum Key {
        refAssemblyBaseDir,
        AnnotateMaxLinesInFlight,
        TimeoutCommand,
        MaxAlts,
        SnpEffCmd,
        SnpEffJar,
        SnpEffConfig,
        BiorVepPerl,
        BiorVep,
        BiorVepCache,
        BiorVepCmdFlags,
        BiorVepBufferSize,
        fileBase,
        genesFile,
        hgncFile,
        hgncIndexFile,
        hgncEnsemblGeneIndexFile,
        omimFile,
        omimIndexFile,
        dbsnpFile,
        dbsnpClinvarFile,
        cosmicFile,
        blacklistedFile,
        conservationFile,
        enhancerFile,
        tfbsFile,
        tssFile,
        uniqueFile,
        repeatFile,
        regulationFile,
        mirBaseFile,
        bgiFile,
        espFile,
        hapMapFile,
        kGenomeFile,
        catalogListFile,
        humanRefSeqGrch37File,
        humanRefChrSizesGrch37File,
        humanRefChrOrderGrch37File,
        humanRefSeqGrch38File,
        humanRefChrSizesGrch38File,
        humanRefChrOrderGrch38File;

    }
}

