/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import java.util.NoSuchElementException;

public class GFF32JSONPipe
extends AbstractPipe<History, History> {
    int count = 0;

    protected History processNextStart() throws NoSuchElementException {
        ++this.count;
        History h = (History)this.starts.next();
        h.add(this.makeJSON(h).toString());
        return h;
    }

    public JsonObject makeJSON(History h) throws NoSuchElementException {
        JsonObject ret = new JsonObject();
        ret.add("seqid", (JsonElement)new JsonPrimitive((String)h.get(0)));
        if (((String)h.get(0)).contains("//")) {
            throw new NoSuchElementException();
        }
        if (h.size() != 9) {
            StringBuilder sb = new StringBuilder();
            sb.append("Malformed GFF3 file on line: ");
            sb.append(this.count);
            sb.append("\n");
            sb.append("Column Count: ");
            sb.append(h.size());
            sb.append("\n");
            for (String s : h) {
                sb.append(s);
                sb.append("\t");
            }
            sb.append("\n");
            throw new InvalidPipeInputException(sb.toString(), (Pipe)new GFF32JSONPipe());
        }
        ret.add("source", (JsonElement)new JsonPrimitive((String)h.get(1)));
        ret.add("type", (JsonElement)new JsonPrimitive((String)h.get(2)));
        Integer minBP = 0;
        Integer maxBP = 0;
        try {
            minBP = Integer.valueOf((String)h.get(3));
            maxBP = Integer.valueOf((String)h.get(4));
        }
        catch (Exception s) {
            // empty catch block
        }
        ret.add("start", (JsonElement)new JsonPrimitive((Number)minBP));
        ret.add("end", (JsonElement)new JsonPrimitive((Number)maxBP));
        Double score = 0.0;
        try {
            score = Double.valueOf((String)h.get(5));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ret.add("score", (JsonElement)new JsonPrimitive((Number)score));
        String strand = (String)h.get(6);
        if (!strand.equals("+") && !strand.equals("-")) {
            strand = ".";
        }
        ret.add("strand", (JsonElement)new JsonPrimitive(strand));
        ret.add("phase", (JsonElement)new JsonPrimitive((String)h.get(7)));
        ret.add("attributes", (JsonElement)this.parseAttributes((String)h.get(8)));
        ret.add(CoreAttributes._landmark.toString(), (JsonElement)new JsonPrimitive((String)h.get(0)));
        ret.add(CoreAttributes._minBP.toString(), (JsonElement)new JsonPrimitive((Number)minBP));
        ret.add(CoreAttributes._maxBP.toString(), (JsonElement)new JsonPrimitive((Number)maxBP));
        ret.add(CoreAttributes._strand.toString(), (JsonElement)new JsonPrimitive(strand));
        return ret;
    }

    public JsonObject parseAttributes(String attributeString) {
        String[] keyValues;
        JsonObject attributes = new JsonObject();
        for (String s : keyValues = attributeString.split(";")) {
            String[] pair;
            if (!s.contains("=") || (pair = s.split("=")).length != 2) continue;
            attributes.add(pair[0], (JsonElement)new JsonPrimitive(pair[1]));
        }
        return attributes;
    }
}

