/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.fastq.FastqReader;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.FastqQualityFormat;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;

public class QualityEncodingDetector {
    private QualityRecordAggregator qualityAggregator = new QualityRecordAggregator();
    public static final long DEFAULT_MAX_RECORDS_TO_ITERATE = 10000L;
    private static final Log log = Log.getInstance(QualityEncodingDetector.class);

    public long add(long l, FastqReader ... fastqReaderArray) {
        Iterator<FastqRecord> iterator = QualityEncodingDetector.generateInterleavedFastqIterator(fastqReaderArray);
        long l2 = 0L;
        while (iterator.hasNext() && l2++ != l) {
            this.add(iterator.next());
        }
        log.debug(String.format("Read %s records from %s.", l2, Arrays.toString(fastqReaderArray)));
        return l2;
    }

    public long add(long l, SamReader samReader) {
        return this.add(l, samReader.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(long l, CloseableIterator<SAMRecord> closeableIterator, boolean bl) {
        long l2 = 0L;
        try {
            while (closeableIterator.hasNext() && l2++ != l) {
                this.add((SAMRecord)closeableIterator.next(), bl);
            }
            long l3 = l2;
            return l3;
        }
        finally {
            closeableIterator.close();
        }
    }

    public long add(long l, CloseableIterator<SAMRecord> closeableIterator) {
        return this.add(l, closeableIterator, false);
    }

    public void add(FastqRecord fastqRecord) {
        this.qualityAggregator.add(fastqRecord);
    }

    public void add(SAMRecord sAMRecord, boolean bl) {
        this.qualityAggregator.add(sAMRecord, bl);
    }

    public void add(SAMRecord sAMRecord) {
        this.add(sAMRecord, false);
    }

    public boolean isDeterminationAmbiguous() {
        return this.generateCandidateQualities(true).size() > 1;
    }

    public EnumSet<FastqQualityFormat> generateCandidateQualities(boolean bl) {
        EnumSet<FastqQualityFormat> enumSet = EnumSet.allOf(FastqQualityFormat.class);
        Set<Integer> set = this.qualityAggregator.getObservedAsciiQualities();
        if (set.isEmpty()) {
            throw new SAMException("Cannot determine candidate qualities: no qualities found.");
        }
        for (QualityScheme qualityScheme : QualityScheme.values()) {
            Iterator<Integer> iterator = set.iterator();
            ArrayList<Range> arrayList = new ArrayList<Range>(qualityScheme.expectedAsciiRanges);
            while (iterator.hasNext()) {
                int n = iterator.next();
                if (!qualityScheme.asciiRange.contains(n)) {
                    enumSet.remove((Object)qualityScheme.qualityFormat);
                }
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    if (!((Range)iterator2.next()).contains(n)) continue;
                    iterator2.remove();
                }
            }
            if (arrayList.isEmpty() || !bl) continue;
            enumSet.remove((Object)qualityScheme.qualityFormat);
        }
        return enumSet;
    }

    private static Iterator<FastqRecord> generateInterleavedFastqIterator(final FastqReader ... fastqReaderArray) {
        return new Iterator<FastqRecord>(){
            private Queue<Iterator<FastqRecord>> queue = new LinkedList<Iterator<FastqRecord>>();
            {
                for (FastqReader fastqReader : fastqReaderArray) {
                    this.queue.add(fastqReader.iterator());
                }
            }

            @Override
            public boolean hasNext() {
                while (!this.queue.isEmpty()) {
                    if (this.queue.peek().hasNext()) {
                        return true;
                    }
                    this.queue.poll();
                }
                return false;
            }

            @Override
            public FastqRecord next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator<FastqRecord> iterator = this.queue.poll();
                FastqRecord fastqRecord = iterator.next();
                this.queue.offer(iterator);
                return fastqRecord;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static FastqQualityFormat detect(long l, FastqReader ... fastqReaderArray) {
        QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
        long l2 = qualityEncodingDetector.add(l, fastqReaderArray);
        log.debug(String.format("Read %s records from %s.", l2, Arrays.toString(fastqReaderArray)));
        return qualityEncodingDetector.generateBestGuess(FileContext.FASTQ, null);
    }

    public static FastqQualityFormat detect(FastqReader ... fastqReaderArray) {
        return QualityEncodingDetector.detect(10000L, fastqReaderArray);
    }

    public static FastqQualityFormat detect(long l, CloseableIterator<SAMRecord> closeableIterator, boolean bl) {
        QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
        long l2 = qualityEncodingDetector.add(l, closeableIterator, bl);
        log.debug(String.format("Read %s records.", l2));
        return qualityEncodingDetector.generateBestGuess(FileContext.SAM, null);
    }

    public static FastqQualityFormat detect(long l, CloseableIterator<SAMRecord> closeableIterator) {
        return QualityEncodingDetector.detect(l, closeableIterator, false);
    }

    public static FastqQualityFormat detect(long l, SamReader samReader) {
        return QualityEncodingDetector.detect(l, samReader.iterator());
    }

    public static FastqQualityFormat detect(SamReader samReader) {
        return QualityEncodingDetector.detect(10000L, samReader);
    }

    public static FastqQualityFormat detect(SamReader samReader, FastqQualityFormat fastqQualityFormat) {
        QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
        long l = qualityEncodingDetector.add(10000L, samReader.iterator());
        log.debug(String.format("Read %s records from %s.", l, samReader));
        return qualityEncodingDetector.generateBestGuess(FileContext.SAM, fastqQualityFormat);
    }

    public FastqQualityFormat generateBestGuess(FileContext fileContext, FastqQualityFormat fastqQualityFormat) {
        if (null != fastqQualityFormat) {
            EnumSet<FastqQualityFormat> enumSet = this.generateCandidateQualities(false);
            if (enumSet.contains((Object)fastqQualityFormat)) {
                return fastqQualityFormat;
            }
            throw new SAMException(String.format("The quality values do not fall in the range appropriate for the expected quality of %s.", fastqQualityFormat.name()));
        }
        EnumSet<FastqQualityFormat> enumSet = this.generateCandidateQualities(true);
        switch (enumSet.size()) {
            case 1: {
                return (FastqQualityFormat)((Object)enumSet.iterator().next());
            }
            case 2: {
                if (enumSet.equals(EnumSet.of(FastqQualityFormat.Illumina, FastqQualityFormat.Solexa))) {
                    return FastqQualityFormat.Illumina;
                }
                if (enumSet.equals(EnumSet.of(FastqQualityFormat.Illumina, FastqQualityFormat.Standard))) {
                    switch (fileContext) {
                        case FASTQ: {
                            return FastqQualityFormat.Illumina;
                        }
                        case SAM: {
                            return FastqQualityFormat.Standard;
                        }
                    }
                } else {
                    if (enumSet.equals(EnumSet.of(FastqQualityFormat.Standard, FastqQualityFormat.Solexa))) {
                        return FastqQualityFormat.Standard;
                    }
                    throw new SAMException("Unreachable code.");
                }
            }
            case 3: {
                throw new SAMException("The quality format cannot be determined: no formats were excluded.");
            }
            case 0: {
                throw new SAMException("The quality format cannot be determined: all formats were excluded.");
            }
        }
        throw new SAMException("Unreachable code.");
    }

    private static class QualityRecordAggregator {
        private Set<Integer> observedAsciiQualities = new HashSet<Integer>();

        private QualityRecordAggregator() {
        }

        public Set<Integer> getObservedAsciiQualities() {
            return Collections.unmodifiableSet(this.observedAsciiQualities);
        }

        public void add(FastqRecord fastqRecord) {
            this.addAsciiQuality(fastqRecord.getBaseQualityString().getBytes());
        }

        public void add(SAMRecord sAMRecord, boolean bl) {
            this.addAsciiQuality(bl && sAMRecord.getOriginalBaseQualities() != null ? SAMUtils.phredToFastq(sAMRecord.getOriginalBaseQualities()).getBytes() : sAMRecord.getBaseQualityString().getBytes());
        }

        public void add(SAMRecord sAMRecord) {
            this.add(sAMRecord, false);
        }

        private void addAsciiQuality(byte ... byArray) {
            for (byte by : byArray) {
                this.observedAsciiQualities.add(Integer.valueOf(by));
            }
        }
    }

    static enum QualityScheme {
        Phred(new Range(0, 93), new Range(33, 126), Arrays.asList(new Range(33, 58)), FastqQualityFormat.Standard),
        Solexa(new Range(-5, 62), new Range(59, 126), new ArrayList<Range>(), FastqQualityFormat.Solexa),
        Illumina(new Range(0, 62), new Range(64, 126), new ArrayList<Range>(), FastqQualityFormat.Illumina);

        final Range rawRange;
        final Range asciiRange;
        final List<Range> expectedAsciiRanges;
        final FastqQualityFormat qualityFormat;

        private QualityScheme(Range range, Range range2, List<Range> list, FastqQualityFormat fastqQualityFormat) {
            this.rawRange = range;
            this.asciiRange = range2;
            this.expectedAsciiRanges = list;
            this.qualityFormat = fastqQualityFormat;
        }
    }

    static class Range {
        final int low;
        final int high;

        Range(int n, int n2) {
            this.low = n;
            this.high = n2;
        }

        boolean contains(int n) {
            return n <= this.high && n >= this.low;
        }
    }

    public static enum FileContext {
        FASTQ,
        SAM;

    }
}

