/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;

public class ByteArraySeekableStream
extends SeekableStream {
    private byte[] bytes;
    private long position = 0L;

    public ByteArraySeekableStream(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public void seek(long l) throws IOException {
        this.position = l;
    }

    @Override
    public int read() throws IOException {
        if (this.position < (long)this.bytes.length) {
            return 0xFF & this.bytes[(int)this.position++];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= (long)this.bytes.length) {
            return -1;
        }
        if (this.position + (long)n2 > (long)this.bytes.length) {
            n2 = (int)((long)this.bytes.length - this.position);
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.bytes, (int)this.position, byArray, n, n2);
        this.position += (long)n2;
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.bytes = null;
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= (long)this.bytes.length;
    }

    @Override
    public String getSource() {
        return null;
    }
}

