/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersionPolicies;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerHeaderIO;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SliceIO;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.compress.utils.CountingOutputStream;

public class ContainerIO {
    private static final Log log = Log.getInstance(ContainerIO.class);

    public static Container readContainer(Version version, InputStream inputStream) throws IOException {
        Container container = ContainerIO.readContainer(version.major, inputStream);
        if (container == null) {
            CramVersionPolicies.eofNotFound(version);
            return ContainerIO.readContainer(version.major, (InputStream)new ByteArrayInputStream(CramIO.ZERO_B_EOF_MARKER));
        }
        if (container.isEOF()) {
            log.debug("EOF marker found, file/stream is complete.");
        }
        return container;
    }

    private static Container readContainer(int n, InputStream inputStream) throws IOException {
        return ContainerIO.readContainer(n, inputStream, 0, Integer.MAX_VALUE);
    }

    public static Container readContainerHeader(int n, InputStream inputStream) throws IOException {
        ContainerHeaderIO containerHeaderIO = new ContainerHeaderIO();
        Container container = new Container();
        if (!containerHeaderIO.readContainerHeader(n, container, inputStream)) {
            containerHeaderIO.readContainerHeader(container, new ByteArrayInputStream(n >= 3 ? CramIO.ZERO_F_EOF_MARKER : CramIO.ZERO_B_EOF_MARKER));
            return container;
        }
        return container;
    }

    private static Container readContainer(int n, InputStream inputStream, int n2, int n3) throws IOException {
        long l = System.nanoTime();
        Container container = ContainerIO.readContainerHeader(n, inputStream);
        if (container.isEOF()) {
            return container;
        }
        Block block = Block.readFromInputStream(n, inputStream);
        if (block.getContentType() != BlockContentType.COMPRESSION_HEADER) {
            throw new RuntimeException("Content type does not match: " + block.getContentType().name());
        }
        container.header = new CompressionHeader();
        container.header.read(block.getRawContent());
        n3 = Math.min(container.landmarks.length, n3);
        if (n2 > 0) {
            inputStream.skip(container.landmarks[n2]);
        }
        ArrayList<Slice> arrayList = new ArrayList<Slice>();
        int n4 = n2;
        while (n4 < n3 - n2) {
            Slice slice = new Slice();
            SliceIO.read(n, slice, inputStream);
            slice.index = n4++;
            arrayList.add(slice);
        }
        container.slices = arrayList.toArray(new Slice[arrayList.size()]);
        ContainerIO.calculateSliceOffsetsAndSizes(container);
        long l2 = System.nanoTime();
        log.debug("READ CONTAINER: " + container.toString());
        container.readTime = l2 - l;
        return container;
    }

    private static void calculateSliceOffsetsAndSizes(Container container) {
        if (container.slices.length == 0) {
            return;
        }
        int n = 0;
        while (n < container.slices.length - 1) {
            Slice slice = container.slices[n];
            slice.offset = container.landmarks[n];
            slice.size = container.landmarks[n + 1] - slice.offset;
            slice.containerOffset = container.offset;
            slice.index = n++;
        }
        Slice slice = container.slices[container.slices.length - 1];
        slice.offset = container.landmarks[container.landmarks.length - 1];
        slice.size = container.containerByteSize - slice.offset;
        slice.containerOffset = container.offset;
        slice.index = container.slices.length - 1;
    }

    public static int writeContainerHeader(int n, Container container, OutputStream outputStream) throws IOException {
        return new ContainerHeaderIO().writeContainerHeader(n, container, outputStream);
    }

    public static int writeContainer(Version version, Container container, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray;
        if (container.blocks != null && container.blocks.length > 0) {
            boolean bl;
            Block block = container.blocks[0];
            boolean bl2 = bl = block.getContentType() == BlockContentType.FILE_HEADER;
            if (bl) {
                ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
                block.write(version.major, exposedByteArrayOutputStream);
                container.containerByteSize = exposedByteArrayOutputStream.size();
                int n2 = new ContainerHeaderIO().writeContainerHeader(version.major, container, outputStream);
                outputStream.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
                return n2 + exposedByteArrayOutputStream.size();
            }
        }
        long l = System.nanoTime();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        Block block = new Block();
        block.setContentType(BlockContentType.COMPRESSION_HEADER);
        block.setContentId(0);
        block.setMethod(BlockCompressionMethod.RAW);
        try {
            byArray = container.header.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("This should have never happened.");
        }
        block.setRawContent(byArray);
        block.write(version.major, exposedByteArrayOutputStream);
        container.blockCount = 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < container.slices.length; ++n) {
            Slice slice = container.slices[n];
            arrayList.add(exposedByteArrayOutputStream.size());
            SliceIO.write(version.major, slice, exposedByteArrayOutputStream);
            ++container.blockCount;
            ++container.blockCount;
            if (slice.embeddedRefBlock != null) {
                ++container.blockCount;
            }
            container.blockCount += slice.external.size();
        }
        container.landmarks = new int[arrayList.size()];
        for (n = 0; n < container.landmarks.length; ++n) {
            container.landmarks[n] = (Integer)arrayList.get(n);
        }
        container.containerByteSize = exposedByteArrayOutputStream.size();
        ContainerIO.calculateSliceOffsetsAndSizes(container);
        n = new ContainerHeaderIO().writeContainerHeader(version.major, container, outputStream);
        outputStream.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
        long l2 = System.nanoTime();
        log.debug("CONTAINER WRITTEN: " + container.toString());
        container.writeTime = l2 - l;
        return n += exposedByteArrayOutputStream.size();
    }

    public static long getByteSize(Version version, Container container) {
        CountingOutputStream countingOutputStream = new CountingOutputStream(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
            }
        });
        try {
            ContainerIO.writeContainer(version, container, (OutputStream)countingOutputStream);
            countingOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return countingOutputStream.getBytesWritten();
    }
}

