/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LTF8 {
    public static long readUnsignedLTF8(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        if ((n & 0x80) == 0) {
            return n;
        }
        if ((n & 0x40) == 0) {
            return (n & 0x7F) << 8 | inputStream.read();
        }
        if ((n & 0x20) == 0) {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            return (n & 0x3F) << 16 | n2 << 8 | n3;
        }
        if ((n & 0x10) == 0) {
            long l = (long)(n & 0x1F) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 8) == 0) {
            long l = (long)(n & 0xF) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 4) == 0) {
            long l = (long)(n & 7) << 40;
            l |= (0xFFL & (long)inputStream.read()) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 2) == 0) {
            long l = (long)(n & 3) << 48;
            l |= (0xFFL & (long)inputStream.read()) << 40;
            l |= (0xFFL & (long)inputStream.read()) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        if ((n & 1) == 0) {
            long l = (0xFFL & (long)inputStream.read()) << 48;
            l |= (0xFFL & (long)inputStream.read()) << 40;
            l |= (0xFFL & (long)inputStream.read()) << 32;
            l |= (0xFFL & (long)inputStream.read()) << 24;
            l |= (long)(inputStream.read() << 16);
            l |= (long)(inputStream.read() << 8);
            return l |= (long)inputStream.read();
        }
        long l = (0xFFL & (long)inputStream.read()) << 56;
        l |= (0xFFL & (long)inputStream.read()) << 48;
        l |= (0xFFL & (long)inputStream.read()) << 40;
        l |= (0xFFL & (long)inputStream.read()) << 32;
        l |= (0xFFL & (long)inputStream.read()) << 24;
        l |= (long)(inputStream.read() << 16);
        l |= (long)(inputStream.read() << 8);
        return l |= (long)inputStream.read();
    }

    public static int writeUnsignedLTF8(long l, OutputStream outputStream) throws IOException {
        if (l >>> 7 == 0L) {
            outputStream.write((int)l);
            return 8;
        }
        if (l >>> 14 == 0L) {
            outputStream.write((int)(l >> 8 | 0x80L));
            outputStream.write((int)(l & 0xFFL));
            return 16;
        }
        if (l >>> 21 == 0L) {
            outputStream.write((int)(l >> 16 | 0xC0L));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 24;
        }
        if (l >>> 28 == 0L) {
            outputStream.write((int)(l >> 24 | 0xE0L));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 32;
        }
        if (l >>> 35 == 0L) {
            outputStream.write((int)(l >> 32 | 0xF0L));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 40;
        }
        if (l >>> 42 == 0L) {
            outputStream.write((int)(l >> 40 | 0xF8L));
            outputStream.write((int)(l >> 32 & 0xFFL));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 48;
        }
        if (l >>> 49 == 0L) {
            outputStream.write((int)(l >> 48 | 0xFCL));
            outputStream.write((int)(l >> 40 & 0xFFL));
            outputStream.write((int)(l >> 32 & 0xFFL));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 56;
        }
        if (l >>> 56 == 0L) {
            outputStream.write(254);
            outputStream.write((int)(l >> 48 & 0xFFL));
            outputStream.write((int)(l >> 40 & 0xFFL));
            outputStream.write((int)(l >> 32 & 0xFFL));
            outputStream.write((int)(l >> 24 & 0xFFL));
            outputStream.write((int)(l >> 16 & 0xFFL));
            outputStream.write((int)(l >> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
            return 64;
        }
        outputStream.write(255);
        outputStream.write((int)(l >> 56 & 0xFFL));
        outputStream.write((int)(l >> 48 & 0xFFL));
        outputStream.write((int)(l >> 40 & 0xFFL));
        outputStream.write((int)(l >> 32 & 0xFFL));
        outputStream.write((int)(l >> 28 & 0xFFL));
        outputStream.write((int)(l >> 16 & 0xFFL));
        outputStream.write((int)(l >> 8 & 0xFFL));
        outputStream.write((int)(l & 0xFFL));
        return 72;
    }
}

