/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DefaultBitOutputStream
extends OutputStream
implements BitOutputStream {
    private static final byte[] bitMasks = new byte[8];
    private final OutputStream out;
    private int bufferByte = 0;
    private int bufferedNumberOfBits = 0;

    public DefaultBitOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(byte by) throws IOException {
        this.out.write(by);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public String toString() {
        return "DefaultBitOutputStream: " + Integer.toBinaryString(this.bufferByte).substring(0, this.bufferedNumberOfBits);
    }

    @Override
    public void write(long l, int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (n < 1 || n > 64) {
            throw new IOException("Expecting 1 to 64 bits, got: value=" + l + ", nofBits=" + n);
        }
        if (n <= 8) {
            this.write((byte)l, n);
        } else {
            byte by;
            for (by = n - 8; by >= 0; by -= 8) {
                byte by2 = (byte)(l >>> by);
                this.writeByte(by2);
            }
            if (n % 8 != 0) {
                by = (byte)l;
                this.write(by, n % 8);
            }
        }
    }

    void write_int_LSB_0(int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (n2 < 1 || n2 > 32) {
            throw new IOException("Expecting 1 to 32 bits.");
        }
        if (n2 <= 8) {
            this.write((byte)n, n2);
        } else {
            byte by;
            for (by = n2 - 8; by >= 0; by -= 8) {
                byte by2 = (byte)(n >>> by);
                this.writeByte(by2);
            }
            if (n2 % 8 != 0) {
                by = (byte)n;
                this.write(by, n2 % 8);
            }
        }
    }

    @Override
    public void write(int n, int n2) throws IOException {
        this.write_int_LSB_0(n, n2);
    }

    private void writeByte(int n) throws IOException {
        if (this.bufferedNumberOfBits == 0) {
            this.out.write(n);
        } else {
            this.bufferByte = (n & 0xFF) >>> this.bufferedNumberOfBits | this.bufferByte;
            this.out.write(this.bufferByte);
            this.bufferByte = n << 8 - this.bufferedNumberOfBits & 0xFF;
        }
    }

    @Override
    public void write(byte by, int n) throws IOException {
        if (n < 0 || n > 8) {
            throw new IOException("Expecting 0 to 8 bits.");
        }
        if (n == 8) {
            this.writeByte(by);
        } else if (this.bufferedNumberOfBits == 0) {
            this.bufferByte = by << 8 - n & 0xFF;
            this.bufferedNumberOfBits = n;
        } else {
            by = (byte)(by & ~bitMasks[8 - n]);
            int n2 = 8 - this.bufferedNumberOfBits - n;
            if (n2 < 0) {
                n2 = -n2;
                this.bufferByte |= by >>> n2;
                this.out.write(this.bufferByte);
                this.bufferByte = by << 8 - n2 & 0xFF;
                this.bufferedNumberOfBits = n2;
            } else if (n2 == 0) {
                this.bufferByte |= by;
                this.out.write(this.bufferByte);
                this.bufferedNumberOfBits = 0;
            } else {
                this.bufferByte |= by << n2;
                this.bufferedNumberOfBits = 8 - n2;
            }
        }
    }

    @Override
    public void write(boolean bl) throws IOException {
        this.write(bl ? (byte)1 : 0, 1);
    }

    @Override
    public void write(boolean bl, long l) throws IOException {
        for (long i = 0L; i < l; ++i) {
            this.write(bl);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.bufferedNumberOfBits > 0) {
            this.out.write(this.bufferByte);
        }
        this.bufferedNumberOfBits = 0;
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    static {
        for (int n = 0; n < 8; n = (int)((byte)(n + 1))) {
            DefaultBitOutputStream.bitMasks[n] = (byte)(~(255 >>> n));
        }
    }
}

