/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.BitInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DefaultBitInputStream
extends DataInputStream
implements BitInputStream {
    private int nofBufferedBits = 0;
    private int byteBuffer = 0;
    private boolean throwEOF = true;
    private static final long[] masks = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L};

    public DefaultBitInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public final boolean readBit() throws IOException {
        if (--this.nofBufferedBits >= 0) {
            return (this.byteBuffer >>> this.nofBufferedBits & 1) == 1;
        }
        this.nofBufferedBits = 7;
        this.byteBuffer = this.in.read();
        if (this.byteBuffer == -1 && this.throwEOF) {
            throw new EOFException("End of stream.");
        }
        return (this.byteBuffer >>> 7 & 1) == 1;
    }

    @Override
    public final int readBits(int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        while (n > this.nofBufferedBits) {
            n2 |= DefaultBitInputStream.rightBits(this.nofBufferedBits, this.byteBuffer) << (n -= this.nofBufferedBits);
            this.byteBuffer = this.in.read();
            if (this.byteBuffer == -1) {
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        return n2 | DefaultBitInputStream.rightBits(n, this.byteBuffer >>> this.nofBufferedBits);
    }

    private static int rightBits(int n, int n2) {
        return n2 & (1 << n) - 1;
    }

    @Override
    public final long readLongBits(int n) throws IOException {
        if (n > 64) {
            throw new RuntimeException("More then 64 bits are requested in one read from bit stream.");
        }
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        long l2 = this.byteBuffer;
        if (this.nofBufferedBits == 0) {
            l2 = this.in.read();
            if (l2 == -1L) {
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        l2 &= masks[this.nofBufferedBits];
        while (n > this.nofBufferedBits) {
            l |= l2 << (n -= this.nofBufferedBits);
            l2 = this.in.read();
            if (l2 == -1L) {
                throw new EOFException("End of stream.");
            }
            this.nofBufferedBits = 8;
        }
        this.nofBufferedBits -= n;
        this.byteBuffer = (int)(l2 & masks[this.nofBufferedBits]);
        return l | l2 >>> this.nofBufferedBits;
    }

    @Override
    public void reset() {
        this.nofBufferedBits = 0;
        this.byteBuffer = 0;
    }
}

