/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private final InputStream delegate;
    private long count = 0L;

    public CountingInputStream(InputStream inputStream) {
        this.delegate = inputStream;
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        return this.delegate.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.delegate.read(byArray);
        this.count += (long)n;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.delegate.read(byArray, n, n2);
        this.count += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.delegate.skip(l);
        this.count += l2;
        return l2;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public void mark(int n) {
        this.delegate.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
        this.count = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public long getCount() {
        return this.count;
    }
}

